import { DefaultTestFileLoader } from '../internal/file_loader.js';
import { parseQuery } from '../internal/query/parseQuery.js';
import { assert } from '../util/util.js';

(async () => {
  for (const suite of ['unittests', 'webgpu']) {
    const loader = new DefaultTestFileLoader();
    const filterQuery = parseQuery(`${suite}:*`);
    const testcases = await loader.loadCases(filterQuery);
    for (const testcase of testcases) {
      const name = testcase.query.toString();
      const maxLength = 375;
      assert(
        name.length <= maxLength,
        `Testcase ${name} is too long. Max length is ${maxLength} characters. Please shorten names or reduce parameters.`
      );
    }
  }
})();
