/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.x4o.xml.eld.doc.api.ApiDocContentCss;
import org.x4o.xml.eld.doc.api.ApiDocContentWriter;
import org.x4o.xml.eld.doc.api.dom.ApiDoc;
import org.x4o.xml.eld.doc.api.dom.ApiDocConcept;
import org.x4o.xml.eld.doc.api.dom.ApiDocNode;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeBody;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeWriter;
import org.x4o.xml.eld.doc.api.dom.ApiDocPage;
import org.x4o.xml.eld.doc.api.dom.ApiDocPageWriter;
import org.x4o.xml.eld.doc.api.dom.ApiDocWriteEvent;
import org.x4o.xml.io.sax.ext.ContentWriterHtml;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDocWriter {
    private ApiDoc doc = null;
    private File basePath = null;
    private static final String FRAME_JS = "\ntargetPage = \"\" + window.location.search;\nif (targetPage != \"\" && targetPage != \"undefined\")\n\t { targetPage = targetPage.substring(1); }\nif (targetPage.indexOf(\":\") != -1)\n\t { targetPage = \"undefined\"; }\nfunction loadFrames() {\n\tif (targetPage != \"\" && targetPage != \"undefined\")\n\t\t { top." + ApiDocContentCss.frameContent.name() + ".location = top.targetPage; }\n" + "}\n";

    public void write(ApiDoc doc, File basePath) throws IOException, SAXException {
        if (doc == null) {
            throw new NullPointerException("Can't write with null ApiDoc.");
        }
        if (basePath == null) {
            throw new NullPointerException("Can't write with null basePath.");
        }
        this.doc = doc;
        this.basePath = basePath;
        this.writeStyleSheet();
        this.writeIndex();
        this.writeOverviewFrame();
        this.writeAllFrameNav(true);
        this.writeAllFrameNav(false);
        for (ApiDocPage page : doc.getDocPages()) {
            this.writePage(page);
        }
        this.writeNode(doc.getRootNode());
    }

    private void writeNode(ApiDocNode node) throws SAXException {
        ApiDocConcept concept = this.findConceptByClass(node.getUserData().getClass());
        if (concept == null) {
            return;
        }
        ArrayList<String> path = new ArrayList<String>(10);
        this.buildParentPath(node, path);
        if (path.size() == 1) {
            path.remove(path.size() - 1);
            path.add("overview-" + node.getId() + ".html");
        } else {
            path.add("index.html");
        }
        String pathPrefix = "";
        for (int i = 1; i < path.size(); ++i) {
            pathPrefix = pathPrefix + "../";
        }
        File outputFile = this.createOutputPathFile(this.basePath, path.toArray(new String[0]));
        ApiDocContentWriter writer = this.createContentWriter(outputFile);
        ApiDocContentWriter.NavBarConfig config = this.createNavBarConfig(pathPrefix, outputFile, writer);
        config.navSelected = concept.getId();
        this.configActiveNavConceptLinks(config, node, concept, "/..");
        this.configNextPrevLinks(config, node);
        ApiDocWriteEvent<ApiDocNode> bodyEvent = new ApiDocWriteEvent<ApiDocNode>(this.doc, writer, node);
        String title = node.getId();
        String titleSub = null;
        if (node.getParent() != null) {
            titleSub = node.getParent().getId() + ":" + node.getId();
        }
        writer.docHtmlStart(config, title, this.doc.getDocKeywords());
        writer.docPageClassStart(title, titleSub);
        writer.docPageContentStart();
        this.writeNodeTreePath(bodyEvent);
        this.writeNodeDescription(bodyEvent);
        this.writeNodeSummary(bodyEvent);
        this.writeNodeDetails(bodyEvent);
        writer.docPageContentEnd();
        writer.docPageClassEnd();
        writer.docHtmlEnd(config, this.doc.getDocCopyright());
        writer.closeWriterSafe();
        this.writeAllFrameNavNode(node);
        for (ApiDocNode child : node.getNodes()) {
            this.writeNode(child);
        }
    }

    private void writeNodeTreePath(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        List<ApiDocNodeWriter> bodyWriterTreePath = this.findNodeBodyWriters(event.getEvent(), ApiDocNodeBody.TREE_PATH);
        if (bodyWriterTreePath.isEmpty()) {
            this.defaultWriteTreePath(event.getEvent(), event.getWriter());
        }
        for (int i = 0; i < bodyWriterTreePath.size(); ++i) {
            ApiDocNodeWriter nodeWriter = bodyWriterTreePath.get(i);
            nodeWriter.writeNodeContent(event);
        }
    }

    private void defaultWriteNodeDescription(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        event.getWriter().characters(event.getEvent().getDescription());
    }

    private void writeNodeDescription(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocNodeWriter nodeWriter;
        int i;
        ApiDocContentWriter writer = event.getWriter();
        List<ApiDocNodeWriter> bodyWriterDescriptionLinks = this.findNodeBodyWriters(event.getEvent(), ApiDocNodeBody.DESCRIPTION_LINKS);
        List<ApiDocNodeWriter> bodyWriterDescriptionNode = this.findNodeBodyWriters(event.getEvent(), ApiDocNodeBody.DESCRIPTION_NODE);
        writer.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.description);
        writer.docPageBlockStart();
        if (bodyWriterDescriptionLinks.isEmpty()) {
            // empty if block
        }
        for (i = 0; i < bodyWriterDescriptionLinks.size(); ++i) {
            nodeWriter = bodyWriterDescriptionLinks.get(i);
            nodeWriter.writeNodeContent(event);
        }
        writer.printTagStartEnd((Enum)ContentWriterHtml.Tag.hr);
        writer.printTagStartEnd((Enum)ContentWriterHtml.Tag.br);
        if (bodyWriterDescriptionNode.isEmpty()) {
            this.defaultWriteNodeDescription(event);
        }
        for (i = 0; i < bodyWriterDescriptionNode.size(); ++i) {
            nodeWriter = bodyWriterDescriptionNode.get(i);
            nodeWriter.writeNodeContent(event);
        }
        writer.docPageBlockEnd();
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.div);
    }

    private void writeNodeSummary(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocContentWriter writer = event.getWriter();
        List<ApiDocNodeWriter> bodyWriterSummary = this.findNodeBodyWriters(event.getEvent(), ApiDocNodeBody.SUMMARY);
        writer.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.summary);
        writer.docPageBlockStart();
        if (bodyWriterSummary.isEmpty()) {
            writer.docPageBlockStart();
            this.defaultWriteSummary(event.getEvent(), writer);
            writer.docPageBlockEnd();
        }
        for (int i = 0; i < bodyWriterSummary.size(); ++i) {
            writer.docPageBlockStart();
            writer.printTagCharacters((Enum)ContentWriterHtml.Tag.h3, "Summary");
            ApiDocNodeWriter nodeWriter = bodyWriterSummary.get(i);
            nodeWriter.writeNodeContent(event);
            writer.docPageBlockEnd();
        }
        writer.docPageBlockEnd();
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.div);
    }

    private void writeNodeDetails(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        ApiDocContentWriter writer = event.getWriter();
        List<ApiDocNodeWriter> bodyWriterDetail = this.findNodeBodyWriters(event.getEvent(), ApiDocNodeBody.DETAIL);
        if (bodyWriterDetail.isEmpty()) {
            return;
        }
        writer.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.details);
        writer.docPageBlockStart();
        for (int i = 0; i < bodyWriterDetail.size(); ++i) {
            writer.docPageBlockStart();
            writer.printTagCharacters((Enum)ContentWriterHtml.Tag.h3, "Detail");
            ApiDocNodeWriter nodeWriter = bodyWriterDetail.get(i);
            nodeWriter.writeNodeContent(event);
            writer.docPageBlockEnd();
        }
        writer.docPageBlockEnd();
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.div);
    }

    private void configActiveNavConceptLinks(ApiDocContentWriter.NavBarConfig conf, ApiDocNode node, ApiDocConcept concept, String prefix) {
        ArrayList<String> pathClean = new ArrayList<String>(10);
        this.buildParentPath(node, pathClean);
        if (concept.getParent() != null && !concept.getParent().getId().equals(this.doc.getRootNode().getId())) {
            ApiDocConcept conceptParent = concept.getParent();
            conf.navLinks.put(conceptParent.getId(), ApiDocContentWriter.toSafeUri(pathClean) + prefix + "/index.html");
            conf.navTitles.put(conceptParent.getId(), conceptParent.getDescriptionName());
            this.configActiveNavConceptLinks(conf, node, concept.getParent(), prefix + "/..");
        }
    }

    private void configNextPrevLinks(ApiDocContentWriter.NavBarConfig conf, ApiDocNode node) {
        ArrayList<String> pathClean;
        if (node.getParent() == null) {
            return;
        }
        List<ApiDocNode> pn = node.getParent().getNodes();
        int pnSize = pn.size();
        int nodeIdx = pn.indexOf(node);
        if (nodeIdx > 0) {
            pathClean = new ArrayList<String>(10);
            ApiDocNode prevNode = pn.get(nodeIdx - 1);
            if (node.getUserData().getClass().equals(prevNode.getUserData().getClass())) {
                this.buildParentPath(prevNode, pathClean);
                conf.prev = ApiDocContentWriter.toSafeUri(pathClean) + "/index.html";
            }
        }
        if (nodeIdx + 1 < pnSize) {
            pathClean = new ArrayList(10);
            ApiDocNode nextNode = pn.get(nodeIdx + 1);
            if (node.getUserData().getClass().equals(nextNode.getUserData().getClass())) {
                this.buildParentPath(nextNode, pathClean);
                conf.next = ApiDocContentWriter.toSafeUri(pathClean) + "/index.html";
            }
        }
    }

    public void defaultWriteSummary(ApiDocNode node, ApiDocContentWriter writer) throws SAXException {
        ApiDocConcept concept = this.findConceptByClass(node.getUserData().getClass());
        writer.docTableStart(concept.getName() + " Summary", "All childeren in " + concept.getName());
        writer.docTableHeader("Name", "Description");
        for (ApiDocNode child : node.getNodes()) {
            String link = ApiDocContentWriter.toSafeUri(child.getId()) + "/index.html";
            if (node.getParent() == null) {
                link = ApiDocContentWriter.toSafeUri(node.getId()) + "/" + link;
            }
            writer.docTableRowHref(link, child.getName(), child.getDescription(), null);
        }
        writer.docTableEnd();
    }

    public void defaultWriteTreePath(ApiDocNode node, ApiDocContentWriter writer) throws SAXException {
        if (node.getParent() == null) {
            return;
        }
        ArrayList<ApiDocNode> rootPath = new ArrayList<ApiDocNode>(8);
        this.defaultWriteTreePathBuildPath(node, rootPath);
        this.defaultWriteTreePathWalker(rootPath.iterator(), writer, rootPath.size());
    }

    private void defaultWriteTreePathWalker(Iterator<ApiDocNode> nodes, ApiDocContentWriter writer, int linkPrefixCount) throws SAXException {
        if (!nodes.hasNext()) {
            return;
        }
        ApiDocNode node = nodes.next();
        writer.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.inheritance);
        String nodeTitle = node.getId();
        if (!nodes.hasNext()) {
            writer.printTagStart((Enum)ContentWriterHtml.Tag.li);
            writer.characters(nodeTitle);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.li);
        } else {
            writer.printTagStart((Enum)ContentWriterHtml.Tag.li);
            StringBuffer buf = new StringBuffer(20);
            for (int i = 1; i < linkPrefixCount; ++i) {
                buf.append("../");
            }
            String linkHref = buf + "index.html";
            if (this.doc.getRootNode().equals(node)) {
                ApiDocConcept concept = this.findConceptByClass(node.getUserData().getClass());
                linkHref = buf + "../overview-" + concept.getId() + ".html";
            }
            writer.printHref(linkHref, node.getDescription(), nodeTitle);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.li);
            writer.printTagStart((Enum)ContentWriterHtml.Tag.li);
            this.defaultWriteTreePathWalker(nodes, writer, linkPrefixCount - 1);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.li);
        }
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
    }

    private void defaultWriteTreePathBuildPath(ApiDocNode node, List<ApiDocNode> result) {
        if (node.getParent() != null) {
            this.defaultWriteTreePathBuildPath(node.getParent(), result);
        }
        result.add(node);
    }

    private ApiDocContentWriter createContentWriter(File outputFile) throws SAXException {
        String encoding = "UTF-8";
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            String charNewLine = "\n";
            String charTab = "  ";
            ApiDocContentWriter result = new ApiDocContentWriter(out, encoding, charNewLine, charTab);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException(e);
        }
        catch (SecurityException e) {
            throw new SAXException(e);
        }
        catch (FileNotFoundException e) {
            throw new SAXException(e);
        }
    }

    protected ApiDocContentWriter.NavBarConfig createNavBarConfig(String pathPrefix, File frame, ApiDocContentWriter writer) throws SAXException {
        return this.createNavBarConfig(pathPrefix, null, null, frame, writer);
    }

    protected ApiDocContentWriter.NavBarConfig createNavBarConfig(String pathPrefix, String prev, String next, File frame, ApiDocContentWriter writer) throws SAXException {
        String navLink;
        String framePath = null;
        try {
            String rootPath = new File(frame.getParentFile().getPath() + File.separatorChar + pathPrefix).getCanonicalPath();
            framePath = frame.getPath().substring(rootPath.length() + 1);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        ApiDocContentWriter apiDocContentWriter = writer;
        ((Object)((Object)apiDocContentWriter)).getClass();
        ApiDocContentWriter.NavBarConfig conf = apiDocContentWriter.new ApiDocContentWriter.NavBarConfig(pathPrefix, prev, next, framePath, this.doc.getDocAbout());
        conf.noFrameAllLink = "allelements-noframe.html";
        conf.noFrameAllName = "All Elements";
        conf.linkConstructorName = "Tag";
        conf.linkFieldName = "Attributes";
        conf.linkMethodName = "Config";
        for (ApiDocConcept concept : this.doc.getConcepts()) {
            navLink = "overview-" + concept.getId() + ".html";
            if (concept.getParent() != null) {
                navLink = null;
            }
            conf.addNavItem(concept.getId(), navLink, concept.getName());
        }
        for (ApiDocPage page : this.doc.getDocPages()) {
            navLink = page.getId() + ".html";
            conf.addNavItem(page.getId(), navLink, page.getName());
        }
        return conf;
    }

    private List<ApiDocNodeWriter> findNodeBodyWriters(ApiDocNode node, ApiDocNodeBody nodeBody) {
        ArrayList<ApiDocNodeWriter> result = new ArrayList<ApiDocNodeWriter>();
        Class<?> objClass = node.getUserData().getClass();
        for (ApiDocNodeWriter writer : this.doc.getNodeBodyWriters()) {
            if (!nodeBody.equals((Object)writer.getNodeBody())) continue;
            for (Class<?> c : writer.getTargetClasses()) {
                if (!c.isAssignableFrom(objClass)) continue;
                result.add(writer);
            }
        }
        return result;
    }

    private ApiDocConcept findConceptByClass(Class<?> objClass) {
        for (ApiDocConcept concept : this.doc.getConcepts()) {
            if (concept.getConceptClass().isAssignableFrom(objClass)) {
                return concept;
            }
            for (Class<?> c : concept.getConceptChildClasses()) {
                if (!c.isAssignableFrom(objClass)) continue;
                return concept;
            }
        }
        return null;
    }

    private void buildParentPath(ApiDocNode node, List<String> path) {
        if (node.getParent() == null) {
            path.add(node.getId());
            return;
        }
        this.buildParentPath(node.getParent(), path);
        path.add(node.getId());
    }

    private void writeStyleSheet() throws IOException {
        try {
            StringBuffer cssData = new StringBuffer();
            this.appendResourceToBuffer(cssData, "org/x4o/xml/eld/doc/theme/base/api-html.css");
            this.appendResourceToBuffer(cssData, "org/x4o/xml/eld/doc/theme/base/api-layout.css");
            this.appendResourceToBuffer(cssData, "org/x4o/xml/eld/doc/theme/base/api-inset.css");
            this.appendResourceToBuffer(cssData, "org/x4o/xml/eld/doc/theme/base/api-font.css");
            this.appendResourceToBuffer(cssData, "org/x4o/xml/eld/doc/theme/base/api-color.css");
            this.appendResourceToBuffer(cssData, "org/x4o/xml/eld/doc/theme/jdk7/stylesheet.css");
            String css = cssData.toString();
            css = css.replaceAll("\\s+", " ");
            css = css.replaceAll("\\s*:\\s*", ":");
            css = css.replaceAll("\\s*\\;\\s*", ";");
            css = css.replaceAll("\\s*\\,\\s*", ",");
            css = css.replaceAll("\\s*\\{\\s*", "{");
            css = css.replaceAll("\\s*\\}\\s*", "}\n");
            this.writeFileString(css, this.basePath, "resources", "stylesheet.css");
            this.copyResourceToFile("org/x4o/xml/eld/doc/theme/jdk7/background.png", this.basePath, "resources", "background.png");
            this.copyResourceToFile("org/x4o/xml/eld/doc/theme/jdk7/tab.png", this.basePath, "resources", "tab.png");
            this.copyResourceToFile("org/x4o/xml/eld/doc/theme/jdk7/titlebar_end.png", this.basePath, "resources", "titlebar_end.png");
            this.copyResourceToFile("org/x4o/xml/eld/doc/theme/jdk7/titlebar.png", this.basePath, "resources", "titlebar.png");
        }
        catch (SecurityException e) {
            throw new IOException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void writeHeader(ApiDocContentWriter writer, String resourcePrefix, String title) throws SAXException {
        writer.printTagStart((Enum)ContentWriterHtml.Tag.head);
        writer.docCommentGenerated();
        writer.printHeadMetaContentType();
        writer.printHeadTitle(title);
        writer.printHeadMetaDate();
        writer.printHeadLinkCss(resourcePrefix + "resources/stylesheet.css");
        writer.printTagEnd((Enum)ContentWriterHtml.Tag.head);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIndex() throws SAXException {
        File outputFile = this.createOutputPathFile(this.basePath, "index.html");
        ApiDocContentWriter writer = this.createContentWriter(outputFile);
        try {
            writer.printDocType(ContentWriterHtml.DocType.HTML_4_FRAMESET);
            writer.comment("NewPage");
            writer.printHtmlStart("en");
            this.writeHeader(writer, "", this.doc.getName());
            writer.printScriptInline(FRAME_JS);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "cols", "", "", "20%,80%");
            atts.addAttribute("", "title", "", "", "Documentation frame");
            atts.addAttribute("", "onload", "", "", "top.loadFrames()");
            writer.printTagStart((Enum)ContentWriterHtml.Tag.frameset, atts);
            ApiDocConcept rootConcept = this.findConceptByClass(this.doc.getFrameNavConceptClass());
            atts = new AttributesImpl();
            atts.addAttribute("", "rows", "", "", "30%,70%");
            atts.addAttribute("", "title", "", "", "Left frames");
            atts.addAttribute("", "onload", "", "", "top.loadFrames()");
            writer.printTagStart((Enum)ContentWriterHtml.Tag.frameset, atts);
            atts = new AttributesImpl();
            atts.addAttribute("", "src", "", "", "overview-frame.html");
            atts.addAttribute("", "title", "", "", "All Namspaces");
            atts.addAttribute("", "name", "", "", ApiDocContentCss.frameNavOverview.name());
            writer.printTagStart((Enum)ContentWriterHtml.Tag.frame, atts);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.frame);
            atts = new AttributesImpl();
            atts.addAttribute("", "src", "", "", "all" + rootConcept.getId() + "-frame.html");
            atts.addAttribute("", "title", "", "", "All Elements");
            atts.addAttribute("", "name", "", "", ApiDocContentCss.frameNavDetail.name());
            writer.printTagStart((Enum)ContentWriterHtml.Tag.frame, atts);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.frame);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.frameset);
            String rootLink = "overview-" + ApiDocContentWriter.toSafeUri(this.doc.getRootNode().getId()) + ".html";
            atts = new AttributesImpl();
            atts.addAttribute("", "src", "", "", rootLink);
            atts.addAttribute("", "title", "", "", "All Language Components");
            atts.addAttribute("", "name", "", "", ApiDocContentCss.frameContent.name());
            atts.addAttribute("", "scrolling", "", "", "yes");
            writer.printTagStart((Enum)ContentWriterHtml.Tag.frame, atts);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.frame);
            writer.printTagStart((Enum)ContentWriterHtml.Tag.noframes);
            writer.printScriptNoDiv();
            writer.printTagCharacters((Enum)ContentWriterHtml.Tag.h2, "Frame Alert");
            writer.printTagStart((Enum)ContentWriterHtml.Tag.p);
            writer.characters("This document is designed to be viewed using the frames feature. If you see this message, you are using a non-frame-capable web client. Link to ");
            writer.printHref(rootLink, "Non-frame version");
            writer.characters(".");
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.p);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.noframes);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.frameset);
            writer.printHtmlEnd();
        }
        finally {
            writer.closeWriterSafe();
        }
    }

    private void findNodeByUserDataClass(ApiDocNode node, Class<?> userDataClass, List<ApiDocNode> result) {
        if (userDataClass.isAssignableFrom(node.getUserData().getClass())) {
            result.add(node);
        }
        for (ApiDocNode child : node.getNodes()) {
            this.findNodeByUserDataClass(child, userDataClass, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOverviewFrame() throws SAXException {
        ApiDocConcept concept = this.findConceptByClass(this.doc.getFrameNavConceptClass());
        ApiDocConcept conceptParent = concept.getParent();
        ArrayList<ApiDocNode> nodes = new ArrayList<ApiDocNode>(50);
        this.findNodeByUserDataClass(this.doc.getRootNode(), conceptParent.getConceptClass(), nodes);
        File outputFile = this.createOutputPathFile(this.basePath, "overview-frame.html");
        ApiDocContentWriter writer = this.createContentWriter(outputFile);
        try {
            String conceptPlural = concept.getName() + "s";
            String conceptParentPlural = conceptParent.getName() + "s";
            writer.printDocType(ContentWriterHtml.DocType.HTML_4_TRANSITIONAL);
            writer.comment("NewPage");
            writer.printHtmlStart("en");
            this.writeHeader(writer, "", "All " + conceptPlural + " of " + this.doc.getName());
            writer.printTagStart((Enum)ContentWriterHtml.Tag.body);
            writer.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.indexHeader);
            writer.printHrefTarget("all" + concept.getId() + "-frame.html", "All " + conceptPlural, ApiDocContentCss.frameNavDetail.name());
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.div);
            writer.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.indexContainer);
            writer.printTagCharacters((Enum)ContentWriterHtml.Tag.h2, conceptParentPlural);
            writer.printTagStart((Enum)ContentWriterHtml.Tag.ul);
            for (ApiDocNode node : nodes) {
                String linkName = node.getName();
                if (this.doc.getFrameNavOverviewPrintParent().booleanValue()) {
                    linkName = this.doc.getFrameNavPrintParentId() != false ? node.getParent().getId() + ":" + node.getName() : node.getParent().getName() + ":" + node.getName();
                }
                writer.printTagStart((Enum)ContentWriterHtml.Tag.li);
                writer.printHrefTarget(this.doc.getRootNode().getId() + "/" + ApiDocContentWriter.toSafeUri(node.getParent().getId()) + "/" + node.getId() + "/" + node.getId() + "-frame.html", linkName, ApiDocContentCss.frameNavDetail.name());
                writer.printTagEnd((Enum)ContentWriterHtml.Tag.li);
            }
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.div);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.body);
            writer.printHtmlEnd();
        }
        finally {
            writer.closeWriterSafe();
        }
    }

    public void writeAllFrameNav(boolean isFrame) throws SAXException {
        ApiDocConcept concept = this.findConceptByClass(this.doc.getFrameNavConceptClass());
        if (isFrame) {
            this.writeAllFrameNav("", true, null, "all" + concept.getId() + "-frame.html");
        } else {
            this.writeAllFrameNav("", false, null, "all" + concept.getId() + "-noframe.html");
        }
    }

    private void writeAllFrameNavNode(ApiDocNode node) throws SAXException {
        ApiDocConcept concept = this.findConceptByClass(this.doc.getFrameNavConceptClass());
        ApiDocConcept conceptParent = concept.getParent();
        if (!conceptParent.getConceptClass().isAssignableFrom(node.getUserData().getClass())) {
            return;
        }
        ArrayList<String> path = new ArrayList<String>(10);
        this.buildParentPath(node, path);
        String pathS = "";
        for (int i = 0; i < path.size(); ++i) {
            pathS = "../" + pathS;
        }
        path.add(node.getId() + "-frame.html");
        this.writeAllFrameNav(pathS, true, node, path.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllFrameNav(String pathPrefix, boolean isFrame, ApiDocNode searchNode, String ... fileName) throws SAXException {
        ApiDocConcept concept = this.findConceptByClass(this.doc.getFrameNavConceptClass());
        ArrayList<ApiDocNode> nodes = new ArrayList<ApiDocNode>(50);
        this.findNodeByUserDataClass(this.doc.getRootNode(), concept.getConceptClass(), nodes);
        File outputFile = this.createOutputPathFile(this.basePath, fileName);
        ApiDocContentWriter writer = this.createContentWriter(outputFile);
        try {
            String conceptPlural = concept.getName() + "s";
            writer.printDocType(ContentWriterHtml.DocType.HTML_4_TRANSITIONAL);
            writer.comment("NewPage");
            writer.printHtmlStart("en");
            this.writeHeader(writer, pathPrefix, "All " + conceptPlural + " of " + this.doc.getName());
            writer.printTagStart((Enum)ContentWriterHtml.Tag.body);
            if (searchNode == null) {
                writer.printTagCharacters(ContentWriterHtml.Tag.h1, "All " + conceptPlural, "bar");
            } else {
                writer.printTagStart(ContentWriterHtml.Tag.h1, ApiDocContentCss.bar);
                writer.printHrefTarget("index.html", searchNode.getId(), ApiDocContentCss.frameContent.name());
                writer.printTagEnd((Enum)ContentWriterHtml.Tag.h1);
            }
            writer.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.indexContainer);
            writer.printTagStart((Enum)ContentWriterHtml.Tag.ul);
            boolean printParent = new Boolean(true).equals(this.doc.getFrameNavPrintParent());
            boolean printParentParent = new Boolean(true).equals(this.doc.getFrameNavPrintParentParent());
            for (ApiDocNode node : nodes) {
                ArrayList<String> nodePath = new ArrayList<String>(10);
                this.buildParentPath(node, nodePath);
                if (searchNode != null && (!node.getParent().getId().equals(searchNode.getId()) || searchNode.getParent() != null && !node.getParent().getParent().getId().equals(searchNode.getParent().getId()) || searchNode.getParent().getParent() != null && !node.getParent().getParent().getParent().getId().equals(searchNode.getParent().getParent().getId()))) continue;
                String linkName = node.getName();
                String linkUrl = ApiDocContentWriter.toSafeUri(nodePath) + "/index.html";
                if (searchNode != null) {
                    linkUrl = ApiDocContentWriter.toSafeUri(node.getId(), "index.html");
                }
                if (printParent) {
                    linkName = printParentParent ? (this.doc.getFrameNavPrintParentId().booleanValue() ? node.getParent().getParent().getId() + ":" + linkName : node.getParent().getParent().getName() + ":" + linkName) : (this.doc.getFrameNavPrintParentId() != false ? node.getParent().getId() + ":" + linkName : node.getParent().getName() + ":" + linkName);
                }
                writer.printTagStart((Enum)ContentWriterHtml.Tag.li);
                if (isFrame) {
                    writer.printHrefTarget(linkUrl, linkName, ApiDocContentCss.frameContent.name());
                } else {
                    writer.printHref(linkUrl, linkName);
                }
                writer.printTagEnd((Enum)ContentWriterHtml.Tag.li);
            }
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.div);
            writer.printTagEnd((Enum)ContentWriterHtml.Tag.body);
            writer.printHtmlEnd();
        }
        finally {
            writer.closeWriterSafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePage(ApiDocPage page) throws SAXException {
        File outputFile = this.createOutputPathFile(this.basePath, page.getId() + ".html");
        ApiDocContentWriter writer = this.createContentWriter(outputFile);
        String pathPrefix = "";
        try {
            ApiDocContentWriter.NavBarConfig conf = this.createNavBarConfig(pathPrefix, outputFile, writer);
            conf.navSelected = page.getId();
            String title = page.getName();
            writer.docHtmlStart(conf, title, this.doc.getDocKeywords());
            writer.docPageClassStart(title, page.getDescription());
            ApiDocWriteEvent<ApiDocPage> e = new ApiDocWriteEvent<ApiDocPage>(this.doc, writer, page);
            for (ApiDocPageWriter pageWriter : page.getPageWriters()) {
                pageWriter.writePageContent(e);
            }
            writer.docPageClassEnd();
            writer.docHtmlEnd(conf, this.doc.getDocCopyright());
        }
        finally {
            writer.closeWriterSafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResourceToBuffer(StringBuffer buffer, String resource) throws IOException {
        ClassLoader cl = X4OLanguageClassLoader.getClassLoader();
        BufferedReader reader = null;
        try {
            InputStream inputStream = cl.getResourceAsStream(resource);
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int c = reader.read();
            while (c != -1) {
                buffer.append((char)c);
                c = reader.read();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileString(String text, File basePath, String ... argu) throws SecurityException, IOException, InterruptedException {
        FileOutputStream outputStream = new FileOutputStream(this.createOutputPathFile(basePath, argu));
        try {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                ((OutputStream)outputStream).write(c);
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            ((OutputStream)outputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToFile(String resource, File basePath, String ... argu) throws SecurityException, IOException, InterruptedException {
        ClassLoader cl = X4OLanguageClassLoader.getClassLoader();
        InputStream inputStream = cl.getResourceAsStream(resource);
        FileOutputStream outputStream = new FileOutputStream(this.createOutputPathFile(basePath, argu));
        try {
            byte[] buffer = new byte[4096];
            int len = inputStream.read(buffer);
            while (len != -1) {
                ((OutputStream)outputStream).write(buffer, 0, len);
                len = inputStream.read(buffer);
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
    }

    private File createOutputPathFile(File basePath, String ... argu) {
        StringBuffer buf = new StringBuffer(200);
        buf.append(basePath.getAbsolutePath());
        buf.append(File.separatorChar);
        for (int i = 0; i < argu.length - 1; ++i) {
            buf.append(ApiDocContentWriter.toSafeUri(argu[i]));
            buf.append(File.separatorChar);
        }
        File outputPath = new File(buf.toString());
        if (!outputPath.exists()) {
            outputPath.mkdirs();
        }
        buf.append(File.separatorChar);
        buf.append(ApiDocContentWriter.toSafeUri(argu[argu.length - 1]));
        File outputFile = new File(buf.toString());
        if (outputFile.exists()) {
            outputFile.delete();
        }
        return outputFile;
    }
}

