#! /usr/bin/env python
# -*- coding: utf-8 -*-
#####################       A U T H O R       ##########################
#                                                                      #
#   Copyright 2010 Jack Desert                                         #
#   <jackdesert556@gmail.com>                                          #
#   <http://www.LetsEATalready.com>                                    #
#                                                                      #
######################      L I C E N S E     ##########################
#                                                                      #
#   This file is part of LyxBlogger.                                   #
#                                                                      #
#   LyxBlogger is free software: you can redistribute it and/or modify #
#   it under the terms of the GNU General Public License as published  #
#   by the Free Software Foundation, either version 3 of the License,  #
#   or (at your option) any later version.                             #
#                                                                      #
#   LyxBlogger is distributed in the hope that it will be useful,      #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of     #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      #
#   GNU General Public License for more details.                       #
#                                                                      #
#   You should have received a copy of the GNU General Public License  #
#   along with LyxBlogger.  If not, see <http://www.gnu.org/licenses>. #
#                                                                      #
########################################################################

import os, sys
import re
import wordpresslib
from misc import pr3



def up_images(in_html, wp_client_obj, ELYXER_ENGINE, in_IMAGE_DIR):
    # Find local location of a single image within the (x)html file

    if(ELYXER_ENGINE):
    # eLyXer img tags looks something like this:
    # <img class="embedded" src="rv-8_tiny.jpg" alt="figure rv-8_tiny.jpg" style="max-width: 2048px; max-height: 1536px; "/>
    # Notice ELYXER uses double quotes instead of single quotes within the tag.
        img_exp = re.compile('''
            <img\ class="embedded"\          # The beginning of an <img> tag -- note two escaped spaces
            src="           # Note use of double quotes instead of single
            (?!http://)     # Negative lookahead expression (if it has http:// it's already been changed to web reference)
            ..*?            # Non-greedy (short as possible match) of stuff in middle
            />              # The closing of the <img> tag
            ''', re.VERBOSE)
    else:
    # INTERNAL img tags look something like this:
    # <img src='0_home_jd_Escritorio_rv-8_tiny.jpg' alt='image: 0_home_jd_Escritorio_rv-8_tiny.jpg' />
        img_exp = re.compile('''
            <img\ src='     # The beginning of an <img> tag -- note the escaped space in the verbose regex
            (?!http://)     # Negative lookahead expression (if it has http:// it's already been changed to web reference)
            ..*?            # Non-greedy (short as possible match) of stuff in middle
            />              # The closing of the <img> tag
            ''', re.VERBOSE)

    img_obj = img_exp.search(in_html)
    imageSrc = None
    if(img_obj):
        pr3 ('IMAGES\nFirst We\'ll Upload Your Images')
    while(img_obj):
        img_tag = img_obj.group()
        # Find local address of image
        # The only difference between the two is single vs double quotes
        if (ELYXER_ENGINE):
            add_exp = re.compile('''
                src="   # The beginning of the address
                ..*?    # Non-greedy rest of the address
                "       # The (first) closing (double) quotation mark
                ''', re.VERBOSE)
        else:
            add_exp = re.compile('''
                src='   # The beginning of the address
                ..*?    # Non-greedy rest of the address
                '       # The (first) closing (single) quotation mark
                ''', re.VERBOSE)
        add_obj = add_exp.search(img_tag)
        if (add_obj == None):
            pr3 ("Error parsing img tag: " + img_tag)
            msg = "LyxBlogger failed to find src attribute in <img> tag"
            raise Exception(msg)
        long_address = add_obj.group()
        short_address = long_address[5:-1]  # Strip off the src="

        filesize = str(os.path.getsize(in_IMAGE_DIR + short_address) / 1024) + ' kB'
        pr3("Uploading image: " + short_address + '.  Size: ' + filesize )
        # upload image for post
        imageSrc = wp_client_obj.newMediaObject(in_IMAGE_DIR + short_address)
        in_html = in_html.replace(short_address, imageSrc)
        img_obj = img_exp.search(in_html)          # Note this is a repeat.
    return(in_html)

# FIND IMAGE DIRECTORY
# Look for either backslash (win32) or forslash (everything else)
# to find directory where images reside
def get_image_dir(in_input_file):
    directory = ''
    if (sys.platform == 'win32'):
        input_exp = re.compile('..{1,}\\\\')   # Greedy to catch full folder
    else:
        input_exp = re.compile('..{1,}/')   # Greedy to catch full folder
    input_obj = input_exp.match(in_input_file) # Must match at beginning of expression
    if (input_obj):
        directory = input_obj.group()
    return directory
