#! /usr/bin/env python
# -*- coding: utf-8 -*-
#######################  L Y X B L O G G E R   #########################
#   This program allows you to post to your WordPress blog right from  #
#   LyX. The input to this script is xhtml.                            #
#   Supported LyX --> xhtml converters:                                #
#                                                                      #
#      LyXHTML output from LyX 2.0.                                    #
#      eLyXer output from LyX 1.6 and later. (Earlier may work too)    #
#                                                                      #
#   This script will connect using xml-rpc.                            #
#                                                                      #
#################     D O C U M E N T A T I O N       ##################
#                                                                      #
#   Please see README.html for LyXBlogger documentation.               #
#   Alternatively, see the wiki page at                                #
#   http://wiki.lyx.org/Tools/LyXBlogger                               #
#   Please note the capitalization of the previous url.                #
#   Please submit any issues or suggestions to the author.             #
#                                                                      #
#####################       A U T H O R       ##########################
#                                                                      #
#   Copyright 2010 Jack Desert                                         #
#   <jackdesert556@gmail.com>                                          #
#   <http://www.LetsEATalready.com>                                    #
#                                                                      #
######################      L I C E N S E     ##########################
#                                                                      #
#   This file is part of LyXBlogger.                                   #
#                                                                      #
#   LyXBlogger is free software: you can redistribute it and/or modify #
#   it under the terms of the GNU General Public License as published  #
#   by the Free Software Foundation, either version 3 of the License,  #
#   or (at your option) any later version.                             #
#                                                                      #
#   LyXBlogger is distributed in the hope that it will be useful,      #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of     #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      #
#   GNU General Public License for more details.                       #
#                                                                      #
#   You should have received a copy of the GNU General Public License  #
#   along with LyXBlogger.  If not, see <http://www.gnu.org/licenses>. #
#                                                                      #
#########   U S E R    D E F I N E D    V A R I A B L E S   ############

AUTO_URL = 'http://blogtest.letseatalready.com/xmlrpc.php'             #
AUTO_USER = 'test'                                                     #
AUTO_PASSWORD = 'test'                                                 #
AUTO_LOGIN = True                                                      #
CUT_FLAG = '#! CUT MATERIAL'                                           #

########################################################################

import sys, os, re
import wordpresslib
import getpass

from LyxBlog.image import up_images
from LyxBlog.image import get_dir_offset
from LyxBlog.term import term_open
from LyxBlog.misc import pr3
from LyxBlog.misc import wait_for_consumer
from LyxBlog.misc import trim_cut_material
from LyxBlog.misc import get_format

def main(keys):
    error_msg = ''
    if(len(sys.argv) > 1):
        input_file = sys.argv[1]    # Incoming file name
    # DIR_OFFSET is where the file being called is relative to where your shell is open to
    DIR_OFFSET = ''            # Empty until defined otherwise

    # Open LyXBlogger in a separate terminal
    term_open(input_file)

    pr3 ('LYXBLOGGER')
    pr3 ('Welcome to LyXBlogger')
    pr3 ('Author: Jack Desert')
    pr3 ('Website: LetsEATalready.com\n')

    DIR_OFFSET = get_dir_offset(input_file)

    # Read data from file
    f = open(input_file, 'r')
    html = f.read()
    f.close()

    pr3 ("FORMAT")
    ELYXER_ENGINE = get_format(html)
    if ELYXER_ENGINE == None:
        sys.exit(0)     # Halt Program if invalid html found.


    # RECORD TITLE FROM HEADER TO USE AS POST
    tit_exp = re.compile('''
        <title>         # Start of the <title> tag
        ..{1,}?         # Anything in the middle (non-greedy)
        </title>        # Closing </title> tag
        ''', re.VERBOSE)    # VERBOSE allows ''' '''
    tit_obj = tit_exp.search(html)
    # eLyXer uses 'Converted document' as the default title in the head
    # and body. LyXHTML uses 'LyX Document' as the default, but only
    # puts it in the head. The following code detects these default
    # titles and asks for a real title
    TITLE_EXPECTED_IN_BODY, TITLE_PROMPT = False, True
    pr3 ("\nTITLE")
    if(tit_obj):
        TITLE_EXPECTED_IN_BODY = True
        TITLE_PROMPT = False
        full_title_tag = tit_obj.group()
        blog_title = full_title_tag[7:-8]   # Strip tags off
        if (blog_title == 'Converted document'):    # eLyXer's default (head and body)
            TITLE_PROMPT = True
        if (blog_title == 'LyX Document'):  # LyXHTML's default (only in head)
            TITLE_PROMPT = True
            TITLE_EXPECTED_IN_BODY = False
    if(TITLE_PROMPT):
        pr3 ('No title found in document.')
        pr3 ('Please enter a title now')
        blog_title = sys.stdin.readline().replace('\n', '')
    pr3 ('Using title: ' + blog_title)

    # REMOVING TITLE FROM BODY
    # Typical body title using ENGINE_INTERNAL:
    #   <h1 class="title"><a id='magicparlabel-309' />
    #   Example Article Title</h1>
    #   <h1 class="title">
    # Typical body title using ELYXER_ENGINE using optional sizing:
    #   <h1 class="title">
    #   <span class="footnotesize">Hi Brian</span>
    #
    #   </h1>
    exp = re.compile('''
        <h1\                   # Beginning of tag with space
        class="title">         # The rest of the tag
        ..{1,}?                # Anything (non-greedy)
        </h1>                  # Closing tag
        ''', re.VERBOSE | re.DOTALL)                 # .. can include linebreaks
    bt_obj = exp.search(html)
    if(bt_obj):
        entire_bt_tag = bt_obj.group()
        html = html.replace(entire_bt_tag, '')
    elif (TITLE_EXPECTED_IN_BODY):
        pr3 ('\nWARNING! The title of your entry may appear twice.')
        pr3 ('Please notify the author at jackdesert556@gmail.com to')
        pr3 ('have this bug squashed.\n\n Press Enter to continue uploading.')
        sys.stdin.readline()
        # What this really means is an opening title tag was found, but
        # no title tag was found in the body.

    # Eliminate everything outside the <body></body> tags
    START_TAG = '<body>'
    END_TAG = '</body>'
    if (START_TAG in html):
        html = html.partition(START_TAG)[2]
    html = html.partition(END_TAG)[0]

    # Reinvoke <code> and </code> tags from their escape sequence counterparts
    html = html.replace('&lt;code&gt;', '<code>')
    html = html.replace('&lt;/code&gt;', '</code>')

    # Remove Arrows from footnotes and margin notes
    html = html.replace('[→', '[')
    html = html.replace('→]', ']')

    html = trim_cut_material(html, keys.CUT_FLAG, ELYXER_ENGINE)

    if (keys.AUTO_LOGIN == True):
        display_url = keys.AUTO_URL[0:-11]
        pr3 ("Publish this document to " + display_url + "?   Y (N)")
        a = sys.stdin.readline()
        if (a == 'Y\n' or a == 'y\n'):
            wordpress_url = keys.AUTO_URL
            user = keys.AUTO_USER
            password = keys.AUTO_PASSWORD
        else:
            keys.AUTO_LOGIN = False

    if (keys.AUTO_LOGIN ==False):
        pr3 ("URL")
        pr3("Please enter your WordPress URL")
        pr3("Example: cool_site.wordpress.com")
        wordpress_url = sys.stdin.readline()
        wordpress_url = wordpress_url.replace('http://', '')
        wordpress_url = wordpress_url.replace('www.', '')
        wordpress_url = wordpress_url.replace('\n', '')
        wordpress_url = 'http://' + wordpress_url + '/xmlrpc.php'
        pr3 ("The page we'll be talking is " + wordpress_url)
        pr3 ("\nUSERNAME")
        pr3("Please enter your WordPress username")
        user = sys.stdin.readline().replace('\n', '')
        pr3("Username is " + user + '.')
        pr3 ("\nPASSWORD")
        pr3("Please enter your WordPress password")
        password = getpass.getpass()
        pr3 ("Thank you.")

    # prepare client object
    wp = wordpresslib.WordPressClient(wordpress_url, user, password)

    # select blog id
    wp.selectBlog(0)

    pr3 ('\nCATEGORY')
    pr3 ('Retrieving Categories From Server')
    cat_list = wp.getCategoryList()
    cat_counter = 1
    for cat in cat_list:
        pr3 (str(cat_counter) + '.  ' + cat.name)
        cat_counter += 1
    cat_id = None
    while (1):
        try:
            pr3 ('Please enter the NUMBER next to the category for this post')
            cat_response = sys.stdin.readline().replace('\n', '')
            cat = int(cat_response)
            cat_id = cat_list[cat-1].id
            pr3 ('Category Selected: ' + cat_list[cat-1].name + '\n')
            break
        except:
            pr3 ("Category Response Not Understood.\n")

    html = up_images(html, wp, ELYXER_ENGINE, DIR_OFFSET)

    # create post object
    post = wordpresslib.WordPressPost()
    post.title = blog_title
    post.description = html

    # I have no idea why this takes a tuple (something, )
    post.categories = (cat_id,)
    # publish post
    pr3 ('\nWORDS\nNow We\'ll Upload Your Thoughts')
    filesize = str(os.path.getsize(input_file) / 1024) + ' kB'
    pr3("Uploading xhtml: " + input_file + '.  Size: ' + filesize )
    idNewPost = wp.newPost(post, True)

    pr3 ('\nSUCCESS!')
    pr3 ('You just published your document to ' + wordpress_url[7:-11])
    pr3 ('Thank you for using LyXBlogger.\n\n')
    wait_for_consumer()



class Credentials:
    def __init__(self, url, user, pw, auto_login, flag):
        self.AUTO_URL = url
        self.AUTO_USER = user
        self.AUTO_PASSWORD = pw
        self.AUTO_LOGIN = auto_login
        self.CUT_FLAG = flag



if __name__ == '__main__':
    my_credentials = Credentials(AUTO_URL,
        AUTO_USER, AUTO_PASSWORD, AUTO_LOGIN, CUT_FLAG)
    main(my_credentials)


