/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.ode.*;
import opale.ode.scheme.*;
import opale.tools.*;
import opale.m2d.component2d.*;
import opale.m2d.object2d.*;
import opale.m2d.*;


public class VanDerPol2
{

public static void main(String[] arg)
	{
	
	try
	{
	ODE ode = new ODE();
	StreamReader rf = new StreamReader("vanderpol.ode");
	ode.read(rf);
	ode.solve();
	
	Problem pb = (Problem) ode.getObject("pb");
	System.err.println(pb.printSol());



	JFrame2D jf = new JFrame2D();
	jf.setTitle("Systme de Van der Pol - Opale-ODE ");
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-6,6,-10,10);
	jf.getPack2D().add(repere,"repere");

	double[][] sol = new double[3][pb.getNStep()];
	sol = pb.toArray();
	GData2D gsol = new GData2D(repere);
	gsol.set(1000,sol[1],sol[2]);
	jf.getPack2D().add(gsol,"sol");
	jf.show();
	
	
	}
	catch(java.io.IOException e)
	{}	
	catch(InvalidFormatException e)
	{System.err.println(e);}	
	}

}
	
