/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import java.io.*;
import opale.tools.*;
import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class FullLU
{
public static void main(String[] arg) throws
    InvalidFormatException, FileNotFoundException, IOException
	{
	Matrix A = new Matrix (100,100);
	DVect b = new DVect(100);
	DVect x = new DVect(100);
	
	for (int i=0;i<100;i++)
		{
		b.set(i,Math.random()*100);
		for(int j = 0;j <100;j++)
			A.set(i,j,Math.random()*100);
		 }
	System.out.println(A);
	Matrix AA=(Matrix)A.clone();	 
	SolverLU lu = new SolverLU();
	lu.decomp(A);
	lu.solve(null,b,x);

	System.out.println("det = " +lu.determinant());
	
	
	DVect err = new DVect(100);
	double tmp;
	for (int i=0;i<100;i++)
		{
		tmp = 0-b.get(i);
		for(int j = 0;j <100;j++)
				tmp +=AA.get(i,j)*x.get(j);
		err.set(i,tmp);
		}
	
	
	
	System.out.println("Err = "+err.getMax());

	OpaleSet ops = new OpaleSet();
	ops.add(A,"A");
	ops.writeInFile("wfile.mat");
	
	
	
	}
	
}
