/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.swools;
/**
* La classe DoubleTextField tend <code>JTextField</code> et ne permet que la saisie de double.
* @author O.C.
* @since Opale-Swools 0.1
*/

import javax.swing.*;
import javax.swing.text.*;

class DoubleTextDocument extends PlainDocument
{  public void insertString(int offs, String str, 
      AttributeSet a) 
      throws BadLocationException 
   {  if (str == null) return;
      String oldString = getText(0, getLength());
      String newString = oldString.substring(0, offs)
         + str + oldString.substring(offs);
      try
      {  Double.parseDouble(newString + "0");
         super.insertString(offs, str, a);
      }
      catch(NumberFormatException e)
      {  
      }
   }
}

public class DoubleTextField extends JTextField 
{  public DoubleTextField(double defval, int size)
   {  super("" + defval, size);
   }

 public DoubleTextField(int size)
   {  super("" + 0., size);
   }

   protected Document createDefaultModel() 
   {  return new DoubleTextDocument();
   }

   public boolean isValid()
   {  try
      {  Double.parseDouble(getText());
         return true;
      }
      catch(NumberFormatException e)
      {  return false; 
      }
   }

   public double getValue()
   {  try
      {  return Double.parseDouble(getText());
      }
      catch(NumberFormatException e)
      {  return 0; 
      }
   }
}