/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le schma de Runge Kutta classique qui consiste  avancer en temps de la facon suivante : ***.
* @author O.C.
* @since Opale-ODE 0.1
*/
public final class RK extends TimeScheme
{
/**
* Cette mthode dfinit l'avanc en temps par la formule de Runge Kutta classique.
*/	
public void forward(Equation eq)
	{
	DVect tempo = new DVect(present().size());
	int i;
	double dt2 = 0.5*dt();

	for (i=0;i<present().size();i++)
		tempo.set(i,past().get(i)+dt2*der_past().get(i));

	DVect der2 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo.set(i,past().get(i)+dt2*der2.get(i));
	
	DVect der3 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo.set(i,past().get(i)+dt()*der3.get(i));
	 DVect der4 = eq.derivs(time()+dt(),tempo);
	
	
	for (i=0;i<present().size();i++)
		{
		present().set(i,past().get(i)+dt()*((der_past().get(i)+der4.get(i))/6+(der2.get(i)+der3.get(i))/3));
		}
	}

/**
* Cette mthode dfinit l'avanc en temps par la formule de Runge Kutta classique.
*/	
public void advance()
	{
	Equation eq = getEquation();
	DVect tempo = new DVect(present().size());
	int i;
	double dt2 = 0.5*dt();

	for (i=0;i<present().size();i++)
		tempo.set(i,past().get(i)+dt2*der_past().get(i));

	DVect der2 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo.set(i,past().get(i)+dt2*der2.get(i));
	
	DVect der3 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo.set(i,past().get(i)+dt()*der3.get(i));
	 DVect der4 = eq.derivs(time()+dt(),tempo);
	
	
	for (i=0;i<present().size();i++)
		{
		present().set(i,past().get(i)+dt()*((der_past().get(i)+der4.get(i))/6+(der2.get(i)+der3.get(i))/3));
		}
	}

public String toString()
	{
	return "RK";
	}

}
