/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.mathtools;

/**
* Cette interface est implementer pour reprsenter uen courbe paramtre dans R^2 : t --> x(t),y(t)..
* @since Opale-Mathtools 0.1
* @author O.C.
*/
public interface IxyFt
{
/**
* Cette mthode renvoie la valeur de la fonction t-->x(t) en un point.
* @param  double t, le point  calculer.
* @return double, la valeur de la fonction en ce point
*/
public double x(double t);
/**
* Cette mthode renvoie la valeur de la fonction t-->y(t) en un point.
* @param  double t, le point  calculer.
* @return double, la valeur de la fonction en ce point
*/
public double y(double t);
}
