/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;
import opale.m2d.*;
import opale.tools.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

class JPanel2D extends JPanel implements MouseListener,MouseMotionListener
{
private boolean modeZoom;
private int x1,y1,x2,y2;
private Image buffer;
private Pack2D pack;
private	CoordSystem vue;
private	GAxis2D axes;

public JPanel2D()
	{
	super.setBackground(Color.white);
	vue = new LinLinCS(OIJ.OIJ_ABSOLUTE,0,0,this.getWidth(),this.getHeight());
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	
	pack = new Pack2D();
	pack.add(OIJ.OIJ_ABSOLUTE,"oij_abs");

	modeZoom = false;
	vue.setSize(20,20,this.getWidth()-40,this.getHeight()-40);
	this.addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			buffer = createImage(getWidth(), getHeight());
			vue.setSize(20,20,getWidth()-40,getHeight()-40);
			vue.autoadjust();
			redraw();
			repaint();
			}
		});
	addMouseListener(this);
	addMouseMotionListener(this);

	}



/**
* Renvoie la rfrence  l'instance de Pack2D contenu dans l'objet courant Frame2D.
* @return Pack2D, l'instance de Pack2D.
*/
public Pack2D getPack2D()
	{
	return pack;
	}

/**
* Set the instance of Pack2d contained in this class.
* @param Pack2D
* @since Opale-2d 0.17
*/
public void setPack2D(Pack2D p)
	{
	 pack = p;
	}

/**
* Renvoie la rfrence  l'instance de GAxis2D contenu dans l'objet courant JFrame2D.
* @return GAxis2D, l'instance de GAxis2D.
*/
public GAxis2D getAxis()
	{
	return axes;
	}
	
/**
* Renvoie la rfrence au systme de coordonnes contenu dans l'objet courant JFrame2D.
* @return CoordSystem, l'instance de CoordSystem.
*/
public CoordSystem getCS()
	{
	return vue;
	}









//les actions de la souris
public void mouseEntered(MouseEvent e){}
public void mouseExited(MouseEvent e){}
public void mouseClicked(MouseEvent e){}

//on appui sur le bouton
public void mousePressed(MouseEvent e)
{
//repaint();
modeZoom=true;
x1=x2=e.getX();
y1=y2=e.getY();
//xminTemp=(x1-20-Xcentre)*(xmax-xmin)/(largeur-40);
//ymaxTemp=(-y1+40+Ycentre)*(ymax-ymin)/(hauteur-80);
}

//on lache le bouton
public void mouseReleased(MouseEvent e)
{
modeZoom=false;
if(x2<=x1 || y2<=y1 ) return;
double xmin = vue.xfromXY(x1,y1);
double ymax = vue.yfromXY(x1,y1);
double xmax = vue.xfromXY(x2,y2);
double ymin = vue.yfromXY(x2,y2);
if (xmin>xmax)
	{
	final double tmp = xmax;
	xmin = xmax;
	xmax = tmp;
	}
if (ymin>ymax)
	{
	final double tmp = ymax;
	ymin = ymax;
	ymax = tmp;
	}


vue.set(xmin,xmax,ymin,ymax);
vue.autoadjust();
Graphics gg = buffer.getGraphics();
final int H = buffer.getHeight(null);
final int W = buffer.getWidth(null);

gg.clearRect(0,0,W,H);
gg.drawRect(5,5,W-10,H-10);
Pen2D c = new Pen2D(gg,vue);
axes.draw(c);
c.clip();
pack.draw(c);

//passage a l ecran
repaint();
}

//on bouge la souris
public void mouseMoved(MouseEvent e){}
public void mouseDragged(MouseEvent e){
if (modeZoom==true)
  {
  Graphics g = getGraphics();
  this.repaint();
  x2 = e.getX();
  y2 = e.getY();
  g.drawRect(x1,y1,x2-x1,y2-y1);
  }
}

void redraw()
{
Graphics gg = buffer.getGraphics();
final int H = buffer.getHeight(null);
final int W = buffer.getWidth(null);

gg.clearRect(0,0,W,H);
gg.drawRect(5,5,W-10,H-10);
Pen2D c = new Pen2D(gg,vue);
axes.draw(c);
c.clip();
pack.draw(c);
}


public void paintComponent(Graphics g)
	{
	super.paintComponent(g);
	g.drawImage(buffer,0,0,null);
	
	}
	
}

