/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;

/**
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import opale.m2d.GAxis2D;
import opale.swools.*;

class AxisEditor extends Frame {
private Frame2D mere;
  BorderLayout borderLayout1 = new BorderLayout();
  Panel jPanel1 = new Panel();
  BorderLayout borderLayout2 = new BorderLayout();
  Panel jPanel2 = new Panel();
  Button okButton = new Button();
  Button appButton = new Button();
  Button closeButton = new Button();
  Panel jPanel3 = new Panel();
  GridLayout gridLayout1 = new GridLayout();
  Panel jPanel4 = new Panel();
  Panel jPanel5 = new Panel();
  Panel jPanel6 = new Panel();
  Panel jPanel7 = new Panel();
  Panel jPanel8 = new Panel();
  FlowLayout flowLayout1 = new FlowLayout();
  Label xminLabel = new Label();
  DoubleTextField xminField;
  Label xmaxLabel = new Label();
  DoubleTextField xmaxField;
  Label ymin = new Label();
  DoubleTextField yminField;
  Label ymax = new Label();
  DoubleTextField ymaxField;
  Checkbox visibleCheck = new Checkbox();
  Checkbox numCheck = new Checkbox();

  public AxisEditor(Frame2D mere) {
    this.mere = mere;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setSize(new Dimension(300, 300));
    setResizable(false);
    setTitle("Axes");
    this.setLayout(borderLayout1);
    jPanel1.setLayout(borderLayout2);
    okButton.setLabel("Ok");
    okButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        okButton_actionPerformed(e);
      }
    });
    appButton.setLabel("Apply");
    appButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        appButton_actionPerformed(e);
      }
    });
    closeButton.setLabel("Close");
    closeButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        closeButton_actionPerformed(e);
      }
    });
    opale.m2d.InfoAxis info = (opale.m2d.InfoAxis) mere.getAxis().getInfo();
    xminField = new DoubleTextField(info.getXtickMin(),10);
    xmaxField = new DoubleTextField(info.getXtickMax(),10);
    yminField = new DoubleTextField(info.getYtickMin(),10);
    ymaxField = new DoubleTextField(info.getYtickMax(),10);
    
    jPanel3.setLayout(gridLayout1);
    gridLayout1.setRows(5);
    jPanel4.setLayout(flowLayout1);
    xminLabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    xminLabel.setText("espacement x min = ");
    xmaxLabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    xmaxLabel.setText("espacement x max = ");
    ymin.setFont(new java.awt.Font("Monospaced", 1, 12));
    ymin.setText("espacement y min = ");
    ymax.setFont(new java.awt.Font("Monospaced", 1, 12));
    ymax.setText("espacement y max = ");
    visibleCheck.setLabel("afficher axes");
    visibleCheck.setState(mere.getAxis().getInfo().isVisible());
    numCheck.setLabel("afficher echelle");
    numCheck.setState(mere.getAxis().printScale());
    this.add(jPanel1, BorderLayout.CENTER);
    jPanel1.add(jPanel2, BorderLayout.SOUTH);
    jPanel2.add(okButton, null);
    jPanel2.add(appButton, null);
    jPanel2.add(closeButton, null);
    jPanel1.add(jPanel3, BorderLayout.CENTER);
    jPanel3.add(jPanel4, null);
    jPanel4.add(xminLabel, null);
    jPanel4.add(xminField, null);
    jPanel3.add(jPanel5, null);
    jPanel5.add(xmaxLabel, null);
    jPanel5.add(xmaxField, null);
    jPanel3.add(jPanel6, null);
    jPanel6.add(ymin, null);
    jPanel6.add(yminField, null);
    jPanel3.add(jPanel7, null);
    jPanel7.add(ymax, null);
    jPanel7.add(ymaxField, null);
    jPanel3.add(jPanel8, null);
    jPanel8.add(visibleCheck, null);
    jPanel8.add(numCheck, null);
  }

  void okButton_actionPerformed(ActionEvent e) {

    opale.m2d.InfoAxis info = (opale.m2d.InfoAxis) mere.getAxis().getInfo();
   info.setTick(xminField.getValue(),xmaxField.getValue(),yminField.getValue(),ymaxField.getValue());
   if (visibleCheck.getState()) info.setVisible();
   else info.setUnvisible();
   if (numCheck.getState()) mere.getAxis().drawScale(true);
   else mere.getAxis().drawScale(false);
   mere.repaint();
  dispose();
  }

  void appButton_actionPerformed(ActionEvent e) {
    opale.m2d.InfoAxis info = (opale.m2d.InfoAxis) mere.getAxis().getInfo();
   info.setTick(xminField.getValue(),xmaxField.getValue(),yminField.getValue(),ymaxField.getValue());
   if (visibleCheck.getState()) info.setVisible();
   else info.setUnvisible();
   if (numCheck.getState()) mere.getAxis().drawScale(true);
   else mere.getAxis().drawScale(false);
   mere.repaint();
  }

  void closeButton_actionPerformed(ActionEvent e) {
 dispose();

  }

}
