/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.scheme;

import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.TimeScheme;

public final class Heun
extends TimeScheme {
    private double temp;

    public void forward(Equation equation) {
        DVect dVect = new DVect(this.present().size());
        int n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + this.dt() * this.der_past().get(n));
            ++n;
        }
        DVect dVect2 = equation.derivs(this.time() + this.dt(), dVect);
        n = 0;
        while (n < this.present().size()) {
            this.present().set(n, this.past().get(n) + 0.5 * this.dt() * (this.der_past().get(n) + dVect2.get(n)));
            ++n;
        }
    }

    public void advance() {
        Equation equation = this.getEquation();
        DVect dVect = new DVect(this.present().size());
        int n = 0;
        while (n < this.present().size()) {
            dVect.set(n, this.past().get(n) + this.dt() * this.der_past().get(n));
            ++n;
        }
        DVect dVect2 = equation.derivs(this.time() + this.dt(), dVect);
        n = 0;
        while (n < this.present().size()) {
            this.present().set(n, this.past().get(n) + 0.5 * this.dt() * (this.der_past().get(n) + dVect2.get(n)));
            ++n;
        }
    }

    public String toString() {
        return "Heun";
    }
}

