/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

class Node {
    public static final int OP = 0;
    public static final int VALUE = 1;
    public static final int INTRINSIC = 2;
    public static final int NULL = 3;
    public static final int INDEPENDENT = 4;
    public static final int GROUP = 5;
    public static final int PARAMETER = 6;
    public static final int P0 = 0;
    public static final int P1 = 1;
    public static final int P2 = 2;
    public static final int P3 = 3;
    public static final int P4 = 4;
    public static final int P5 = 5;
    int type;
    Node left;
    Node right;
    int op;
    double value;
    int precedence;

    public Node() {
        this.type = 3;
        this.left = null;
        this.right = null;
        this.op = 3;
        this.value = 0.0;
        this.precedence = 0;
    }

    public Node(Node node) {
        this.replace(node);
    }

    public void replace(Node node) {
        if (node == null) {
            return;
        }
        this.op = node.op;
        this.type = node.type;
        this.left = node.left;
        this.right = node.right;
        this.value = node.value;
        this.precedence = node.precedence;
    }

    public void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
    }

    public void print(int n) {
        char[] cArray = new char[1];
        this.indent(n);
        System.out.println("NODE type=" + this.type);
        this.indent(n);
        System.out.println("     prec=" + this.precedence);
        this.indent(n);
        switch (this.type) {
            case 1: {
                System.out.println("     value=" + this.value);
                break;
            }
            case 4: {
                System.out.println("     variable=" + this.op);
                break;
            }
            default: {
                System.out.println("     op=" + this.op);
                if (this.left != null) {
                    this.left.print(n + 5);
                }
                if (this.right == null) break;
                this.right.print(n + 5);
            }
        }
    }
}

