/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

public class DComplex
implements Cloneable {
    private static final boolean fast = false;
    private double x;
    private double y;
    private static DComplex i = new DComplex(0.0, 1.0);

    public DComplex() {
    }

    public DComplex(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public DComplex(DComplex dComplex) {
        this.x = dComplex.x;
        this.y = dComplex.y;
    }

    public final void add(DComplex dComplex) {
        this.x += dComplex.x;
        this.y += dComplex.y;
    }

    public final void sub(DComplex dComplex) {
        this.x -= dComplex.x;
        this.y -= dComplex.y;
    }

    public final void mul(DComplex dComplex) {
        double d = this.x;
        this.x = this.x * dComplex.x - this.y * dComplex.y;
        this.y = this.y * dComplex.x + d * dComplex.y;
    }

    public final void div(DComplex dComplex) {
        double d = dComplex.x;
        double d2 = dComplex.y;
        if (d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("Division by zero !");
        }
        if (Math.abs(d) >= Math.abs(d2)) {
            double d3 = d2 / d;
            double d4 = d + d2 * d3;
            double d5 = this.x;
            this.x = (this.x + this.y * d3) / d4;
            this.y = (this.y - d5 * d3) / d4;
        } else {
            double d6 = d / d2;
            double d7 = d2 + d * d6;
            double d8 = this.x;
            this.x = (this.y + this.x * d6) / d7;
            this.y = (this.y * d6 - d8) / d7;
        }
    }

    public static DComplex i() {
        return i;
    }

    public final double getRe() {
        return this.x;
    }

    public final double getIm() {
        return this.y;
    }

    public final void setRe(double d) {
        this.x = d;
    }

    public final void setIm(double d) {
        this.y = d;
    }

    public final void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void set(DComplex dComplex) {
        this.x = dComplex.x;
        this.y = dComplex.y;
    }

    public final double norm() {
        double d;
        double d2 = Math.abs(this.x);
        return d2 > (d = Math.abs(this.y)) ? d2 * Math.sqrt(1.0 + this.y * this.y / this.x / this.x) : d * Math.sqrt(1.0 + this.x * this.x / this.y / this.y);
    }

    public final double normSq() {
        return this.x * this.x + this.y * this.y;
    }

    public String toString() {
        return this.x + (this.y < 0.0 ? "-i*" : "+i*") + Math.abs(this.y);
    }

    public boolean equals(Object object) {
        if (object instanceof DComplex) {
            DComplex dComplex = (DComplex)object;
            return this.x == dComplex.x && this.y == dComplex.y;
        }
        return false;
    }

    public Object clone() {
        try {
            DComplex dComplex = (DComplex)super.clone();
            dComplex.x = this.x;
            dComplex.y = this.y;
            return dComplex;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static void main(String[] stringArray) {
        DComplex dComplex = new DComplex(-1.0, 3.0);
        System.err.println(dComplex);
        dComplex.mul(DComplex.i());
        System.err.println(dComplex);
        System.err.println(dComplex.equals(new DComplex(3.0, 1.0)));
        System.out.println(dComplex.norm());
        dComplex.set(-1.0, 3.0);
        dComplex.div(new DComplex(2.0, 0.0));
        System.out.println(dComplex);
    }
}

