/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

public class Bernstein {
    public static double getValue(int n, int n2, double d) {
        double[] dArray = new double[n2 + 1];
        dArray[n2 - n] = 1.0;
        double d2 = 1.0 - d;
        int n3 = 1;
        while (n3 <= n2) {
            int n4 = n2;
            while (n4 >= n3) {
                dArray[n4] = d2 * dArray[n4] + d * dArray[n4 - 1];
                --n4;
            }
            ++n3;
        }
        return dArray[n2];
    }

    public static double[] getAllValues(int n, double d) {
        double[] dArray = new double[n + 1];
        dArray[0] = 1.0;
        double d2 = 1.0 - d;
        int n2 = 1;
        while (n2 <= n) {
            double d3 = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                double d4 = dArray[n3];
                dArray[n3] = d3 + d2 * d4;
                d3 = d * d4;
                ++n3;
            }
            dArray[n2] = d3;
            ++n2;
        }
        return dArray;
    }
}

