/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.component2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import opale.m2d.DefaultGraphicalOptions;
import opale.m2d.MarkType;

public class DefaultStyleEditor
extends JFrame {
    private DefaultGraphicalOptions options;
    private static String[] marktype = new String[]{"Classic point", "ClassicPoint", "Circle", "CirclePoint", "Diamond", "DiamondPoint", "Horizontal line", "HLine", "Vertical line", "VLine", "Horizontal+Vertical lines", "HVLine", "Square", "SquarePoint", "X", "XPoint", "Triangle up", "TriangleUp", "Triangle down", "TriangleDown", "Triangle left", "TriangleLeft", "Triangle right", "TriangleRight"};
    JPanel jPanelVisible = new JPanel();
    JPanel jPanelSud = new JPanel();
    JLabel jLabelTitreFx = new JLabel();
    JButton jButtonOk = new JButton();
    JPanel jPanelMain = new JPanel();
    JButton jButtonAnn = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanelNord = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JButton jButtonAppl = new JButton();
    JList jList2 = new JList();
    JPanel jPanelMark = new JPanel();
    JLabel jLabelMark = new JLabel();
    JCheckBox jCheckBoxVisible = new JCheckBox();
    JComboBox jComboBoxMark = new JComboBox();
    JLabel jLabelColor = new JLabel();
    JButton jButtonColor = new JButton();
    JLabel jLabelSize = new JLabel();
    JTextField jTextFieldSize = new JTextField();

    public DefaultStyleEditor() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ((Component)this).setSize(450, 200);
        this.jPanelSud.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jLabelTitreFx.setText("Graphical Options Editor");
        this.jLabelTitreFx.setFont(new Font("Dialog", 3, 18));
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultStyleEditor.this.jButtonOk_actionPerformed(actionEvent);
            }
        });
        this.jPanelMain.setLayout(this.gridLayout1);
        this.jPanelMain.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButtonAnn.setText("Cancel");
        this.jButtonAnn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultStyleEditor.this.jButtonAnn_actionPerformed(actionEvent);
            }
        });
        this.gridLayout1.setRows(2);
        this.gridLayout1.setColumns(1);
        this.jPanelNord.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButtonAppl.setText("Apply");
        this.jButtonAppl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultStyleEditor.this.jButtonAppl_actionPerformed(actionEvent);
            }
        });
        this.jList2.setSelectionMode(0);
        this.jLabelMark.setFont(new Font("Monospaced", 1, 12));
        this.jLabelMark.setText("Mark type = ");
        int n = 0;
        while (n < marktype.length / 2) {
            this.jComboBoxMark.addItem(marktype[2 * n]);
            ++n;
        }
        this.jCheckBoxVisible.setText("Visible");
        this.jCheckBoxVisible.setForeground(new Color(102, 102, 153));
        this.jCheckBoxVisible.setFont(new Font("Monospaced", 1, 12));
        this.jLabelColor.setText("Color = ");
        this.jLabelColor.setFont(new Font("Monospaced", 1, 12));
        this.jButtonColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultStyleEditor.this.jButtonColor_actionPerformed(actionEvent);
            }
        });
        this.jLabelSize.setFont(new Font("Monospaced", 1, 12));
        this.jLabelSize.setText("Size = ");
        this.jTextFieldSize.setText("0");
        this.jTextFieldSize.setColumns(3);
        this.getContentPane().add((Component)this.jPanelSud, "South");
        this.jPanelSud.add((Component)this.jButtonOk, null);
        this.jPanelSud.add((Component)this.jButtonAppl, null);
        this.jPanelSud.add((Component)this.jButtonAnn, null);
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelMain.add((Component)this.jPanelVisible, null);
        this.jPanelVisible.add((Component)this.jCheckBoxVisible, null);
        this.jPanelVisible.add((Component)this.jLabelColor, null);
        this.jPanelVisible.add((Component)this.jButtonColor, null);
        this.jPanelMain.add((Component)this.jPanelMark, null);
        this.jPanelMark.add((Component)this.jLabelMark, null);
        this.jPanelMark.add((Component)this.jComboBoxMark, null);
        this.jPanelMark.add((Component)this.jList2, null);
        this.jPanelMark.add((Component)this.jLabelSize, null);
        this.jPanelMark.add((Component)this.jTextFieldSize, null);
        this.getContentPane().add((Component)this.jPanelNord, "North");
        this.jPanelNord.add((Component)this.jLabelTitreFx, null);
    }

    public void setOptions(DefaultGraphicalOptions defaultGraphicalOptions) {
        this.options = defaultGraphicalOptions;
        this.initOptions();
    }

    private String find(String string) {
        int n = 0;
        while (n < marktype.length / 2) {
            if (("opale.m2d.marktype." + marktype[2 * n + 1]).equals(string)) {
                return marktype[2 * n];
            }
            ++n;
        }
        return null;
    }

    private String find2(String string) {
        int n = 0;
        while (n < marktype.length / 2) {
            if (marktype[2 * n].equals(string)) {
                return "opale.m2d.marktype." + marktype[2 * n + 1];
            }
            ++n;
        }
        return null;
    }

    public void initOptions() {
        this.jButtonColor.setBackground(this.options.getColor());
        this.jCheckBoxVisible.setSelected(this.options.isVisible());
        String string = this.options.getMarktype().getClass().getName();
        this.jComboBoxMark.setSelectedItem(string);
        this.jTextFieldSize.setText("" + this.options.getMarktype().getMarksize());
    }

    public void applyOptions() {
        this.options.setColor(this.jButtonColor.getBackground());
        if (this.jCheckBoxVisible.isSelected()) {
            this.options.setVisible();
        } else {
            this.options.setUnvisible();
        }
        try {
            MarkType markType = (MarkType)Class.forName(this.find2((String)this.jComboBoxMark.getSelectedItem())).newInstance();
            markType.setMarksize(Integer.parseInt(this.jTextFieldSize.getText()));
            this.options.setMarktype(markType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            System.err.println("Report the bug to the Opale team");
            System.exit(-1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            System.err.println("Report the bug to the Opale team");
            System.exit(-1);
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            System.err.println("Report the bug to the Opale team");
            System.exit(-1);
        }
    }

    protected void jButtonOk_actionPerformed(ActionEvent actionEvent) {
        this.applyOptions();
        this.dispose();
    }

    protected void jButtonAnn_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void jButtonColor_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Color editor", this.jButtonColor.getBackground());
        if (color != null) {
            this.jButtonColor.setBackground(color);
        }
    }

    protected void jButtonAppl_actionPerformed(ActionEvent actionEvent) {
        this.applyOptions();
    }

    public static void main(String[] stringArray) {
        DefaultStyleEditor defaultStyleEditor = new DefaultStyleEditor();
        defaultStyleEditor.show();
    }
}

