<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des sessions
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux sessions
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Session {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur. Initialise la connexion locale
	* @access	public
	*/
	function Session() {
		$this->_db = new DB_Ganesha ;
	}

	/**
	* Lecture des sessions de formation d'un groupe
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function read($idg) {
		global $TBL, $db ;
        $sSQL = "SELECT DISTINCT g.id_module,m.module_titre,g.ordre ";
        $sSQL.= "FROM ".$TBL['session_groupe']." g, ".$TBL['list_module']." m ";
        $sSQL.= "WHERE g.id_groupe=".$idg." AND g.id_module=m.module_id ";
        $sSQL.= "ORDER BY g.ordre";
		$db->query($sSQL)	;
		$ret = array()		;
		$ret['cnt'] = $db->num_rows();
		$i = 0 ;
		while($db->next_record()) {
			$ret[$i]['name']	= $db->f(1) ;
			$ret[$i]['id']		= $db->f(0) ;
			$ret[$i]['ordre']	= $db->f(2) ;
			$i++ ;
		}
		return($ret);
	}
	
	/**
	* suppression des sessions de formation d'un groupe
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function DeleteGroupe($idg) {
		global $TBL, $db ;
        $sSQL = "DELETE FROM ".$TBL['session_groupe']." WHERE id_groupe=".$idg;
		$db->query($sSQL)	;
	}

	/**
	* suppression des sessions de formation d'un module
	* @param	integer	$idm ID du module
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function delModule($idm,$idg) {
		global $TBL, $db ;
		$grp = '' ;
		if ( $idg != 0 ) {
			$grp = " AND id_groupe=".$idg ;
		}
        $sSQL = "DELETE FROM ".$TBL['session_groupe']." "  		;
        $sSQL.= "WHERE id_module=".$idm.$grp ;
		$db->query($sSQL)	;
	}
		
	/**
	* Supprime un module d'une session
	* @param	integer	$idg id du groupe
	* @param	integer	$idm module a supprimer
	* @access	private
	*/
	function delSession($idg,$idm) { 
		global $db, $TBL, $ClsTracking, $ClsFormation, $ClsGroupe ;
		if ( is_numeric($idm) ) {
			$sSQL = "DELETE FROM ".$TBL['session_groupe']." "		;
			$sSQL.= "WHERE id_groupe=".$idg." AND id_module=".$idm	;
			$db->query($sSQL)   ;
			$ClsTracking->delModule($idm,$idg);
			$users = $ClsGroupe->Members($idg);
			for($i=0;$i<$users['cnt'];$i++) {
				$ClsFormation->del($users[$i]['id'],$idm,$idg);
			}
		}
	}

	/**
	* Retourne la valeur du champs ordre
	* @param	integer	$idg id du groupe
	* @access	public
	*/
	function maxPosition($idg) { 
		global $db, $TBL ;
		if ( is_numeric($idg) ) {
			$sSQL = "SELECT MAX(ordre) FROM ".$TBL['session_groupe']." ";
			$sSQL.= "WHERE id_groupe=".$idg;
			$db->query($sSQL)   ;
			if ( $db->num_rows() == 1 ) {
				return($db->f(0)+1);
			} else {
				return(0);
			}
		} else {
			return(0);
		}
	}
	
	/**
	* Ajoute un nouveau groupe
	* @param	integer	$idg id du groupe
	* @param	array	$tabsession table des sessions
	* @access	public
	*/
	function add($idg,$tabsession) { 
		global $db, $TBL ;
		// Creation des sessions ...
		if ( is_array($tabsession) ) {
			for ($i=0;$i<count($tabsession);$i++) {
				$sSQL = "INSERT INTO ".$TBL['session_groupe']." ";
				$sSQL.= "(id_groupe,id_module,ordre) ";
				$sSQL.= "VALUES ('".$idg."','".$tabsession[$i]."','".$this->maxPosition($idg)."')";
				$db->query($sSQL)   ;
			}
		}
	}

	/**
	* Verifie si le module est ds le groupe
	* @param	integer	$idm id du module
	* @param	integer	$idg id du groupe	
	* @access	public
	*/
	function verifModuleGroupe($idm,$idg) { 
		global $db, $TBL ;
		$sSQL = "SELECT * FROM ".$TBL['session_groupe']." ";
		$sSQL.= "WHERE id_groupe=".$idg." AND id_module=".$idm ;
		$db->query($sSQL)  ;
		return($db->num_rows()==1);	
	}
		
	/**
	* Ajoute un nouveau module a une session
	* @param	integer	$idg id du groupe
	* @param	integer	$idm module a ajouter au groupe
	* @access	private
	*/
	function addSession($idg,$idm) { 
		global $db, $TBL ;
		if ( is_numeric($idm) ) {
			$this->delSession($idg,$idm);
			$sSQL = "INSERT INTO ".$TBL['session_groupe']." ";
			$sSQL.= "(id_groupe,id_module,ordre) ";
			$sSQL.= "VALUES ('".$idg."','".$idm."','".$this->maxPosition($idg)."')";
			$db->query($sSQL);
		}
	}

	/**
	* Affecte un ordre a un module pour un groupe
	* @param	integer	$idg id du groupe
	* @param	integer	$idm module a ajouter au groupe
	* @access	private
	*/
	function order($idg,$idm,$order) { 
		global $db, $TBL ;
		$order = is_numeric($order) ? $order : 0 ;
		$sSQL = "UPDATE ".$TBL['session_groupe']." " ;
		$sSQL.= "SET ordre=".$order." " ;
		$sSQL.= "WHERE id_groupe=".$idg." AND id_module=".$idm ;
		$db->query($sSQL);
	}
		
	/**
	* changement de sessions pour un groupe
	* @param	integer	$idg ID du groupe
	* @param	array	$tabsession list des nouvelles sessions
	* @access	public
	*/
	function update($idg,$tabsession) {
		global $db, $TBL;
		// recuperation des sessions pour ce groupe

		$ret = $this->read($idg);
		$oldsession = array();
		for($i=0;$i<$ret['cnt'];$i++) {
			$oldsession[] = $ret[$i]['id'] ;
		}
		
		if ( ! is_array($tabsession)) {
			$this->DeleteGroupe($idg) ;
			return(true);
		}
		
		$ret1 = array_diff($oldsession,$tabsession);
		if ( is_array($ret1) && count($ret1)>0) {
			$val1 = array_values($ret1);
			for($i=0;$i<count($val1);$i++){
				$this->delSession($idg,$val1[$i]);
			}
		}
		
		$ret2 = array_diff($tabsession,$oldsession);
		if ( is_array($ret2) && count($ret2)>0) {
			$val2 = array_values($ret2);
			for($i=0;$i<count($val2);$i++){
				$this->addSession($idg,$val2[$i]);
			}
		}
/*
		// merge entre les anciennes sessions et les nouvelles.
		if (is_array($tabsession)) {
			if (count($oldsession)==0) {
				// ajouter les nouvelles sessions
				$this->add($idg,$tabsession);
			} else {
				// merge
				for($i=0;$i<count($tabsession);$i++){
					if ( ! in_array($tabsession[$i],$oldsession) ) {
						$this->addSession($idg,$tabsession[$i]);
					}
				}
				// supprimer les sessions qui ne sont plus affectees a ce groupe
				for($i=0;$i<count($oldsession);$i++){
					if(!in_array($oldsession[$i],$tabsession)) {
						//supprimer le module de la session
						$this->delSession($idg,$oldsession[$i]);				
					}
				}				
			}						
		} else {
			// il n'y a plus de sessions pour ce groupe !	
			$this->DeleteGroupe($idg) ;
		}
*/
	}	

}// class Session

/**
* Instance de la classe Session
* @var	object	Session	$ClsSession
*/
$ClsSession = new Session ;

?>