/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import java.io.Serializable;

public final class DocType
implements Serializable {
    private final String name;
    private final String publicId;
    private final String systemId;
    private final String sgmlPublicId;
    private final String sgmlSystemId;
    private static String XML_DECLARATION = "<?xml version=\"1.0\" ?>\n";

    public String getName() {
        return this.name;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSgmlPublicId() {
        return this.sgmlPublicId;
    }

    public String getSgmlSystemId() {
        return this.sgmlSystemId;
    }

    public boolean isSgmlCompatible() {
        return this.sgmlSystemId != null;
    }

    public DocType(String name, String publicId, String systemId, String sgmlPublicId, String sgmlSystemId) {
        this.name = Preconditions.checkNotNull(name);
        this.publicId = publicId;
        this.systemId = Preconditions.checkNotNull(systemId);
        if (sgmlPublicId != null && sgmlSystemId == null) {
            throw new NullPointerException();
        }
        this.sgmlPublicId = sgmlPublicId;
        this.sgmlSystemId = sgmlSystemId;
    }

    public String toSgml(String rootElement) {
        return DocType.toMarkup(rootElement.toUpperCase(), this.sgmlPublicId, this.sgmlSystemId);
    }

    public String toXml(String rootElement) {
        return XML_DECLARATION + DocType.toMarkup(rootElement, this.publicId, this.systemId);
    }

    private static String toMarkup(String rootElement, String publicId, String systemId) {
        StringBuffer sb = new StringBuffer("<!DOCTYPE ");
        sb.append(Preconditions.checkNotNull(rootElement)).append(publicId == null ? " SYSTEM" : (publicId.isEmpty() ? "" : " PUBLIC \"" + publicId + "\"")).append(Preconditions.checkNotNull(systemId).isEmpty() ? "" : " \"" + systemId + "\"").append(">");
        return sb.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DocType && this.equals((DocType)that);
    }

    private boolean equals(DocType that) {
        return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getPublicId(), that.getPublicId()) && Objects.equal(this.getSystemId(), that.getSystemId()) && Objects.equal(this.getSgmlPublicId(), that.getSgmlPublicId()) && Objects.equal(this.getSgmlSystemId(), that.getSgmlSystemId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getPublicId(), this.getSystemId(), this.getSgmlPublicId(), this.getSgmlSystemId());
    }
}

