/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.metric.internal.CountStat;

public class MultiCountStat<T> {
    public static final int TEN_MIN_IN_SECONDS = 600;
    public static final String TEN_MIN_IN_SECONDS_STR = "600";
    private final int numBuckets;
    private ConcurrentHashMap<T, CountStat> counts = new ConcurrentHashMap();

    public MultiCountStat(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CountStat get(T key) {
        CountStat c = this.counts.get(key);
        if (c == null) {
            MultiCountStat multiCountStat = this;
            synchronized (multiCountStat) {
                c = this.counts.get(key);
                if (c == null) {
                    c = new CountStat(this.numBuckets);
                    this.counts.put(key, c);
                }
            }
        }
        return c;
    }

    public void incBy(T key, long count) {
        this.get(key).incBy(count);
    }

    protected String keyToString(T key) {
        if (key instanceof List) {
            List lk = (List)key;
            return (String)lk.get(0) + ":" + (String)lk.get(1);
        }
        return key.toString();
    }

    public Map<String, Map<T, Long>> getTimeCounts() {
        HashMap<String, Map<T, Long>> ret = new HashMap<String, Map<T, Long>>();
        for (Map.Entry<T, CountStat> entry : this.counts.entrySet()) {
            T key = entry.getKey();
            Map<String, Long> toFlip = entry.getValue().getTimeCounts();
            for (Map.Entry<String, Long> subEntry : toFlip.entrySet()) {
                String time = subEntry.getKey();
                HashMap<T, Long> tmp = (HashMap<T, Long>)ret.get(time);
                if (tmp == null) {
                    tmp = new HashMap<T, Long>();
                    ret.put(time, tmp);
                }
                tmp.put(key, subEntry.getValue());
            }
        }
        return ret;
    }

    public void close() {
        for (CountStat cc : this.counts.values()) {
            cc.close();
        }
    }
}

