/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling.sorter;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.storm.scheduler.Component;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.IExecSorter;
import org.apache.storm.shade.com.google.common.collect.Sets;

public class ExecSorterByConnectionCount
implements IExecSorter {
    protected TopologyDetails topologyDetails;

    public ExecSorterByConnectionCount(TopologyDetails topologyDetails) {
        this.topologyDetails = topologyDetails;
    }

    @Override
    public List<ExecutorDetails> sortExecutors(Set<ExecutorDetails> unassignedExecutors) {
        Map<String, Component> componentMap = this.topologyDetails.getUserTopolgyComponents();
        LinkedHashSet<ExecutorDetails> orderedExecutorSet = new LinkedHashSet<ExecutorDetails>();
        HashMap compToExecsToSchedule = new HashMap();
        for (Component component : componentMap.values()) {
            compToExecsToSchedule.put(component.getId(), new LinkedList());
            for (ExecutorDetails exec : component.getExecs()) {
                if (!unassignedExecutors.contains(exec)) continue;
                ((Queue)compToExecsToSchedule.get(component.getId())).add(exec);
            }
        }
        Set<Component> sortedComponents = this.sortComponents(componentMap);
        sortedComponents.addAll(componentMap.values());
        for (Component currComp : sortedComponents) {
            boolean flag;
            HashMap<String, Component> neighbors = new HashMap<String, Component>();
            for (String compId : Sets.union(currComp.getChildren(), currComp.getParents())) {
                neighbors.put(compId, componentMap.get(compId));
            }
            Set<Component> sortedNeighbors = this.sortNeighbors(currComp, neighbors);
            Queue currCompExecsToSched = (Queue)compToExecsToSchedule.get(currComp.getId());
            do {
                flag = false;
                if (!currCompExecsToSched.isEmpty()) {
                    orderedExecutorSet.add((ExecutorDetails)currCompExecsToSched.poll());
                    flag = true;
                }
                for (Component neighborComp : sortedNeighbors) {
                    Queue neighborCompExesToSched = (Queue)compToExecsToSchedule.get(neighborComp.getId());
                    if (neighborCompExesToSched.isEmpty()) continue;
                    orderedExecutorSet.add((ExecutorDetails)neighborCompExesToSched.poll());
                    flag = true;
                }
            } while (flag);
        }
        orderedExecutorSet.addAll(unassignedExecutors);
        return new LinkedList<ExecutorDetails>(orderedExecutorSet);
    }

    private Set<Component> sortComponents(Map<String, Component> componentMap) {
        TreeSet<Component> sortedComponents = new TreeSet<Component>((o1, o2) -> {
            int connections1 = 0;
            int connections2 = 0;
            for (String childId : Sets.union(o1.getChildren(), o1.getParents())) {
                connections1 += ((Component)componentMap.get(childId)).getExecs().size() * o1.getExecs().size();
            }
            for (String childId : Sets.union(o2.getChildren(), o2.getParents())) {
                connections2 += ((Component)componentMap.get(childId)).getExecs().size() * o2.getExecs().size();
            }
            if (connections1 > connections2) {
                return -1;
            }
            if (connections1 < connections2) {
                return 1;
            }
            return o1.getId().compareTo(o2.getId());
        });
        sortedComponents.addAll(componentMap.values());
        return sortedComponents;
    }

    private Set<Component> sortNeighbors(Component thisComp, Map<String, Component> componentMap) {
        TreeSet<Component> sortedComponents = new TreeSet<Component>((o1, o2) -> {
            int connections2;
            int connections1 = o1.getExecs().size() * thisComp.getExecs().size();
            if (connections1 < (connections2 = o2.getExecs().size() * thisComp.getExecs().size())) {
                return -1;
            }
            if (connections1 > connections2) {
                return 1;
            }
            return o1.getId().compareTo(o2.getId());
        });
        sortedComponents.addAll(componentMap.values());
        return sortedComponents;
    }
}

