/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import org.apache.sis.storage.landsat.BandGroupName;
import org.apache.sis.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

enum BandName {
    COASTAL_AEROSOL(BandGroupName.REFLECTIVE, "Coastal Aerosol", 433),
    BLUE(BandGroupName.REFLECTIVE, "Blue", 482),
    GREEN(BandGroupName.REFLECTIVE, "Green", 562),
    RED(BandGroupName.REFLECTIVE, "Red", 655),
    NEAR_INFRARED(BandGroupName.REFLECTIVE, "Near-Infrared", 865),
    SWIR1(BandGroupName.REFLECTIVE, "Short Wavelength Infrared (SWIR) 1", 1610),
    SWIR2(BandGroupName.REFLECTIVE, "Short Wavelength Infrared (SWIR) 2", 2200),
    PANCHROMATIC(BandGroupName.PANCHROMATIC, "Panchromatic", 590),
    CIRRUS(BandGroupName.REFLECTIVE, "Cirrus", 1375),
    TIRS1(BandGroupName.THERMAL, "Thermal Infrared Sensor (TIRS) 1", 10800),
    TIRS2(BandGroupName.THERMAL, "Thermal Infrared Sensor (TIRS) 2", 12000);

    final BandGroupName group;
    final InternationalString title;
    final short wavelength;

    private BandName(BandGroupName group, String name, short wavelength) {
        this.group = group;
        this.title = new SimpleInternationalString(name);
        this.wavelength = wavelength;
    }
}

