/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import java.time.Duration;
import org.apache.servicecomb.governance.policy.AbstractPolicy;

public class RateLimitingPolicy
extends AbstractPolicy {
    public static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofMillis(0L);
    public static final Duration DEFAULT_LIMIT_REFRESH_PERIOD = Duration.ofMillis(1000L);
    public static final int DEFAULT_LIMIT_FOR_PERIOD = 1000;
    protected String timeoutDuration = DEFAULT_TIMEOUT_DURATION.toString();
    protected String limitRefreshPeriod = DEFAULT_LIMIT_REFRESH_PERIOD.toString();
    protected int rate = 1000;

    public String getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public void setTimeoutDuration(String timeoutDuration) {
        this.timeoutDuration = this.stringOfDuration(timeoutDuration, DEFAULT_TIMEOUT_DURATION);
    }

    public String getLimitRefreshPeriod() {
        return this.limitRefreshPeriod;
    }

    public void setLimitRefreshPeriod(String limitRefreshPeriod) {
        this.limitRefreshPeriod = this.stringOfDuration(limitRefreshPeriod, DEFAULT_LIMIT_REFRESH_PERIOD);
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    @Override
    public boolean isValid() {
        if (Duration.parse(this.timeoutDuration).toMillis() < 0L) {
            return false;
        }
        if (Duration.parse(this.limitRefreshPeriod).toMillis() <= 0L) {
            return false;
        }
        if (this.rate <= 0) {
            return false;
        }
        return super.isValid();
    }

    public String toString() {
        return "RateLimitingPolicy{timeoutDuration=" + this.timeoutDuration + ", limitRefreshPeriod=" + this.limitRefreshPeriod + ", rate=" + this.rate + " req/s}";
    }
}

