/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class ControllerServicesResult
extends AbstractWritableResult<ControllerServicesEntity> {
    private final ControllerServicesEntity controllerServicesEntity;

    public ControllerServicesResult(ResultType resultType, ControllerServicesEntity controllerServicesEntity) {
        super(resultType);
        this.controllerServicesEntity = Objects.requireNonNull(controllerServicesEntity);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set serviceEntities = this.controllerServicesEntity.getControllerServices();
        if (serviceEntities == null) {
            return;
        }
        List serviceDTOS = serviceEntities.stream().map(s -> s.getComponent()).collect(Collectors.toList());
        Collections.sort(serviceDTOS, Comparator.comparing(ControllerServiceDTO::getName));
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, false).column("ID", 36, 36, false).column("State", 5, 40, false).build();
        for (int i = 0; i < serviceDTOS.size(); ++i) {
            ControllerServiceDTO serviceDTO = (ControllerServiceDTO)serviceDTOS.get(i);
            table.addRow(String.valueOf(i + 1), serviceDTO.getName(), serviceDTO.getId(), serviceDTO.getState());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ControllerServicesEntity getResult() {
        return this.controllerServicesEntity;
    }
}

