/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.plugin.coreit;

import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/**
 * A custom component configurator. Does not do much special compared to the basic one, but is sufficient to check
 * general support of the specific API.
 *
 * @author Benjamin Bentmann
 */
@Component(role = org.codehaus.plexus.component.configurator.ComponentConfigurator.class, hint = "coreit")
public class CustomComponentConfigurator extends AbstractComponentConfigurator {

    @Override
    public void configureComponent(
            Object component,
            PlexusConfiguration configuration,
            ExpressionEvaluator expressionEvaluator,
            ClassRealm containerRealm,
            ConfigurationListener listener)
            throws ComponentConfigurationException {
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();

        converter.processConfiguration(
                converterLookup, component, containerRealm, configuration, expressionEvaluator, listener);

        if (component instanceof CustomConfigMojo) {
            ((CustomConfigMojo) component).customParam = "configured";
        }
    }
}
