/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.opus;

import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggStreamAudioData;
import org.gagravarr.opus.OpusPacket;

public class OpusAudioData
extends OggStreamAudioData
implements OpusPacket {
    public static final int OPUS_GRANULE_RATE = 48000;
    private int numFrames = -1;
    private int numSamples = -1;

    public OpusAudioData(OggPacket pkt) {
        super(pkt);
    }

    public OpusAudioData(byte[] data) {
        super(data);
    }

    protected boolean isEndOfStream() {
        return this.getOggPacket().isEndOfStream();
    }

    public int getNumberOfFrames() {
        if (this.numFrames == -1) {
            this.calculateStructure();
        }
        return this.numFrames;
    }

    public int getNumberOfSamples() {
        if (this.numSamples == -1) {
            this.calculateStructure();
        }
        return this.numSamples;
    }

    private void calculateStructure() {
        byte[] d = this.getData();
        this.numFrames = OpusAudioData.packet_get_nb_frames(d);
        this.numSamples = this.numFrames * OpusAudioData.packet_get_samples_per_frame(d, 48000);
    }

    private static int packet_get_samples_per_frame(byte[] data, int fs) {
        int audiosize;
        if ((data[0] & 0x80) != 0) {
            audiosize = data[0] >> 3 & 3;
            audiosize = (fs << audiosize) / 400;
        } else {
            audiosize = (data[0] & 0x60) == 96 ? ((data[0] & 8) != 0 ? fs / 50 : fs / 100) : ((audiosize = data[0] >> 3 & 3) == 3 ? fs * 60 / 1000 : (fs << audiosize) / 100);
        }
        return audiosize;
    }

    private static int packet_get_nb_frames(byte[] packet) {
        int count = 0;
        if (packet.length < 1) {
            return -1;
        }
        count = packet[0] & 3;
        if (count == 0) {
            return 1;
        }
        if (count != 3) {
            return 2;
        }
        if (packet.length < 2) {
            return -4;
        }
        return packet[1] & 0x3F;
    }
}

