/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.nio.DoubleBuffer;
import org.apache.sis.image.LanczosInterpolation;

public interface Interpolation {
    public static final Interpolation NEAREST = new Interpolation(){

        public String toString() {
            return "NEAREST";
        }

        @Override
        public Dimension getSupportSize() {
            return new Dimension(1, 1);
        }

        @Override
        public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
            doubleBuffer.mark();
            doubleBuffer.get(dArray, n2, n);
            doubleBuffer.reset();
        }
    };
    public static final Interpolation BILINEAR = new Interpolation(){

        public String toString() {
            return "BILINEAR";
        }

        @Override
        public Dimension getSupportSize() {
            return new Dimension(2, 2);
        }

        @Override
        public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
            double d3 = 1.0 - d;
            double d4 = 1.0 - d2;
            for (int i = 0; i < n; ++i) {
                int n3 = doubleBuffer.position() + i;
                double d5 = doubleBuffer.get(n3) * d3;
                n3 = n3 + n;
                double d6 = (d5 + doubleBuffer.get(n3) * d) * d4 + (doubleBuffer.get(n3 += n) * d3 + doubleBuffer.get(n3 + n) * d) * d2;
                if (Double.isNaN(d6)) {
                    n3 = doubleBuffer.position() + i;
                    if (d >= 0.5) {
                        n3 += n;
                    }
                    if (d2 >= 0.5) {
                        n3 += n * 2;
                    }
                    d6 = doubleBuffer.get(n3);
                }
                dArray[n2++] = d6;
            }
        }
    };
    public static final Interpolation LANCZOS = new LanczosInterpolation(3);

    public Dimension getSupportSize();

    public void interpolate(DoubleBuffer var1, int var2, double var3, double var5, double[] var7, int var8);
}

