/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);

    public AmazonServiceException handle(HttpResponse errorResponse) throws IOException {
        InputStream is = errorResponse.getContent();
        if (is == null || errorResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
            String requestId = (String)errorResponse.getHeaders().get("x-amz-request-id");
            String extendedRequestId = (String)errorResponse.getHeaders().get("x-amz-id-2");
            AmazonS3Exception ase = new AmazonS3Exception(errorResponse.getStatusText());
            int statusCode = errorResponse.getStatusCode();
            ase.setStatusCode(statusCode);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            ase.setErrorType(this.errorTypeOf(statusCode));
            return ase;
        }
        String content = "";
        try {
            content = IOUtils.toString((InputStream)is);
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed in reading the error response", (Throwable)ex);
            }
            return this.newAmazonS3Exception(errorResponse.getStatusText(), errorResponse);
        }
        try {
            Document document = XpathUtils.documentFrom((String)content);
            XPath xpath = XpathUtils.xpath();
            String message = XpathUtils.asString((String)"Error/Message", (Node)document, (XPath)xpath);
            String errorCode = XpathUtils.asString((String)"Error/Code", (Node)document, (XPath)xpath);
            String requestId = XpathUtils.asString((String)"Error/RequestId", (Node)document, (XPath)xpath);
            String extendedRequestId = XpathUtils.asString((String)"Error/HostId", (Node)document, (XPath)xpath);
            AmazonS3Exception ase = new AmazonS3Exception(message);
            int statusCode = errorResponse.getStatusCode();
            ase.setStatusCode(statusCode);
            ase.setErrorType(this.errorTypeOf(statusCode));
            ase.setErrorCode(errorCode);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            return ase;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed in parsing the response as XML: " + content), (Throwable)ex);
            }
            return this.newAmazonS3Exception(content, errorResponse);
        }
    }

    private AmazonS3Exception newAmazonS3Exception(String errmsg, HttpResponse httpResponse) {
        AmazonS3Exception ase = new AmazonS3Exception(errmsg);
        int statusCode = httpResponse.getStatusCode();
        ase.setErrorCode(statusCode + " " + httpResponse.getStatusText());
        ase.setStatusCode(statusCode);
        ase.setErrorType(this.errorTypeOf(statusCode));
        return ase;
    }

    private AmazonServiceException.ErrorType errorTypeOf(int statusCode) {
        return statusCode >= 500 ? AmazonServiceException.ErrorType.Service : AmazonServiceException.ErrorType.Client;
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

