/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.PathItem;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Callback
extends OpenApiElement {
    private Map<String, PathItem> callbacks;

    public Callback() {
    }

    public Callback(Callback copyFrom) {
        super(copyFrom);
        this.callbacks = CollectionUtils.copyOf(copyFrom.callbacks);
    }

    public Callback addCallback(String expression, PathItem pathItem) {
        AssertionUtils.assertArgNotNull((String)"expression", (Object)expression);
        AssertionUtils.assertArgNotNull((String)"pathItem", (Object)pathItem);
        if (this.callbacks == null) {
            this.callbacks = new LinkedHashMap<String, PathItem>();
        }
        this.callbacks.put(expression, pathItem);
        return this;
    }

    public Callback copy() {
        return new Callback(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "callbacks" -> ConverterUtils.toType(this.getCallbacks(), type);
            default -> super.get(property, type);
        });
    }

    public Map<String, PathItem> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.callbacks), (Object)"callbacks").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Callback set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "callbacks" -> this.setCallbacks(ConverterUtils.toMapBuilder((Object)value, String.class, PathItem.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Callback setCallbacks(Map<String, PathItem> value) {
        this.callbacks = value;
        return this;
    }

    @Override
    public Callback strict() {
        super.strict();
        return this;
    }

    @Override
    public Callback strict(Object value) {
        super.strict(value);
        return this;
    }
}

