/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.settings;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.juneau.commons.settings.SettingStore;
import org.apache.juneau.commons.utils.Utils;

public class MapStore
implements SettingStore {
    private final AtomicReference<Map<String, Optional<String>>> map = new AtomicReference();

    @Override
    public Optional<String> get(String key) {
        Map<String, Optional<String>> m = this.map.get();
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    @Override
    public void set(String key, String value) {
        Map<String, Optional<String>> m = this.map.get();
        if (m == null) {
            ConcurrentHashMap<String, Optional<String>> newMap = new ConcurrentHashMap<String, Optional<String>>();
            m = this.map.compareAndSet(null, newMap) ? newMap : this.map.get();
        }
        m.put(key, Utils.opt(value));
    }

    @Override
    public void clear() {
        Map<String, Optional<String>> m = this.map.get();
        if (m != null) {
            m.clear();
        }
    }

    @Override
    public void unset(String name) {
        Map<String, Optional<String>> m = this.map.get();
        if (m != null) {
            m.remove(name);
        }
    }
}

