/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.ResponseContent;
import org.apache.juneau.rest.client.ResponseHeader;
import org.apache.juneau.rest.client.ResponseStatusLine;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.assertion.FluentResponseBodyAssertion;
import org.apache.juneau.rest.client.assertion.FluentResponseHeaderAssertion;
import org.apache.juneau.rest.client.assertion.FluentResponseStatusLineAssertion;

public class RestResponse
implements HttpResponse,
AutoCloseable {
    private final RestClient client;
    private final RestRequest request;
    private final HttpResponse response;
    private final Parser parser;
    private ResponseContent responseContent;
    private boolean isClosed;
    private HeaderList headers;
    private Map<HttpPartParser, HttpPartParserSession> partParserSessions = new IdentityHashMap<HttpPartParser, HttpPartParserSession>();
    private HttpPartParserSession partParserSession;

    protected RestResponse(RestClient client, RestRequest request, HttpResponse response, Parser parser) {
        this.client = client;
        this.request = request;
        this.parser = parser;
        this.response = response == null ? new BasicHttpResponse(null, 0, null) : response;
        this.responseContent = new ResponseContent(client, request, this, parser);
        this.headers = HeaderList.of(this.response.getAllHeaders());
    }

    public void addHeader(Header header) {
        this.headers.append(header);
    }

    public void addHeader(String name, String value) {
        this.headers.append(name, value);
    }

    public FluentStringAssertion<RestResponse> assertCharset() throws RestCallException {
        return new FluentStringAssertion<RestResponse>(this.getCharacterEncoding(), this);
    }

    public FluentResponseBodyAssertion<RestResponse> assertContent() {
        return new FluentResponseBodyAssertion<RestResponse>(this.responseContent, this);
    }

    public RestResponse assertContent(String value) {
        this.assertContent().is(value);
        return this;
    }

    public RestResponse assertContentMatches(String value) {
        this.assertContent().asString().isMatches(value);
        return this;
    }

    public FluentResponseHeaderAssertion<RestResponse> assertHeader(String name) {
        return new FluentResponseHeaderAssertion<RestResponse>(this.getHeader(name), this);
    }

    public FluentResponseStatusLineAssertion<RestResponse> assertStatus() {
        return new FluentResponseStatusLineAssertion<RestResponse>(this.getStatusLine(), this);
    }

    public RestResponse assertStatus(int value) {
        this.assertStatus().asCode().is(value);
        return this;
    }

    public RestResponse cacheContent() {
        this.responseContent.cache();
        return this;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            if (!this.request.isLoggingSuppressed() && (this.request.isDebug() || this.client.logRequestsPredicate.test(this.request, this))) {
                if (this.client.logRequests == DetailLevel.SIMPLE) {
                    this.client.log(this.client.logRequestsLevel, "HTTP {0} {1}, {2}", this.request.getMethod(), this.request.getURI(), this.getStatusLine());
                } else if (this.request.isDebug() || this.client.logRequests == DetailLevel.FULL) {
                    String output = this.getContent().asString();
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n=== HTTP Call (outgoing) ======================================================");
                    sb.append("\n=== REQUEST ===\n");
                    sb.append(this.request.getMethod()).append(" ").append(this.request.getURI());
                    sb.append("\n---request headers---");
                    this.request.getHeaders().forEach(x -> sb.append("\n\t").append(x));
                    if (this.request.hasHttpEntity()) {
                        sb.append("\n---request entity---");
                        ResponseHeader[] e = this.request.getHttpEntity();
                        if (Utils.nn(e.getContentType())) {
                            sb.append("\n\t").append(e.getContentType());
                        }
                        if (e.isRepeatable()) {
                            try {
                                sb.append("\n---request content---\n").append(EntityUtils.toString((HttpEntity)e));
                            }
                            catch (Exception ex) {
                                sb.append("\n---request content exception---\n").append(ex.getMessage());
                            }
                        }
                    }
                    sb.append("\n=== RESPONSE ===\n").append(this.getStatusLine());
                    sb.append("\n---response headers---");
                    for (ResponseHeader h : this.getAllHeaders()) {
                        sb.append("\n\t").append(h);
                    }
                    sb.append("\n---response content---\n").append(output);
                    sb.append("\n=== END =======================================================================");
                    this.client.log(this.client.logRequestsLevel, sb.toString(), new Object[0]);
                }
            }
            for (RestCallInterceptor r : this.request.interceptors) {
                try {
                    r.onClose(this.request, this);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RestCallException(this, e, "Interceptor throw exception on close", new Object[0]);
                }
            }
            this.client.onCallClose(this.request, this);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.client.log(Level.WARNING, e, "Error during RestResponse close", new Object[0]);
        }
    }

    public RestResponse consume() {
        this.close();
        return this;
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public ResponseHeader[] getAllHeaders() {
        return (ResponseHeader[])this.headers.stream().map(x -> new ResponseHeader(x.getName(), this.request, this, (Header)x).parser(this.getPartParserSession())).toArray(ResponseHeader[]::new);
    }

    public String getCharacterEncoding() throws RestCallException {
        Optional<ContentType> ct = this.getContentType();
        String s = null;
        if (ct.isPresent()) {
            s = this.getContentType().get().getParameter("charset");
        }
        return Utils.e(s) ? "utf-8" : s;
    }

    public ResponseContent getContent() {
        return this.responseContent;
    }

    public Optional<ContentType> getContentType() throws RestCallException {
        return this.getHeader("Content-Type").as(ContentType.class);
    }

    public ResponseContent getEntity() {
        return this.responseContent;
    }

    public ResponseHeader getFirstHeader(String name) {
        return new ResponseHeader(name, this.request, this, this.headers.getFirst(name).orElse(null)).parser(this.getPartParserSession());
    }

    public ResponseHeader getHeader(String name) {
        return new ResponseHeader(name, this.request, this, this.headers.get(name).orElse(null)).parser(this.getPartParserSession());
    }

    public ResponseHeader[] getHeaders(String name) {
        return (ResponseHeader[])this.headers.stream(name).map(x -> new ResponseHeader(name, this.request, this, (Header)x).parser(this.getPartParserSession())).toArray(ResponseHeader[]::new);
    }

    public ResponseHeader getLastHeader(String name) {
        return new ResponseHeader(name, this.request, this, this.headers.getLast(name).orElse(null)).parser(this.getPartParserSession());
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    @Deprecated
    public HttpParams getParams() {
        return this.response.getParams();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public String getReasonPhrase() {
        return this.getStatusLine().getReasonPhrase();
    }

    public RestRequest getRequest() {
        return this.request;
    }

    public int getStatusCode() {
        return this.getStatusLine().getStatusCode();
    }

    public ResponseStatusLine getStatusLine() {
        return new ResponseStatusLine(this, this.response.getStatusLine());
    }

    public Optional<String> getStringHeader(String name) {
        return this.getHeader(name).asString();
    }

    public HeaderIterator headerIterator() {
        return this.headers.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headers.headerIterator(name);
    }

    public RestResponse log(Level level, String msg, Object ... args) {
        this.client.log(level, msg, args);
        return this;
    }

    public RestResponse log(Level level, Throwable t, String msg, Object ... args) {
        this.client.log(level, t, msg, args);
        return this;
    }

    public void removeHeader(Header header) {
        this.headers.remove(header);
    }

    public void removeHeaders(String name) {
        this.headers.remove(name);
    }

    public void setEntity(HttpEntity entity) {
        this.response.setEntity(entity);
        this.responseContent = new ResponseContent(this.client, this.request, this, this.parser);
    }

    public void setHeader(Header header) {
        this.headers.set(header);
    }

    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.headers = HeaderList.of(headers);
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.response.setParams(params);
    }

    public void setReasonPhrase(String reason) {
        this.response.setReasonPhrase(reason);
    }

    public void setStatusCode(int code) {
        this.response.setStatusCode(code);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.response.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.response.setStatusLine(ver, code, reason);
    }

    public void setStatusLine(StatusLine statusline) {
        this.response.setStatusLine(statusline);
    }

    protected HttpPartParserSession getPartParserSession() {
        if (this.partParserSession == null) {
            this.partParserSession = this.client.getPartParser().getPartSession();
        }
        return this.partParserSession;
    }

    protected HttpPartParserSession getPartParserSession(HttpPartParser parser) {
        HttpPartParserSession s = this.partParserSessions.get(parser);
        if (s == null) {
            s = parser.getPartSession();
            this.partParserSessions.put(parser, s);
        }
        return s;
    }

    <T> T as(ResponseBeanMeta rbm) {
        Class c = rbm.getClassMeta().inner();
        RestClient rc = this.client;
        return (T)Proxy.newProxyInstance(c.getClassLoader(), CollectionUtils.a(c), (proxy, method, args) -> {
            ResponseBeanPropertyMeta pm = rbm.getProperty(method.getName());
            HttpPartParserSession pp = this.getPartParserSession(pm.getParser().orElse(rc.getPartParser()));
            HttpPartSchema schema = pm.getSchema();
            HttpPartType pt = pm.getPartType();
            String name = pm.getPartName().orElse(null);
            ClassMeta type = rc.getBeanContext().getClassMeta(method.getGenericReturnType(), new Type[0]);
            if (pt == HttpPartType.RESPONSE_HEADER) {
                return this.getHeader(name).parser(pp).schema(schema).as(type).orElse(null);
            }
            if (pt == HttpPartType.RESPONSE_STATUS) {
                return this.getStatusCode();
            }
            return this.getContent().schema(schema).as(type);
        });
    }

    HttpResponse asHttpResponse() {
        return this.response;
    }
}

