/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.annotation.Items;
import org.apache.juneau.annotation.ItemsAnnotation;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.annotation.SubItems;
import org.apache.juneau.annotation.SubItemsAnnotation;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.Lists;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.PathRemainder;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.parser.ParseException;

public class HttpPartSchema {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    public static final HttpPartSchema DEFAULT = HttpPartSchema.create().allowEmptyValue(true).build();
    public static final HttpPartSchema T_BOOLEAN = HttpPartSchema.tBoolean().build();
    public static final HttpPartSchema T_FILE = HttpPartSchema.tFile().build();
    public static final HttpPartSchema T_INTEGER = HttpPartSchema.tInteger().build();
    public static final HttpPartSchema T_INT32 = HttpPartSchema.tInt32().build();
    public static final HttpPartSchema T_INT64 = HttpPartSchema.tInt64().build();
    public static final HttpPartSchema T_NONE = HttpPartSchema.tNone().build();
    public static final HttpPartSchema T_NUMBER = HttpPartSchema.tNumber().build();
    public static final HttpPartSchema T_FLOAT = HttpPartSchema.tFloat().build();
    public static final HttpPartSchema T_DOUBLE = HttpPartSchema.tDouble().build();
    public static final HttpPartSchema T_STRING = HttpPartSchema.tString().build();
    public static final HttpPartSchema T_BYTE = HttpPartSchema.tByte().build();
    public static final HttpPartSchema T_BINARY = HttpPartSchema.tBinary().build();
    public static final HttpPartSchema T_BINARY_SPACED = HttpPartSchema.tBinarySpaced().build();
    public static final HttpPartSchema T_DATE = HttpPartSchema.tDate().build();
    public static final HttpPartSchema T_DATETIME = HttpPartSchema.tDateTime().build();
    public static final HttpPartSchema T_UON = HttpPartSchema.tUon().build();
    public static final HttpPartSchema T_ARRAY = HttpPartSchema.tArray().build();
    public static final HttpPartSchema T_ARRAY_CSV = HttpPartSchema.tArrayCsv().build();
    public static final HttpPartSchema T_ARRAY_PIPES = HttpPartSchema.tArrayPipes().build();
    public static final HttpPartSchema T_ARRAY_SSV = HttpPartSchema.tArraySsv().build();
    public static final HttpPartSchema T_ARRAY_TSV = HttpPartSchema.tArrayTsv().build();
    public static final HttpPartSchema T_ARRAY_UON = HttpPartSchema.tArrayUon().build();
    public static final HttpPartSchema T_ARRAY_MULTI = HttpPartSchema.tArrayMulti().build();
    public static final HttpPartSchema T_OBJECT = HttpPartSchema.tObject().build();
    public static final HttpPartSchema T_OBJECT_CSV = HttpPartSchema.tObjectCsv().build();
    public static final HttpPartSchema T_OBJECT_PIPES = HttpPartSchema.tObjectPipes().build();
    public static final HttpPartSchema T_OBJECT_SSV = HttpPartSchema.tObjectSsv().build();
    public static final HttpPartSchema T_OBJECT_TSV = HttpPartSchema.tObjectTsv().build();
    public static final HttpPartSchema T_OBJECT_UON = HttpPartSchema.tObjectUon().build();
    final String name;
    final String default_;
    final Set<String> enum_;
    final Map<String, HttpPartSchema> properties;
    final boolean allowEmptyValue;
    final boolean exclusiveMaximum;
    final boolean exclusiveMinimum;
    final boolean required;
    final boolean uniqueItems;
    final boolean skipIfEmpty;
    final HttpPartCollectionFormat collectionFormat;
    final HttpPartDataType type;
    final HttpPartFormat format;
    final Pattern pattern;
    final HttpPartSchema items;
    final HttpPartSchema additionalProperties;
    final Number maximum;
    final Number minimum;
    final Number multipleOf;
    final Long maxLength;
    final Long minLength;
    final Long maxItems;
    final Long minItems;
    final Long maxProperties;
    final Long minProperties;
    final Class<? extends HttpPartParser> parser;
    final Class<? extends HttpPartSerializer> serializer;
    final ClassMeta<?> parsedType;
    final String const_;
    final String[] examples;
    final boolean deprecated;
    final Number exclusiveMaximumValue;
    final Number exclusiveMinimumValue;

    public static Builder create() {
        return new Builder();
    }

    public static HttpPartSchema create(Annotation a) {
        return HttpPartSchema.create().apply(a).build();
    }

    public static HttpPartSchema create(Annotation a, String defaultName) {
        return HttpPartSchema.create().name(defaultName).apply(a).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Type t) {
        return HttpPartSchema.create().applyAll(c, t).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Method m) {
        return HttpPartSchema.create().applyAll(c, m).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, ParameterInfo mpi) {
        return HttpPartSchema.create().applyAll(c, mpi).build();
    }

    public static Builder create(String type) {
        return HttpPartSchema.create().type(type);
    }

    public static Builder create(String type, String format) {
        return HttpPartSchema.create().type(type).format(format);
    }

    public static Builder tArray() {
        return HttpPartSchema.create().tArray();
    }

    public static Builder tArray(Builder items) {
        return HttpPartSchema.create().tArray().items(items);
    }

    public static Builder tArrayCsv() {
        return HttpPartSchema.create().tArray().cfCsv();
    }

    public static Builder tArrayCsv(Builder items) {
        return HttpPartSchema.create().tArray().cfCsv().items(items);
    }

    public static Builder tArrayMulti() {
        return HttpPartSchema.create().tArray().cfMulti();
    }

    public static Builder tArrayMulti(Builder items) {
        return HttpPartSchema.create().tArray().cfMulti().items(items);
    }

    public static Builder tArrayPipes() {
        return HttpPartSchema.create().tArray().cfPipes();
    }

    public static Builder tArrayPipes(Builder items) {
        return HttpPartSchema.create().tArray().cfPipes().items(items);
    }

    public static Builder tArraySsv() {
        return HttpPartSchema.create().tArray().cfSsv();
    }

    public static Builder tArraySsv(Builder items) {
        return HttpPartSchema.create().tArray().cfSsv().items(items);
    }

    public static Builder tArrayTsv() {
        return HttpPartSchema.create().tArray().cfTsv();
    }

    public static Builder tArrayTsv(Builder items) {
        return HttpPartSchema.create().tArray().cfTsv().items(items);
    }

    public static Builder tArrayUon() {
        return HttpPartSchema.create().tArray().cfUon();
    }

    public static Builder tArrayUon(Builder items) {
        return HttpPartSchema.create().tArray().cfUon().items(items);
    }

    public static Builder tBinary() {
        return HttpPartSchema.create().tString().fBinary();
    }

    public static Builder tBinarySpaced() {
        return HttpPartSchema.create().tString().fBinarySpaced();
    }

    public static Builder tBoolean() {
        return HttpPartSchema.create().tBoolean();
    }

    public static Builder tByte() {
        return HttpPartSchema.create().tString().fByte();
    }

    public static Builder tDate() {
        return HttpPartSchema.create().tString().fDate();
    }

    public static Builder tDateTime() {
        return HttpPartSchema.create().tString().fDateTime();
    }

    public static Builder tDouble() {
        return HttpPartSchema.create().tNumber().fDouble();
    }

    public static Builder tFile() {
        return HttpPartSchema.create().tFile();
    }

    public static Builder tFloat() {
        return HttpPartSchema.create().tNumber().fFloat();
    }

    public static Builder tInt32() {
        return HttpPartSchema.create().tInteger().fInt32();
    }

    public static Builder tInt64() {
        return HttpPartSchema.create().tInteger().fInt64();
    }

    public static Builder tInteger() {
        return HttpPartSchema.create().tInteger();
    }

    public static Builder tNone() {
        return HttpPartSchema.create().tNone();
    }

    public static Builder tNumber() {
        return HttpPartSchema.create().tNumber();
    }

    public static Builder tObject() {
        return HttpPartSchema.create().tObject();
    }

    public static Builder tObjectCsv() {
        return HttpPartSchema.create().tObject().cfCsv();
    }

    public static Builder tObjectPipes() {
        return HttpPartSchema.create().tObject().cfPipes();
    }

    public static Builder tObjectSsv() {
        return HttpPartSchema.create().tObject().cfSsv();
    }

    public static Builder tObjectTsv() {
        return HttpPartSchema.create().tObject().cfTsv();
    }

    public static Builder tObjectUon() {
        return HttpPartSchema.create().tObject().cfUon();
    }

    public static Builder tString() {
        return HttpPartSchema.create().tString();
    }

    public static Builder tUon() {
        return HttpPartSchema.create().tString().fUon();
    }

    private static Map<String, HttpPartSchema> build(Map<String, Object> in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        LinkedHashMap m = CollectionUtils.map();
        in.forEach((k, v) -> m.put(k, HttpPartSchema.build(v, noValidate)));
        return CollectionUtils.u((Map)m);
    }

    private static HttpPartSchema build(Object in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        if (in instanceof HttpPartSchema) {
            HttpPartSchema in2 = (HttpPartSchema)in;
            return in2;
        }
        return ((Builder)in).noValidate(noValidate).build();
    }

    private static <T> Set<T> copy(Set<T> in) {
        return in == null ? Collections.emptySet() : CollectionUtils.u((Set)CollectionUtils.copyOf(in));
    }

    static final JsonMap toJsonMap(String[] ss) {
        Object s = StringUtils.joinnl((Object[])ss);
        if (((String)s).isEmpty()) {
            return null;
        }
        if (!StringUtils.isProbablyJsonObject((Object)s, (boolean)true)) {
            s = "{" + (String)s + "}";
        }
        try {
            return JsonMap.ofJson((CharSequence)s);
        }
        catch (ParseException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    static final Number toNumber(String ... s) {
        try {
            for (String ss : s) {
                if (!Utils.ne((CharSequence)ss)) continue;
                return StringUtils.parseNumber((String)ss, Number.class);
            }
            return null;
        }
        catch (ParseException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    static final Set<String> toSet(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        LinkedHashSet set = CollectionUtils.set((Object[])new String[0]);
        try {
            JsonList.ofJsonOrCdl(s).forEach(x -> set.add(x.toString()));
        }
        catch (ParseException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
        return set;
    }

    static final Set<String> toSet(String[] ... s) {
        boolean isNotEmpty = false;
        for (String[] ss : s) {
            isNotEmpty |= ss.length > 0;
        }
        if (!isNotEmpty) {
            return null;
        }
        LinkedHashSet set = CollectionUtils.set((Object[])new String[0]);
        for (String[] ss : s) {
            if (!Utils.nn((Object)ss)) continue;
            for (String ss2 : ss) {
                StringUtils.split((String)ss2, x -> set.add(x));
            }
        }
        return set.isEmpty() ? null : set;
    }

    HttpPartSchema(Builder b) {
        this.name = b.name;
        this.default_ = b.default_;
        this.enum_ = HttpPartSchema.copy(b.enum_);
        this.properties = HttpPartSchema.build(b.properties, b.noValidate);
        this.allowEmptyValue = HttpPartSchema.resolve(b.allowEmptyValue);
        this.exclusiveMaximum = HttpPartSchema.resolve(b.exclusiveMaximum);
        this.exclusiveMinimum = HttpPartSchema.resolve(b.exclusiveMinimum);
        this.required = HttpPartSchema.resolve(b.required);
        this.uniqueItems = HttpPartSchema.resolve(b.uniqueItems);
        this.skipIfEmpty = HttpPartSchema.resolve(b.skipIfEmpty);
        this.collectionFormat = b.collectionFormat;
        this.type = b.type;
        this.format = b.format;
        this.pattern = b.pattern;
        this.items = HttpPartSchema.build(b.items, b.noValidate);
        this.additionalProperties = HttpPartSchema.build(b.additionalProperties, b.noValidate);
        this.maximum = b.maximum;
        this.minimum = b.minimum;
        this.multipleOf = b.multipleOf;
        this.maxItems = b.maxItems;
        this.maxLength = b.maxLength;
        this.maxProperties = b.maxProperties;
        this.minItems = b.minItems;
        this.minLength = b.minLength;
        this.minProperties = b.minProperties;
        this.parser = b.parser;
        this.serializer = b.serializer;
        this.const_ = b.const_;
        this.examples = b.examples;
        this.deprecated = HttpPartSchema.resolve(b.deprecated);
        this.exclusiveMaximumValue = b.exclusiveMaximumValue;
        this.exclusiveMinimumValue = b.exclusiveMinimumValue;
        Class parsedType = Object.class;
        if (this.type == HttpPartDataType.ARRAY) {
            if (Utils.nn((Object)this.items)) {
                parsedType = Array.newInstance(this.items.parsedType.inner(), 0).getClass();
            }
        } else if (this.type == HttpPartDataType.BOOLEAN) {
            parsedType = Boolean.class;
        } else if (this.type == HttpPartDataType.INTEGER) {
            parsedType = this.format == HttpPartFormat.INT64 ? Long.class : Integer.class;
        } else if (this.type == HttpPartDataType.NUMBER) {
            parsedType = this.format == HttpPartFormat.DOUBLE ? Double.class : Float.class;
        } else if (this.type == HttpPartDataType.STRING) {
            parsedType = this.format == HttpPartFormat.BYTE || this.format == HttpPartFormat.BINARY || this.format == HttpPartFormat.BINARY_SPACED ? byte[].class : (this.format == HttpPartFormat.DATE || this.format == HttpPartFormat.DATE_TIME ? Calendar.class : String.class);
        }
        this.parsedType = BeanContext.DEFAULT.getClassMeta(parsedType);
        if (b.noValidate) {
            return;
        }
        List errors = CollectionUtils.list((Object[])new Object[0]);
        Lists notAllowed = CollectionUtils.listb(String.class);
        boolean invalidFormat = false;
        switch (this.type) {
            case STRING: {
                notAllowed.addIf(Utils.nn(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(this.exclusiveMaximum, (Object)"exclusiveMaximum").addIf(this.exclusiveMinimum, (Object)"exclusiveMinimum").addIf(this.uniqueItems, (Object)"uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, (Object)"collectionFormat").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.BYTE, HttpPartFormat.BINARY, HttpPartFormat.BINARY_SPACED, HttpPartFormat.DATE, HttpPartFormat.DATE_TIME, HttpPartFormat.PASSWORD, HttpPartFormat.UON, HttpPartFormat.NO_FORMAT);
                break;
            }
            case ARRAY: {
                notAllowed.addIf(Utils.nn(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(this.exclusiveMaximum, (Object)"exclusiveMaximum").addIf(this.exclusiveMinimum, (Object)"exclusiveMinimum").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.maxProperties), (Object)"maxProperties").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON);
                break;
            }
            case BOOLEAN: {
                notAllowed.addIf(!this.enum_.isEmpty(), (Object)"enum").addIf(Utils.nn(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(this.exclusiveMaximum, (Object)"exclusiveMaximum").addIf(this.exclusiveMinimum, (Object)"exclusiveMinimum").addIf(this.uniqueItems, (Object)"uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, (Object)"collectionFormat").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.maxProperties), (Object)"maxProperties").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON);
                break;
            }
            case FILE: {
                break;
            }
            case INTEGER: {
                notAllowed.addIf(Utils.nn(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(this.uniqueItems, (Object)"uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, (Object)"collectionFormat").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.maxProperties), (Object)"maxProperties").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON, HttpPartFormat.INT32, HttpPartFormat.INT64);
                break;
            }
            case NUMBER: {
                notAllowed.addIf(Utils.nn(this.properties), (Object)"properties").addIf(Utils.nn((Object)this.additionalProperties), (Object)"additionalProperties").addIf(this.uniqueItems, (Object)"uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, (Object)"collectionFormat").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.maxProperties), (Object)"maxProperties").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength").addIf(Utils.nn((Object)this.minProperties), (Object)"minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON, HttpPartFormat.FLOAT, HttpPartFormat.DOUBLE);
                break;
            }
            case OBJECT: {
                notAllowed.addIf(this.exclusiveMaximum, (Object)"exclusiveMaximum").addIf(this.exclusiveMinimum, (Object)"exclusiveMinimum").addIf(this.uniqueItems, (Object)"uniqueItems").addIf(Utils.nn((Object)this.pattern), (Object)"pattern").addIf(Utils.nn((Object)this.items), (Object)"items").addIf(Utils.nn((Object)this.maximum), (Object)"maximum").addIf(Utils.nn((Object)this.minimum), (Object)"minimum").addIf(Utils.nn((Object)this.multipleOf), (Object)"multipleOf").addIf(Utils.nn((Object)this.maxItems), (Object)"maxItems").addIf(Utils.nn((Object)this.maxLength), (Object)"maxLength").addIf(Utils.nn((Object)this.minItems), (Object)"minItems").addIf(Utils.nn((Object)this.minLength), (Object)"minLength");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT);
                break;
            }
        }
        List notAllowed2 = notAllowed.build();
        if (!notAllowed2.isEmpty()) {
            errors.add("Attributes not allow for type='" + String.valueOf((Object)this.type) + "': " + StringUtils.join((Collection)notAllowed2, (String)","));
        }
        if (invalidFormat) {
            errors.add("Invalid format for type='" + String.valueOf((Object)this.type) + "': '" + String.valueOf((Object)this.format) + "'");
        }
        if (this.exclusiveMaximum && this.maximum == null) {
            errors.add("Cannot specify exclusiveMaximum with maximum.");
        }
        if (this.exclusiveMinimum && this.minimum == null) {
            errors.add("Cannot specify exclusiveMinimum with minimum.");
        }
        if (this.required && Utils.nn((Object)this.default_)) {
            errors.add("Cannot specify a default value on a required value.");
        }
        if (Utils.nn((Object)this.minLength) && Utils.nn((Object)this.maxLength) && this.maxLength < this.minLength) {
            errors.add("maxLength cannot be less than minLength.");
        }
        if (Utils.nn((Object)this.minimum) && Utils.nn((Object)this.maximum) && this.maximum.doubleValue() < this.minimum.doubleValue()) {
            errors.add("maximum cannot be less than minimum.");
        }
        if (Utils.nn((Object)this.minItems) && Utils.nn((Object)this.maxItems) && this.maxItems < this.minItems) {
            errors.add("maxItems cannot be less than minItems.");
        }
        if (Utils.nn((Object)this.minProperties) && Utils.nn((Object)this.maxProperties) && this.maxProperties < this.minProperties) {
            errors.add("maxProperties cannot be less than minProperties.");
        }
        if (Utils.nn((Object)this.minLength) && this.minLength < 0L) {
            errors.add("minLength cannot be less than zero.");
        }
        if (Utils.nn((Object)this.maxLength) && this.maxLength < 0L) {
            errors.add("maxLength cannot be less than zero.");
        }
        if (Utils.nn((Object)this.minItems) && this.minItems < 0L) {
            errors.add("minItems cannot be less than zero.");
        }
        if (Utils.nn((Object)this.maxItems) && this.maxItems < 0L) {
            errors.add("maxItems cannot be less than zero.");
        }
        if (Utils.nn((Object)this.minProperties) && this.minProperties < 0L) {
            errors.add("minProperties cannot be less than zero.");
        }
        if (Utils.nn((Object)this.maxProperties) && this.maxProperties < 0L) {
            errors.add("maxProperties cannot be less than zero.");
        }
        if (this.type == HttpPartDataType.ARRAY && Utils.nn((Object)this.items) && this.items.getType() == HttpPartDataType.OBJECT && this.format != HttpPartFormat.UON && this.format != HttpPartFormat.NO_FORMAT) {
            errors.add("Cannot define an array of objects unless array format is 'uon'.");
        }
        if (!errors.isEmpty()) {
            throw new ContextRuntimeException("Schema specification errors: \n\t" + StringUtils.join((Collection)errors, (String)"\n\t"), new Object[0]);
        }
    }

    public HttpPartCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public String getDefault() {
        return this.default_;
    }

    public Set<String> getEnum() {
        return this.enum_;
    }

    public HttpPartFormat getFormat() {
        return this.format;
    }

    public HttpPartFormat getFormat(ClassMeta<?> cm) {
        if (this.format != HttpPartFormat.NO_FORMAT) {
            return this.format;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                if (cm.isDouble()) {
                    return HttpPartFormat.DOUBLE;
                }
                return HttpPartFormat.FLOAT;
            }
            if (cm.isLong()) {
                return HttpPartFormat.INT64;
            }
            return HttpPartFormat.INT32;
        }
        return this.format;
    }

    public HttpPartSchema getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Long getMaxItems() {
        return this.maxItems;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Long getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Long getMinItems() {
        return this.minItems;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMinProperties() {
        return this.minProperties;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public String getName() {
        return this.name;
    }

    public ClassMeta<?> getParsedType() {
        return this.parsedType;
    }

    public Class<? extends HttpPartParser> getParser() {
        return this.parser;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public HttpPartSchema getProperty(String name) {
        HttpPartSchema schema;
        if (Utils.nn(this.properties) && Utils.nn((Object)(schema = this.properties.get(name)))) {
            return schema;
        }
        return this.additionalProperties;
    }

    public Class<? extends HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    public HttpPartDataType getType() {
        return this.type;
    }

    public HttpPartDataType getType(ClassMeta<?> cm) {
        if (this.type != HttpPartDataType.NO_TYPE) {
            return this.type;
        }
        if (cm.isTemporal() || cm.isDateOrCalendar()) {
            return HttpPartDataType.STRING;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                return HttpPartDataType.NUMBER;
            }
            return HttpPartDataType.INTEGER;
        }
        if (cm.isBoolean()) {
            return HttpPartDataType.BOOLEAN;
        }
        if (cm.isMapOrBean()) {
            return HttpPartDataType.OBJECT;
        }
        if (cm.isCollectionOrArray()) {
            return HttpPartDataType.ARRAY;
        }
        return HttpPartDataType.STRING;
    }

    public boolean hasProperties() {
        return Utils.nn(this.properties) || Utils.nn((Object)this.additionalProperties);
    }

    public boolean isAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSkipIfEmpty() {
        return this.skipIfEmpty;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    protected FluentMap<String, Object> properties() {
        Predicate<Object> ne = x -> Utils.ne((CharSequence)Utils.s((Object)x));
        Predicate<Object> nf = x -> x instanceof Boolean && (Boolean)x != false;
        Predicate<Object> nm1 = x -> x instanceof Number && ((Number)x).intValue() != -1;
        Predicate<Object> nn = Utils::nn;
        return CollectionUtils.mapb_so().sorted().buildFluent().ai(ne, (Object)"name", (Object)this.name).ai(ne, (Object)"type", (Object)this.type).ai(ne, (Object)"format", (Object)this.format).ai(ne, (Object)"default", (Object)this.default_).ai(ne, (Object)"enum", this.enum_).ai(ne, (Object)"properties", this.properties).ai(nf, (Object)"allowEmptyValue", (Object)this.allowEmptyValue).ai(nf, (Object)"exclusiveMaximum", (Object)this.exclusiveMaximum).ai(nf, (Object)"exclusiveMinimum", (Object)this.exclusiveMinimum).ai(nf, (Object)"required", (Object)this.required).ai(nf, (Object)"uniqueItems", (Object)this.uniqueItems).ai(nf, (Object)"skipIfEmpty", (Object)this.skipIfEmpty).ai(x -> x != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, (Object)"collectionFormat", (Object)this.collectionFormat).ai(ne, (Object)"pattern", (Object)this.pattern).ai(nn, (Object)"items", (Object)this.items).ai(nn, (Object)"additionalProperties", (Object)this.additionalProperties).ai(nm1, (Object)"maximum", (Object)this.maximum).ai(nm1, (Object)"minimum", (Object)this.minimum).ai(nm1, (Object)"multipleOf", (Object)this.multipleOf).ai(nm1, (Object)"maxLength", (Object)this.maxLength).ai(nm1, (Object)"minLength", (Object)this.minLength).ai(nm1, (Object)"maxItems", (Object)this.maxItems).ai(nm1, (Object)"minItems", (Object)this.minItems).ai(nm1, (Object)"maxProperties", (Object)this.maxProperties).ai(nm1, (Object)"minProperties", (Object)this.minProperties).a((Object)"parsedType", this.parsedType);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    public String validateInput(String in) throws SchemaValidationException {
        if (!this.isValidRequired(in)) {
            throw new SchemaValidationException("No value specified.", new Object[0]);
        }
        if (Utils.nn((Object)in)) {
            if (!this.isValidAllowEmpty(in)) {
                throw new SchemaValidationException("Empty value not allowed.", new Object[0]);
            }
            if (!this.isValidConst(in)) {
                throw new SchemaValidationException("Value does not match constant.  Must be: {0}", this.const_);
            }
            if (!this.isValidPattern(in)) {
                throw new SchemaValidationException("Value does not match expected pattern.  Must match pattern: {0}", this.pattern.pattern());
            }
            if (!this.isValidEnum(in)) {
                throw new SchemaValidationException("Value does not match one of the expected values.  Must be one of the following:  {0}", StringUtils.toCdl(this.enum_));
            }
            if (!this.isValidMaxLength(in)) {
                throw new SchemaValidationException("Maximum length of value exceeded.", new Object[0]);
            }
            if (!this.isValidMinLength(in)) {
                throw new SchemaValidationException("Minimum length of value not met.", new Object[0]);
            }
            if (!this.isValidFormat(in)) {
                throw new SchemaValidationException("Value does not match expected format: {0}", new Object[]{this.format});
            }
        }
        return in;
    }

    public <T> T validateOutput(T o, BeanContext bc) throws SchemaValidationException {
        if (o == null) {
            if (!this.isValidRequired(o)) {
                throw new SchemaValidationException("Required value not provided.", new Object[0]);
            }
            return o;
        }
        ClassMeta<T> cm = bc.getClassMetaForObject(o);
        switch (this.getType(cm)) {
            case ARRAY: {
                if (cm.isArray()) {
                    if (!this.isValidMinItems(o)) {
                        throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                    }
                    if (!this.isValidMaxItems(o)) {
                        throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                    }
                    if (!this.isValidUniqueItems(o)) {
                        throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                    }
                    HttpPartSchema items = this.getItems();
                    if (!Utils.nn((Object)items)) break;
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        items.validateOutput(Array.get(o, i), bc);
                    }
                    break;
                }
                if (!cm.isCollection()) break;
                Collection c = (Collection)o;
                if (!this.isValidMinItems(c)) {
                    throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                }
                if (!this.isValidMaxItems(c)) {
                    throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                }
                if (!this.isValidUniqueItems(c)) {
                    throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                }
                HttpPartSchema items = this.getItems();
                if (!Utils.nn((Object)items)) break;
                c.forEach(x -> items.validateOutput(x, bc));
                break;
            }
            case INTEGER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case NUMBER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case OBJECT: {
                if (cm.isMapOrBean()) {
                    BeanMap<T> m;
                    BeanMap<T> beanMap = m = cm.isMap() ? (BeanMap<T>)o : bc.toBeanMap(o);
                    if (!this.isValidMinProperties(m)) {
                        throw new SchemaValidationException("Minimum number of properties not met.", new Object[0]);
                    }
                    if (!this.isValidMaxProperties(m)) {
                        throw new SchemaValidationException("Maximum number of properties exceeded.", new Object[0]);
                    }
                    m.forEach((k, v) -> {
                        String key = k.toString();
                        HttpPartSchema s2 = this.getProperty(key);
                        if (Utils.nn((Object)s2)) {
                            s2.validateOutput(v, bc);
                        }
                    });
                    break;
                }
                if (!cm.isBean()) break;
                break;
            }
            case STRING: {
                if (!cm.isCharSequence()) break;
                String s = o.toString();
                if (!this.isValidMinLength(s)) {
                    throw new SchemaValidationException("Minimum length of value not met.", new Object[0]);
                }
                if (!this.isValidMaxLength(s)) {
                    throw new SchemaValidationException("Maximum length of value exceeded.", new Object[0]);
                }
                if (!this.isValidPattern(s)) {
                    throw new SchemaValidationException("Value does not match expected pattern.  Must match pattern: {0}", this.pattern.pattern());
                }
                if (this.isValidFormat(s)) break;
                throw new SchemaValidationException("Value does not match expected format: {0}", new Object[]{this.format});
            }
            case BOOLEAN: 
            case FILE: 
            case NO_TYPE: {
                break;
            }
        }
        return o;
    }

    private boolean isValidAllowEmpty(String x) {
        return this.allowEmptyValue || Utils.ne((CharSequence)x);
    }

    private boolean isValidConst(String x) {
        return this.const_ == null || this.const_.equals(x);
    }

    private static boolean isValidDate(String x) {
        return x.matches("^\\d{4}[-/]\\d{1,2}[-/]\\d{1,2}.*");
    }

    private static boolean isValidDateTime(String x) {
        return x.matches("^\\d{4}[-/]\\d{1,2}[-/]\\d{1,2}[T\\s]\\d{1,2}:\\d{1,2}.*");
    }

    private static boolean isValidDateTimeZone(String x) {
        return x.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?[+-]\\d{2}:\\d{2}$");
    }

    private static boolean isValidDuration(String x) {
        return x.matches("^P(?:\\d+Y)?(?:\\d+M)?(?:\\d+D)?(?:T(?:\\d+H)?(?:\\d+M)?(?:\\d+(?:\\.\\d+)?S)?)?$");
    }

    private static boolean isValidEmail(String x) {
        return x.matches("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$");
    }

    private boolean isValidEnum(String x) {
        return this.enum_.isEmpty() || this.enum_.contains(x);
    }

    private boolean isValidFormat(String x) {
        if (this.format == null || this.format == HttpPartFormat.NO_FORMAT) {
            return true;
        }
        if ("null".equals(x)) {
            return true;
        }
        try {
            return switch (this.format) {
                case HttpPartFormat.EMAIL -> HttpPartSchema.isValidEmail(x);
                case HttpPartFormat.IDN_EMAIL -> HttpPartSchema.isValidIdnEmail(x);
                case HttpPartFormat.HOSTNAME -> HttpPartSchema.isValidHostname(x);
                case HttpPartFormat.IDN_HOSTNAME -> HttpPartSchema.isValidIdnHostname(x);
                case HttpPartFormat.IPV4 -> HttpPartSchema.isValidIpv4(x);
                case HttpPartFormat.IPV6 -> HttpPartSchema.isValidIpv6(x);
                case HttpPartFormat.URI -> HttpPartSchema.isValidUri(x);
                case HttpPartFormat.URI_REFERENCE -> HttpPartSchema.isValidUriReference(x);
                case HttpPartFormat.IRI -> HttpPartSchema.isValidIri(x);
                case HttpPartFormat.IRI_REFERENCE -> HttpPartSchema.isValidIriReference(x);
                case HttpPartFormat.UUID -> HttpPartSchema.isValidUuid(x);
                case HttpPartFormat.URI_TEMPLATE -> HttpPartSchema.isValidUriTemplate(x);
                case HttpPartFormat.JSON_POINTER -> HttpPartSchema.isValidJsonPointer(x);
                case HttpPartFormat.RELATIVE_JSON_POINTER -> HttpPartSchema.isValidRelativeJsonPointer(x);
                case HttpPartFormat.REGEX -> HttpPartSchema.isValidRegex(x);
                case HttpPartFormat.DATE -> HttpPartSchema.isValidDate(x);
                case HttpPartFormat.DATE_TIME -> HttpPartSchema.isValidDateTime(x);
                case HttpPartFormat.DATE_TIME_ZONE -> HttpPartSchema.isValidDateTimeZone(x);
                case HttpPartFormat.TIME -> HttpPartSchema.isValidTime(x);
                case HttpPartFormat.DURATION -> HttpPartSchema.isValidDuration(x);
                case HttpPartFormat.BYTE, HttpPartFormat.BINARY, HttpPartFormat.BINARY_SPACED -> true;
                case HttpPartFormat.PASSWORD -> true;
                case HttpPartFormat.INT32, HttpPartFormat.INT64, HttpPartFormat.FLOAT, HttpPartFormat.DOUBLE -> true;
                case HttpPartFormat.UON -> true;
                default -> true;
            };
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isValidHostname(String x) {
        return x.matches("^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)*[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?$");
    }

    private static boolean isValidIdnEmail(String x) {
        return x.matches("^[^@\\s]+@[^@\\s]+\\.[^@\\s]+$");
    }

    private static boolean isValidIdnHostname(String x) {
        return x.matches("^[^\\s]+$");
    }

    private static boolean isValidIpv4(String x) {
        String[] parts = x.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                int val = Integer.parseInt(part);
                if (val >= 0 && val <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidIpv6(String x) {
        return x.matches("^([0-9a-fA-F]{0,4}:){7}[0-9a-fA-F]{0,4}$|^::([0-9a-fA-F]{0,4}:){0,6}[0-9a-fA-F]{0,4}$|^([0-9a-fA-F]{0,4}:){1,7}:$");
    }

    private static boolean isValidIri(String x) {
        return x.matches("^[a-zA-Z][a-zA-Z0-9+.-]*:.+");
    }

    private static boolean isValidIriReference(String x) {
        return x.length() > 0;
    }

    private static boolean isValidJsonPointer(String x) {
        return x.isEmpty() || x.matches("^(/[^/]*)*$");
    }

    private boolean isValidMaximum(Number x) {
        if (Utils.nn((Object)this.exclusiveMaximumValue)) {
            if (x instanceof Integer || x instanceof AtomicInteger) {
                return x.intValue() < this.exclusiveMaximumValue.intValue();
            }
            if (x instanceof Short || x instanceof Byte) {
                return x.shortValue() < this.exclusiveMaximumValue.shortValue();
            }
            if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
                return x.longValue() < this.exclusiveMaximumValue.longValue();
            }
            if (x instanceof Float) {
                return x.floatValue() < this.exclusiveMaximumValue.floatValue();
            }
            if (x instanceof Double || x instanceof BigDecimal) {
                return x.doubleValue() < this.exclusiveMaximumValue.doubleValue();
            }
        }
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.maximum == null || x.intValue() < this.maximum.intValue() || x.intValue() == this.maximum.intValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.maximum == null || x.shortValue() < this.maximum.shortValue() || x.intValue() == this.maximum.shortValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.maximum == null || x.longValue() < this.maximum.longValue() || (long)x.intValue() == this.maximum.longValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Float) {
            return this.maximum == null || x.floatValue() < this.maximum.floatValue() || x.floatValue() == this.maximum.floatValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.maximum == null || x.doubleValue() < this.maximum.doubleValue() || x.doubleValue() == this.maximum.doubleValue() && !this.exclusiveMaximum;
        }
        return true;
    }

    private boolean isValidMaxItems(Collection<?> x) {
        return this.maxItems == null || (long)x.size() <= this.maxItems;
    }

    private boolean isValidMaxItems(Object x) {
        return this.maxItems == null || (long)Array.getLength(x) <= this.maxItems;
    }

    private boolean isValidMaxLength(String x) {
        return this.maxLength == null || (long)x.length() <= this.maxLength;
    }

    private boolean isValidMaxProperties(Map<?, ?> x) {
        return this.maxProperties == null || (long)x.size() <= this.maxProperties;
    }

    private boolean isValidMinimum(Number x) {
        if (Utils.nn((Object)this.exclusiveMinimumValue)) {
            if (x instanceof Integer || x instanceof AtomicInteger) {
                return x.intValue() > this.exclusiveMinimumValue.intValue();
            }
            if (x instanceof Short || x instanceof Byte) {
                return x.shortValue() > this.exclusiveMinimumValue.shortValue();
            }
            if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
                return x.longValue() > this.exclusiveMinimumValue.longValue();
            }
            if (x instanceof Float) {
                return x.floatValue() > this.exclusiveMinimumValue.floatValue();
            }
            if (x instanceof Double || x instanceof BigDecimal) {
                return x.doubleValue() > this.exclusiveMinimumValue.doubleValue();
            }
        }
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.minimum == null || x.intValue() > this.minimum.intValue() || x.intValue() == this.minimum.intValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.minimum == null || x.shortValue() > this.minimum.shortValue() || x.intValue() == this.minimum.shortValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.minimum == null || x.longValue() > this.minimum.longValue() || (long)x.intValue() == this.minimum.longValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Float) {
            return this.minimum == null || x.floatValue() > this.minimum.floatValue() || x.floatValue() == this.minimum.floatValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.minimum == null || x.doubleValue() > this.minimum.doubleValue() || x.doubleValue() == this.minimum.doubleValue() && !this.exclusiveMinimum;
        }
        return true;
    }

    private boolean isValidMinItems(Collection<?> x) {
        return this.minItems == null || (long)x.size() >= this.minItems;
    }

    private boolean isValidMinItems(Object x) {
        return this.minItems == null || (long)Array.getLength(x) >= this.minItems;
    }

    private boolean isValidMinLength(String x) {
        return this.minLength == null || (long)x.length() >= this.minLength;
    }

    private boolean isValidMinProperties(Map<?, ?> x) {
        return this.minProperties == null || (long)x.size() >= this.minProperties;
    }

    private boolean isValidMultipleOf(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.multipleOf == null || x.intValue() % this.multipleOf.intValue() == 0;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.multipleOf == null || x.shortValue() % this.multipleOf.shortValue() == 0;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.multipleOf == null || x.longValue() % this.multipleOf.longValue() == 0L;
        }
        if (x instanceof Float) {
            return this.multipleOf == null || x.floatValue() % this.multipleOf.floatValue() == 0.0f;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.multipleOf == null || x.doubleValue() % this.multipleOf.doubleValue() == 0.0;
        }
        return true;
    }

    private boolean isValidPattern(String x) {
        return this.pattern == null || this.pattern.matcher(x).matches();
    }

    private static boolean isValidRegex(String x) {
        try {
            Pattern.compile(x);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isValidRelativeJsonPointer(String x) {
        return x.matches("^(0|[1-9][0-9]*)(#|(/[^/]*)*)$");
    }

    private boolean isValidRequired(Object x) {
        return Utils.nn((Object)x) || !this.required;
    }

    private static boolean isValidTime(String x) {
        return x.matches("^\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[+-]\\d{2}:\\d{2})?$");
    }

    private boolean isValidUniqueItems(Collection<?> x) {
        if (this.uniqueItems && !(x instanceof Set)) {
            HashSet s = new HashSet();
            for (Object o : x) {
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidUniqueItems(Object x) {
        if (this.uniqueItems) {
            HashSet<Object> s = new HashSet<Object>();
            for (int i = 0; i < Array.getLength(x); ++i) {
                Object o = Array.get(x, i);
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValidUri(String x) {
        try {
            new URI(x);
            return x.matches("^[a-zA-Z][a-zA-Z0-9+.-]*:.*");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isValidUriReference(String x) {
        try {
            new URI(x);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isValidUriTemplate(String x) {
        return x.matches("^[^\\s]*$");
    }

    private static boolean isValidUuid(String x) {
        return x.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    }

    private static boolean resolve(Boolean b) {
        return b == null ? false : b;
    }

    public static class Builder {
        String name;
        String default_;
        Set<Integer> codes;
        Set<String> enum_;
        Boolean allowEmptyValue;
        Boolean exclusiveMaximum;
        Boolean exclusiveMinimum;
        Boolean required;
        Boolean uniqueItems;
        Boolean skipIfEmpty;
        HttpPartCollectionFormat collectionFormat = HttpPartCollectionFormat.NO_COLLECTION_FORMAT;
        HttpPartDataType type = HttpPartDataType.NO_TYPE;
        HttpPartFormat format = HttpPartFormat.NO_FORMAT;
        Pattern pattern;
        Number maximum;
        Number minimum;
        Number multipleOf;
        Long maxLength;
        Long minLength;
        Long maxItems;
        Long minItems;
        Long maxProperties;
        Long minProperties;
        Map<String, Object> properties;
        Object items;
        Object additionalProperties;
        boolean noValidate;
        Class<? extends HttpPartParser> parser;
        Class<? extends HttpPartSerializer> serializer;
        String const_;
        String[] examples;
        Boolean deprecated;
        Number exclusiveMaximumValue;
        Number exclusiveMinimumValue;

        public Builder const_(String value) {
            this.const_ = value;
            return this;
        }

        public Builder default_(String value) {
            if (Utils.ne((CharSequence)value)) {
                this.default_ = value;
            }
            return this;
        }

        public Builder enum_(Set<String> value) {
            if (Utils.nn(value) && !value.isEmpty()) {
                this.enum_ = value;
            }
            return this;
        }

        public Builder enum_(String ... values) {
            return this.enum_(CollectionUtils.set((Object[])values));
        }

        public Builder additionalProperties(Builder value) {
            if (Utils.nn((Object)value)) {
                this.additionalProperties = value;
            }
            return this;
        }

        public Builder additionalProperties(HttpPartSchema value) {
            if (Utils.nn((Object)value)) {
                this.additionalProperties = value;
            }
            return this;
        }

        public Builder aev() {
            return this.allowEmptyValue(true);
        }

        public Builder aev(Boolean value) {
            return this.allowEmptyValue(value);
        }

        public Builder aev(String value) {
            return this.allowEmptyValue(value);
        }

        public Builder allowEmptyValue() {
            return this.allowEmptyValue(true);
        }

        public Builder allowEmptyValue(Boolean value) {
            this.allowEmptyValue = Builder.resolve(value, this.allowEmptyValue);
            return this;
        }

        public Builder allowEmptyValue(String value) {
            this.allowEmptyValue = Builder.resolve(value, this.allowEmptyValue);
            return this;
        }

        public Builder ap(Builder value) {
            return this.additionalProperties(value);
        }

        public Builder ap(HttpPartSchema value) {
            return this.additionalProperties(value);
        }

        public Builder apply(Annotation a) {
            if (a instanceof Content) {
                Content a2 = (Content)a;
                this.apply(a2);
            } else if (a instanceof Header) {
                Header a2 = (Header)a;
                this.apply(a2);
            } else if (a instanceof FormData) {
                FormData a2 = (FormData)a;
                this.apply(a2);
            } else if (a instanceof Query) {
                Query a3 = (Query)a;
                this.apply(a3);
            } else if (a instanceof Path) {
                Path a4 = (Path)a;
                this.apply(a4);
            } else if (a instanceof PathRemainder) {
                PathRemainder a5 = (PathRemainder)a;
                this.apply(a5);
            } else if (a instanceof Response) {
                Response a6 = (Response)a;
                this.apply(a6);
            } else if (a instanceof StatusCode) {
                StatusCode a7 = (StatusCode)a;
                this.apply(a7);
            } else if (a instanceof HasQuery) {
                HasQuery a8 = (HasQuery)a;
                this.apply(a8);
            } else if (a instanceof HasFormData) {
                HasFormData a9 = (HasFormData)a;
                this.apply(a9);
            } else if (a instanceof Schema) {
                Schema a10 = (Schema)a;
                this.apply(a10);
            } else if (Utils.cn(a.annotationType()).startsWith("jakarta.validation.constraints.")) {
                this.applyJakartaValidation(a);
            } else {
                throw ThrowableUtils.rex((String)"Builder.apply(@{0}) not defined", (Object[])new Object[]{Utils.cn((Object)a)});
            }
            return this;
        }

        public HttpPartSchema build() {
            return new HttpPartSchema(this);
        }

        public Builder cf(HttpPartCollectionFormat value) {
            return this.collectionFormat(value);
        }

        public Builder cf(String value) {
            return this.collectionFormat(value);
        }

        public Builder cfCsv() {
            return this.collectionFormat(HttpPartCollectionFormat.CSV);
        }

        public Builder cfMulti() {
            return this.collectionFormat(HttpPartCollectionFormat.MULTI);
        }

        public Builder cfNone() {
            return this.collectionFormat(HttpPartCollectionFormat.NO_COLLECTION_FORMAT);
        }

        public Builder cfPipes() {
            return this.collectionFormat(HttpPartCollectionFormat.PIPES);
        }

        public Builder cfSsv() {
            return this.collectionFormat(HttpPartCollectionFormat.SSV);
        }

        public Builder cfTsv() {
            return this.collectionFormat(HttpPartCollectionFormat.TSV);
        }

        public Builder cfUon() {
            return this.collectionFormat(HttpPartCollectionFormat.UONC);
        }

        public Builder code(int value) {
            if (value != 0) {
                if (this.codes == null) {
                    this.codes = new TreeSet<Integer>();
                }
                this.codes.add(value);
            }
            return this;
        }

        public Builder codes(int[] value) {
            if (Utils.nn((Object)value) && value.length != 0) {
                for (int v : value) {
                    this.code(v);
                }
            }
            return this;
        }

        public Builder collectionFormat(HttpPartCollectionFormat value) {
            this.collectionFormat = value;
            return this;
        }

        public Builder collectionFormat(String value) {
            try {
                if (Utils.ne((CharSequence)value)) {
                    this.collectionFormat = HttpPartCollectionFormat.fromString(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException(e, "Invalid value ''{0}'' passed in as collectionFormat value.  Valid values: {1}", new Object[]{value, HttpPartCollectionFormat.values()});
            }
            return this;
        }

        public Builder deprecated(Boolean value) {
            this.deprecated = Builder.resolve(value, this.deprecated);
            return this;
        }

        public Builder df(String value) {
            return this.default_(value);
        }

        public Builder e(Set<String> value) {
            return this.enum_(value);
        }

        public Builder e(String ... values) {
            return this.enum_(values);
        }

        public Builder emax() {
            return this.exclusiveMaximum();
        }

        public Builder emax(Boolean value) {
            return this.exclusiveMaximum(value);
        }

        public Builder emax(String value) {
            return this.exclusiveMaximum(value);
        }

        public Builder emin() {
            return this.exclusiveMinimum();
        }

        public Builder emin(Boolean value) {
            return this.exclusiveMinimum(value);
        }

        public Builder emin(String value) {
            return this.exclusiveMinimum(value);
        }

        public Builder examples(String ... value) {
            this.examples = value;
            return this;
        }

        public Builder exclusiveMaximum() {
            return this.exclusiveMaximum(true);
        }

        public Builder exclusiveMaximum(Boolean value) {
            this.exclusiveMaximum = Builder.resolve(value, this.exclusiveMaximum);
            return this;
        }

        public Builder exclusiveMaximum(String value) {
            this.exclusiveMaximum = Builder.resolve(value, this.exclusiveMaximum);
            return this;
        }

        public Builder exclusiveMaximumValue(Number value) {
            this.exclusiveMaximumValue = value;
            return this;
        }

        public Builder exclusiveMinimum() {
            return this.exclusiveMinimum(true);
        }

        public Builder exclusiveMinimum(Boolean value) {
            this.exclusiveMinimum = Builder.resolve(value, this.exclusiveMinimum);
            return this;
        }

        public Builder exclusiveMinimum(String value) {
            this.exclusiveMinimum = Builder.resolve(value, this.exclusiveMinimum);
            return this;
        }

        public Builder exclusiveMinimumValue(Number value) {
            this.exclusiveMinimumValue = value;
            return this;
        }

        public Builder f(HttpPartFormat value) {
            return this.format(value);
        }

        public Builder f(String value) {
            return this.format(value);
        }

        public Builder fBinary() {
            this.format = HttpPartFormat.BINARY;
            return this;
        }

        public Builder fBinarySpaced() {
            this.format = HttpPartFormat.BINARY_SPACED;
            return this;
        }

        public Builder fByte() {
            this.format = HttpPartFormat.BYTE;
            return this;
        }

        public Builder fDate() {
            this.format = HttpPartFormat.DATE;
            return this;
        }

        public Builder fDateTime() {
            this.format = HttpPartFormat.DATE_TIME;
            return this;
        }

        public Builder fDouble() {
            this.format = HttpPartFormat.DOUBLE;
            return this;
        }

        public Builder fFloat() {
            this.format = HttpPartFormat.FLOAT;
            return this;
        }

        public Builder fInt32() {
            this.format = HttpPartFormat.INT32;
            return this;
        }

        public Builder fInt64() {
            this.format = HttpPartFormat.INT64;
            return this;
        }

        public Builder fNone() {
            this.format = HttpPartFormat.NO_FORMAT;
            return this;
        }

        public Builder format(HttpPartFormat value) {
            this.format = value;
            return this;
        }

        public Builder format(String value) {
            try {
                if (Utils.ne((CharSequence)value)) {
                    this.format = HttpPartFormat.fromString(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException(e, "Invalid value ''{0}'' passed in as format value.  Valid values: {1}", new Object[]{value, HttpPartFormat.values()});
            }
            return this;
        }

        public Builder fPassword() {
            this.format = HttpPartFormat.PASSWORD;
            return this;
        }

        public Builder fUon() {
            this.format = HttpPartFormat.UON;
            return this;
        }

        public Builder i(Builder value) {
            return this.items(value);
        }

        public Builder i(HttpPartSchema value) {
            return this.items(value);
        }

        public Builder items(Builder value) {
            if (Utils.nn((Object)value)) {
                this.items = value;
            }
            return this;
        }

        public Builder items(HttpPartSchema value) {
            if (Utils.nn((Object)value)) {
                this.items = value;
            }
            return this;
        }

        public Builder max(Number value) {
            return this.maximum(value);
        }

        public Builder maxi(Long value) {
            return this.maxItems(value);
        }

        public Builder maxi(String value) {
            return this.maxItems(value);
        }

        public Builder maximum(Number value) {
            if (Utils.nn((Object)value)) {
                this.maximum = value;
            }
            return this;
        }

        public Builder maxItems(Long value) {
            this.maxItems = Builder.resolve(value, this.maxItems);
            return this;
        }

        public Builder maxItems(String value) {
            this.maxItems = Builder.resolve(value, this.maxItems);
            return this;
        }

        public Builder maxl(Long value) {
            return this.maxLength(value);
        }

        public Builder maxl(String value) {
            return this.maxLength(value);
        }

        public Builder maxLength(Long value) {
            this.maxLength = Builder.resolve(value, this.maxLength);
            return this;
        }

        public Builder maxLength(String value) {
            this.maxLength = Builder.resolve(value, this.maxLength);
            return this;
        }

        public Builder maxp(Long value) {
            return this.maxProperties(value);
        }

        public Builder maxp(String value) {
            return this.maxProperties(value);
        }

        public Builder maxProperties(Long value) {
            this.maxProperties = Builder.resolve(value, this.maxProperties);
            return this;
        }

        public Builder maxProperties(String value) {
            this.maxProperties = Builder.resolve(value, this.maxProperties);
            return this;
        }

        public Builder min(Number value) {
            return this.minimum(value);
        }

        public Builder mini(Long value) {
            return this.minItems(value);
        }

        public Builder mini(String value) {
            return this.minItems(value);
        }

        public Builder minimum(Number value) {
            if (Utils.nn((Object)value)) {
                this.minimum = value;
            }
            return this;
        }

        public Builder minItems(Long value) {
            this.minItems = Builder.resolve(value, this.minItems);
            return this;
        }

        public Builder minItems(String value) {
            this.minItems = Builder.resolve(value, this.minItems);
            return this;
        }

        public Builder minl(Long value) {
            return this.minLength(value);
        }

        public Builder minl(String value) {
            return this.minLength(value);
        }

        public Builder minLength(Long value) {
            this.minLength = Builder.resolve(value, this.minLength);
            return this;
        }

        public Builder minLength(String value) {
            this.minLength = Builder.resolve(value, this.minLength);
            return this;
        }

        public Builder minp(Long value) {
            return this.minProperties(value);
        }

        public Builder minp(String value) {
            return this.minProperties(value);
        }

        public Builder minProperties(Long value) {
            this.minProperties = Builder.resolve(value, this.minProperties);
            return this;
        }

        public Builder minProperties(String value) {
            this.minProperties = Builder.resolve(value, this.minProperties);
            return this;
        }

        public Builder mo(Number value) {
            return this.multipleOf(value);
        }

        public Builder multipleOf(Number value) {
            if (Utils.nn((Object)value)) {
                this.multipleOf = value;
            }
            return this;
        }

        public Builder n(String value) {
            return this.name(value);
        }

        public Builder name(String value) {
            if (Utils.ne((CharSequence)value)) {
                this.name = value;
            }
            return this;
        }

        public Builder noValidate() {
            return this.noValidate(true);
        }

        public Builder noValidate(Boolean value) {
            if (Utils.nn((Object)value)) {
                this.noValidate = value;
            }
            return this;
        }

        public Builder p(String value) {
            return this.pattern(value);
        }

        public Builder p(String key, Builder value) {
            return this.property(key, value);
        }

        public Builder p(String key, HttpPartSchema value) {
            return this.property(key, value);
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.parser = value;
            }
            return this;
        }

        public Builder pattern(String value) {
            try {
                if (Utils.ne((CharSequence)value)) {
                    this.pattern = Pattern.compile(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException(e, "Invalid value {0} passed in as pattern value.  Must be a valid regular expression.", value);
            }
            return this;
        }

        public Builder property(String key, Builder value) {
            if (Utils.nn((Object)key) && Utils.nn((Object)value)) {
                if (this.properties == null) {
                    this.properties = CollectionUtils.map();
                }
                this.properties.put(key, value);
            }
            return this;
        }

        public Builder property(String key, HttpPartSchema value) {
            if (Utils.nn((Object)key) && Utils.nn((Object)value)) {
                if (this.properties == null) {
                    this.properties = CollectionUtils.map();
                }
                this.properties.put(key, value);
            }
            return this;
        }

        public Builder r() {
            return this.required();
        }

        public Builder r(Boolean value) {
            return this.required(value);
        }

        public Builder r(String value) {
            return this.required(value);
        }

        public Builder required() {
            return this.required(true);
        }

        public Builder required(Boolean value) {
            this.required = Builder.resolve(value, this.required);
            return this;
        }

        public Builder required(String value) {
            this.required = Builder.resolve(value, this.required);
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.serializer = value;
            }
            return this;
        }

        public Builder sie() {
            return this.skipIfEmpty();
        }

        public Builder sie(Boolean value) {
            return this.skipIfEmpty(value);
        }

        public Builder sie(String value) {
            return this.skipIfEmpty(value);
        }

        public Builder skipIfEmpty() {
            return this.skipIfEmpty(true);
        }

        public Builder skipIfEmpty(Boolean value) {
            this.skipIfEmpty = Builder.resolve(value, this.skipIfEmpty);
            return this;
        }

        public Builder skipIfEmpty(String value) {
            this.skipIfEmpty = Builder.resolve(value, this.skipIfEmpty);
            return this;
        }

        public Builder t(HttpPartDataType value) {
            return this.type(value);
        }

        public Builder t(String value) {
            return this.type(value);
        }

        public Builder tArray() {
            this.type = HttpPartDataType.ARRAY;
            return this;
        }

        public Builder tBoolean() {
            this.type = HttpPartDataType.BOOLEAN;
            return this;
        }

        public Builder tFile() {
            this.type = HttpPartDataType.FILE;
            return this;
        }

        public Builder tInteger() {
            this.type = HttpPartDataType.INTEGER;
            return this;
        }

        public Builder tNone() {
            this.type = HttpPartDataType.NO_TYPE;
            return this;
        }

        public Builder tNumber() {
            this.type = HttpPartDataType.NUMBER;
            return this;
        }

        public Builder tObject() {
            this.type = HttpPartDataType.OBJECT;
            return this;
        }

        public Builder tString() {
            this.type = HttpPartDataType.STRING;
            return this;
        }

        public Builder type(HttpPartDataType value) {
            this.type = value;
            return this;
        }

        public Builder type(String value) {
            try {
                if (Utils.ne((CharSequence)value)) {
                    this.type = HttpPartDataType.fromString(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException(e, "Invalid value ''{0}'' passed in as type value.  Valid values: {1}", new Object[]{value, HttpPartDataType.values()});
            }
            return this;
        }

        public Builder ui() {
            return this.uniqueItems();
        }

        public Builder ui(Boolean value) {
            return this.uniqueItems(value);
        }

        public Builder ui(String value) {
            return this.uniqueItems(value);
        }

        public Builder uniqueItems() {
            return this.uniqueItems(true);
        }

        public Builder uniqueItems(Boolean value) {
            this.uniqueItems = Builder.resolve(value, this.uniqueItems);
            return this;
        }

        public Builder uniqueItems(String value) {
            this.uniqueItems = Builder.resolve(value, this.uniqueItems);
            return this;
        }

        private Builder additionalProperties(JsonMap value) {
            if (Utils.nn((Object)value) && !value.isEmpty()) {
                this.additionalProperties = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        private static Long firstNmo(Long ... l) {
            for (Long ll : l) {
                if (!Utils.nn((Object)ll) || ll == -1L) continue;
                return ll;
            }
            return null;
        }

        private static <T> T getAnnotationValue(Annotation a, String attributeName, Class<T> type) {
            try {
                Method m = a.annotationType().getDeclaredMethod(attributeName, new Class[0]);
                Object value = m.invoke((Object)a, new Object[0]);
                return type.isInstance(value) ? (T)type.cast(value) : null;
            }
            catch (Exception e) {
                return null;
            }
        }

        private static String joinnlOrNull(String[] ... s) {
            for (Object[] objectArray : s) {
                if (objectArray.length <= 0) continue;
                return StringUtils.joinnl((Object[])objectArray);
            }
            return null;
        }

        private Builder properties(JsonMap value) {
            if (Utils.nn((Object)value)) {
                value.forEach((k, v) -> this.property((String)k, HttpPartSchema.create().apply((JsonMap)v)));
            }
            return this;
        }

        private static Boolean resolve(Boolean newValue, Boolean oldValue) {
            return newValue == null ? oldValue : newValue;
        }

        private static Long resolve(Long newValue, Long oldValue) {
            return newValue == null || newValue == -1L ? oldValue : newValue;
        }

        private static Boolean resolve(String newValue, Boolean oldValue) {
            return StringUtils.isEmpty((String)newValue) ? oldValue : Utils.bool((Object)newValue);
        }

        private static Long resolve(String newValue, Long oldValue) {
            return StringUtils.isEmpty((String)newValue) ? oldValue : Long.parseLong(newValue);
        }

        private static Number toNumber(String ... s) {
            return HttpPartSchema.toNumber(s);
        }

        private static Set<String> toSet(String[] ... s) {
            return HttpPartSchema.toSet(s);
        }

        Builder apply(Class<? extends Annotation> c, Type t) {
            if (t instanceof Class) {
                Class c2 = (Class)t;
                CollectionUtils.rstream((List)AP.find(c, (ClassInfo)ReflectionUtils.info((Class)c2), new AnnotationTraversal[0])).forEach(x -> this.apply(x.inner()));
            } else if (Value.isType((Type)t)) {
                this.apply(c, Value.getParameterType((Type)t));
            }
            return this;
        }

        Builder apply(Class<? extends Annotation> c, Method m) {
            this.apply(c, m.getGenericReturnType());
            Annotation a = m.getAnnotation(c);
            if (Utils.nn((Object)a)) {
                return this.apply(a);
            }
            return this;
        }

        Builder apply(Class<? extends Annotation> c, ParameterInfo mpi) {
            this.apply(c, mpi.getParameterType().innerType());
            mpi.getAnnotations(c).forEach(x -> this.apply(x.inner()));
            return this;
        }

        Builder apply(Content a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.default_(a.def());
            return this;
        }

        Builder apply(FormData a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}));
            this.default_(a.def());
            this.parser(a.parser());
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(HasFormData a) {
            this.name(StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}));
            return this;
        }

        Builder apply(HasQuery a) {
            this.name(StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}));
            return this;
        }

        Builder apply(Header a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}));
            this.default_(a.def());
            this.parser(a.parser());
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(Items a) {
            this.default_(Builder.joinnlOrNull(a.default_(), a.df()));
            this.enum_(Builder.toSet(a.enum_(), a.e()));
            this.collectionFormat(StringUtils.firstNonEmpty((String[])new String[]{a.collectionFormat(), a.cf()}));
            this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
            this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
            this.format(StringUtils.firstNonEmpty((String[])new String[]{a.format(), a.f()}));
            this.items(a.items());
            this.maximum(Builder.toNumber(a.maximum(), a.max()));
            this.maxItems(Builder.firstNmo(a.maxItems(), a.maxi()));
            this.maxLength(Builder.firstNmo(a.maxLength(), a.maxl()));
            this.minimum(Builder.toNumber(a.minimum(), a.min()));
            this.minItems(Builder.firstNmo(a.minItems(), a.mini()));
            this.minLength(Builder.firstNmo(a.minLength(), a.minl()));
            this.multipleOf(Builder.toNumber(a.multipleOf(), a.mo()));
            this.pattern(StringUtils.firstNonEmpty((String[])new String[]{a.pattern(), a.p()}));
            this.type(StringUtils.firstNonEmpty((String[])new String[]{a.type(), a.t()}));
            this.uniqueItems(a.uniqueItems() || a.ui());
            return this;
        }

        Builder apply(JsonMap m) {
            if (Utils.nn((Object)m) && !m.isEmpty()) {
                this.default_(m.getString("default"));
                this.enum_(HttpPartSchema.toSet(m.getString("enum")));
                this.allowEmptyValue(m.getBoolean("allowEmptyValue"));
                this.exclusiveMaximum(m.getBoolean("exclusiveMaximum"));
                this.exclusiveMinimum(m.getBoolean("exclusiveMinimum"));
                this.required(m.getBoolean("required"));
                this.uniqueItems(m.getBoolean("uniqueItems"));
                this.collectionFormat(m.getString("collectionFormat"));
                this.type(m.getString("type"));
                this.format(m.getString("format"));
                this.pattern(m.getString("pattern"));
                this.maximum(m.get("maximum", Number.class));
                this.minimum(m.get("minimum", Number.class));
                this.multipleOf(m.get("multipleOf", Number.class));
                this.maxItems(m.get("maxItems", Long.class));
                this.maxLength(m.get("maxLength", Long.class));
                this.maxProperties(m.get("maxProperties", Long.class));
                this.minItems(m.get("minItems", Long.class));
                this.minLength(m.get("minLength", Long.class));
                this.minProperties(m.get("minProperties", Long.class));
                this.items(m.getMap("items"));
                this.properties(m.getMap("properties"));
                this.additionalProperties(m.getMap("additionalProperties"));
                this.apply(m.getMap("schema", null));
            }
            return this;
        }

        Builder apply(Path a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}));
            String def = a.def();
            if (Utils.neq((Object)"_NONE_", (Object)def)) {
                this.default_ = def;
            }
            this.parser(a.parser());
            this.serializer(a.serializer());
            if (StringUtils.startsWith((String)this.name, (char)'/')) {
                this.allowEmptyValue();
                this.required(false);
            } else if (this.required == null) {
                this.required(Utils.eq((Object)"_NONE_", (Object)def));
            }
            return this;
        }

        Builder apply(PathRemainder a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name("/*");
            this.default_(a.def());
            this.parser(a.parser());
            this.serializer(a.serializer());
            this.allowEmptyValue();
            this.required(false);
            return this;
        }

        Builder apply(Query a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}));
            this.default_(a.def());
            this.parser(a.parser());
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(Response a) {
            this.allowEmptyValue(true);
            this.apply(a.schema());
            this.parser(a.parser());
            this.required(false);
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(Schema a) {
            this.default_(Builder.joinnlOrNull(a.default_(), a.df()));
            this.enum_(Builder.toSet(a.enum_(), a.e()));
            this.additionalProperties(HttpPartSchema.toJsonMap(a.additionalProperties()));
            this.allowEmptyValue(a.allowEmptyValue() || a.aev());
            this.collectionFormat(StringUtils.firstNonEmpty((String[])new String[]{a.collectionFormat(), a.cf()}));
            String exMaxVal = a.exclusiveMaximumValue();
            if (Utils.ne((CharSequence)exMaxVal)) {
                this.exclusiveMaximumValue(Builder.toNumber(exMaxVal));
            } else if (a.exclusiveMaximum() || a.emax()) {
                this.exclusiveMaximum(true);
            }
            String exMinVal = a.exclusiveMinimumValue();
            if (Utils.ne((CharSequence)exMinVal)) {
                this.exclusiveMinimumValue(Builder.toNumber(exMinVal));
            } else if (a.exclusiveMinimum() || a.emin()) {
                this.exclusiveMinimum(true);
            }
            this.format(StringUtils.firstNonEmpty((String[])new String[]{a.format(), a.f()}));
            this.items(a.items());
            this.maximum(Builder.toNumber(a.maximum(), a.max()));
            this.maxItems(Builder.firstNmo(a.maxItems(), a.maxi()));
            this.maxLength(Builder.firstNmo(a.maxLength(), a.maxl()));
            this.maxProperties(Builder.firstNmo(a.maxProperties(), a.maxp()));
            this.minimum(Builder.toNumber(a.minimum(), a.min()));
            this.minItems(Builder.firstNmo(a.minItems(), a.mini()));
            this.minLength(Builder.firstNmo(a.minLength(), a.minl()));
            this.minProperties(Builder.firstNmo(a.minProperties(), a.minp()));
            this.multipleOf(Builder.toNumber(a.multipleOf(), a.mo()));
            this.pattern(StringUtils.firstNonEmpty((String[])new String[]{a.pattern(), a.p()}));
            this.properties(HttpPartSchema.toJsonMap(a.properties()));
            this.required(a.required() || a.r());
            this.skipIfEmpty(a.skipIfEmpty() || a.sie());
            this.type(StringUtils.firstNonEmpty((String[])new String[]{a.type(), a.t()}));
            this.uniqueItems(a.uniqueItems() || a.ui());
            this.const_(Builder.joinnlOrNull(new String[][]{a.const_()}));
            this.examples(a.examples());
            this.deprecated(a.deprecatedProperty());
            return this;
        }

        Builder apply(StatusCode a) {
            this.codes(a.value());
            return this;
        }

        Builder apply(SubItems a) {
            this.default_(Builder.joinnlOrNull(a.default_(), a.df()));
            this.enum_(Builder.toSet(a.enum_(), a.e()));
            this.collectionFormat(StringUtils.firstNonEmpty((String[])new String[]{a.collectionFormat(), a.cf()}));
            this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
            this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
            this.format(StringUtils.firstNonEmpty((String[])new String[]{a.format(), a.f()}));
            this.items(HttpPartSchema.toJsonMap(a.items()));
            this.maximum(Builder.toNumber(a.maximum(), a.max()));
            this.maxItems(Builder.firstNmo(a.maxItems(), a.maxi()));
            this.maxLength(Builder.firstNmo(a.maxLength(), a.maxl()));
            this.minimum(Builder.toNumber(a.minimum(), a.min()));
            this.minItems(Builder.firstNmo(a.minItems(), a.mini()));
            this.minLength(Builder.firstNmo(a.minLength(), a.minl()));
            this.multipleOf(Builder.toNumber(a.multipleOf(), a.mo()));
            this.pattern(StringUtils.firstNonEmpty((String[])new String[]{a.pattern(), a.p()}));
            this.type(StringUtils.firstNonEmpty((String[])new String[]{a.type(), a.t()}));
            this.uniqueItems(a.uniqueItems() || a.ui());
            return this;
        }

        Builder applyAll(Class<? extends Annotation> c, Type t) {
            return this.apply(Schema.class, t).apply(c, t);
        }

        Builder applyAll(Class<? extends Annotation> c, Method m) {
            return this.apply(Schema.class, m).apply(c, m);
        }

        Builder applyAll(Class<? extends Annotation> c, ParameterInfo mpi) {
            return this.apply(Schema.class, mpi).apply(c, mpi);
        }

        Builder applyJakartaValidation(Annotation a) {
            String simpleName = Utils.cns(a.annotationType());
            try {
                switch (simpleName) {
                    case "NotNull": {
                        this.required(true);
                        break;
                    }
                    case "Size": {
                        Integer min = Builder.getAnnotationValue(a, "min", Integer.class);
                        Integer max = Builder.getAnnotationValue(a, "max", Integer.class);
                        if (Utils.nn((Object)min) && min > 0) {
                            this.minLength(min.longValue());
                            this.minItems(min.longValue());
                        }
                        if (!Utils.nn((Object)max) || max >= Integer.MAX_VALUE) break;
                        this.maxLength(max.longValue());
                        this.maxItems(max.longValue());
                        break;
                    }
                    case "Min": {
                        Long minValue = Builder.getAnnotationValue(a, "value", Long.class);
                        if (!Utils.nn((Object)minValue)) break;
                        this.minimum(minValue);
                        break;
                    }
                    case "Max": {
                        Long maxValue = Builder.getAnnotationValue(a, "value", Long.class);
                        if (!Utils.nn((Object)maxValue)) break;
                        this.maximum(maxValue);
                        break;
                    }
                    case "Pattern": {
                        String regexp = Builder.getAnnotationValue(a, "regexp", String.class);
                        if (!Utils.nn((Object)regexp)) break;
                        this.pattern(regexp);
                        break;
                    }
                    case "Email": {
                        this.format("email");
                        break;
                    }
                    case "Positive": {
                        this.minimum(0);
                        this.exclusiveMinimum(true);
                        break;
                    }
                    case "PositiveOrZero": {
                        this.minimum(0);
                        break;
                    }
                    case "Negative": {
                        this.maximum(0);
                        this.exclusiveMaximum(true);
                        break;
                    }
                    case "NegativeOrZero": {
                        this.maximum(0);
                        break;
                    }
                    case "NotEmpty": {
                        this.required(true);
                        this.minLength(1L);
                        this.minItems(1L);
                        break;
                    }
                    case "NotBlank": {
                        this.required(true);
                        this.minLength(1L);
                        this.pattern(".*\\S.*");
                        break;
                    }
                    case "DecimalMin": {
                        String minVal = Builder.getAnnotationValue(a, "value", String.class);
                        Boolean minInclusive = Builder.getAnnotationValue(a, "inclusive", Boolean.class);
                        if (!Utils.nn((Object)minVal)) break;
                        this.minimum(Builder.toNumber(minVal));
                        if (!Boolean.FALSE.equals(minInclusive)) break;
                        this.exclusiveMinimum(true);
                        break;
                    }
                    case "DecimalMax": {
                        String maxVal = Builder.getAnnotationValue(a, "value", String.class);
                        Boolean maxInclusive = Builder.getAnnotationValue(a, "inclusive", Boolean.class);
                        if (!Utils.nn((Object)maxVal)) break;
                        this.maximum(Builder.toNumber(maxVal));
                        if (!Boolean.FALSE.equals(maxInclusive)) break;
                        this.exclusiveMaximum(true);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        Builder items(Items value) {
            if (!ItemsAnnotation.empty(value)) {
                this.items = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        Builder items(JsonMap value) {
            if (Utils.nn((Object)value) && !value.isEmpty()) {
                this.items = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        Builder items(SubItems value) {
            if (!SubItemsAnnotation.empty(value)) {
                this.items = HttpPartSchema.create().apply(value);
            }
            return this;
        }
    }
}

