/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class BeanDictionaryMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    protected BeanDictionaryMap() {
    }

    private void assertValidParameter(Object o) {
        if (Utils.nn((Object)o)) {
            if (o instanceof Class) {
                return;
            }
            if (Utils.isArray((Object)o)) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    this.assertValidParameter(Array.get(o, i));
                }
                return;
            }
        }
        throw ThrowableUtils.bex((String)"Invalid object type passed to BeanDictionaryMap: ''{0}''.  Only objects of type Class or Object[] containing Class or Object[] objects can be used.", (Object[])new Object[]{Utils.cn((Object)o)});
    }

    protected BeanDictionaryMap append(String typeName, Class<?> c) {
        this.put(typeName, c);
        return this;
    }

    protected BeanDictionaryMap append(String typeName, Class<? extends Collection> collectionClass, Object entryClass) {
        this.assertValidParameter(entryClass);
        this.put(typeName, CollectionUtils.a((Object[])new Object[]{collectionClass, entryClass}));
        return this;
    }

    protected BeanDictionaryMap append(String typeName, Class<? extends Map> mapClass, Object keyClass, Object valueClass) {
        this.assertValidParameter(keyClass);
        this.assertValidParameter(valueClass);
        this.put(typeName, CollectionUtils.a((Object[])new Object[]{mapClass, keyClass, valueClass}));
        return this;
    }
}

