/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.ChannelManager;
import org.apache.jena.dboe.sys.FileLib;

public class BufferChannelFile
implements BufferChannel {
    private String filename;
    private FileChannel file;

    public static BufferChannel create(Path path) {
        return BufferChannelFile.create(path.toString());
    }

    public static BufferChannelFile create(String filename) {
        return BufferChannelFile.create(filename, "rw");
    }

    public static BufferChannelFile create(String filename, String mode) {
        FileChannel base = ChannelManager.acquire(filename, mode);
        return new BufferChannelFile(filename, base);
    }

    public static BufferChannelFile createUnmanaged(String filename, String mode) {
        FileChannel channel = FileLib.openUnmanaged(filename, mode);
        return new BufferChannelFile(filename, channel);
    }

    private BufferChannelFile(String filename, FileChannel channel) {
        this.filename = filename;
        this.file = channel;
    }

    @Override
    public BufferChannel duplicate() {
        return new BufferChannelFile(this.filename, this.file);
    }

    @Override
    public long position() {
        try {
            return this.file.position();
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1L;
        }
    }

    @Override
    public void position(long pos) {
        try {
            this.file.position(pos);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    @Override
    public void truncate(long length) {
        try {
            if (length < this.file.position()) {
                this.file.position(length);
            }
            this.file.truncate(length);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
        }
    }

    @Override
    public int read(ByteBuffer buffer) {
        try {
            return this.file.read(buffer);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public int read(ByteBuffer buffer, long loc) {
        try {
            return this.file.read(buffer, loc);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public int write(ByteBuffer buffer) {
        try {
            return this.file.write(buffer);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public int write(ByteBuffer buffer, long loc) {
        try {
            return this.file.write(buffer, loc);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return -1;
        }
    }

    @Override
    public long size() {
        return FileLib.size(this.file);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void sync() {
        FileLib.sync(this.file);
    }

    public void close() {
        FileLib.close(this.file);
    }

    @Override
    public String getLabel() {
        return this.filename;
    }

    public String toString() {
        return this.filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

