/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Properties;
import org.apache.jackrabbit.core.security.user.action.AuthorizableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserManagerConfig {
    private static final Logger log = LoggerFactory.getLogger(UserManagerConfig.class);
    private final Properties config;
    private final String adminId;
    private AuthorizableAction[] actions;

    UserManagerConfig(Properties config, String adminId, AuthorizableAction[] actions) {
        this.config = config;
        this.adminId = adminId;
        this.actions = actions == null ? new AuthorizableAction[]{} : actions;
    }

    public <T> T getConfigValue(String key, T defaultValue) {
        if (this.config != null && this.config.containsKey(key)) {
            return this.convert(this.config.get(key), defaultValue);
        }
        return defaultValue;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public AuthorizableAction[] getAuthorizableActions() {
        return this.actions;
    }

    public void setAuthorizableActions(AuthorizableAction[] actions) {
        if (actions != null) {
            this.actions = actions;
        }
    }

    private <T> T convert(Object v, T defaultValue) {
        Object value;
        block8: {
            if (v == null) {
                return null;
            }
            String str = v.toString();
            Class targetClass = defaultValue == null ? String.class : defaultValue.getClass();
            try {
                if (targetClass == String.class) {
                    value = str;
                    break block8;
                }
                if (targetClass == Integer.class) {
                    value = Integer.valueOf(str);
                    break block8;
                }
                if (targetClass == Long.class) {
                    value = Long.valueOf(str);
                    break block8;
                }
                if (targetClass == Double.class) {
                    value = Double.valueOf(str);
                    break block8;
                }
                if (targetClass == Boolean.class) {
                    value = Boolean.valueOf(str);
                    break block8;
                }
                log.warn("Unsupported target type {} for value {}", (Object)targetClass.getName(), v);
                throw new IllegalArgumentException("Cannot convert config entry " + String.valueOf(v) + " to " + targetClass.getName());
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value {}; cannot be parsed into {}", v, (Object)targetClass.getName());
                value = defaultValue;
            }
        }
        return (T)value;
    }
}

