/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.sink.util.PipeTabletEventSorter;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTabletRawReq
extends TPipeTransferReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletRawReq.class);
    private transient Tablet tablet;
    private transient boolean isAligned;

    public Tablet getTablet() {
        return this.tablet;
    }

    public boolean getIsAligned() {
        return this.isAligned;
    }

    public InsertTabletStatement constructStatement() {
        new PipeTabletEventSorter(this.tablet).deduplicateAndSortTimestampsIfNecessary();
        try {
            if (PipeRawTabletInsertionEvent.isTabletEmpty(this.tablet)) {
                return new InsertTabletStatement();
            }
            return new InsertTabletStatement(this.tablet, this.isAligned);
        }
        catch (MetadataException e) {
            LOGGER.warn("Generate Statement from tablet {} error.", (Object)this.tablet, (Object)e);
            return null;
        }
    }

    public static PipeTransferTabletRawReq toTPipeTransferRawReq(Tablet tablet, boolean isAligned) {
        PipeTransferTabletRawReq tabletReq = new PipeTransferTabletRawReq();
        tabletReq.tablet = tablet;
        tabletReq.isAligned = isAligned;
        return tabletReq;
    }

    public static PipeTransferTabletRawReq toTPipeTransferReq(Tablet tablet, boolean isAligned) throws IOException {
        PipeTransferTabletRawReq tabletReq = new PipeTransferTabletRawReq();
        tabletReq.tablet = tablet;
        tabletReq.isAligned = isAligned;
        tabletReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        tabletReq.type = PipeRequestType.TRANSFER_TABLET_RAW.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            tablet.serialize(outputStream);
            ReadWriteIOUtils.write((Boolean)isAligned, (OutputStream)outputStream);
            tabletReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return tabletReq;
    }

    public static PipeTransferTabletRawReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletRawReq tabletReq = new PipeTransferTabletRawReq();
        tabletReq.tablet = Tablet.deserialize((ByteBuffer)transferReq.body);
        tabletReq.isAligned = ReadWriteIOUtils.readBool((ByteBuffer)transferReq.body);
        tabletReq.version = transferReq.version;
        tabletReq.type = transferReq.type;
        return tabletReq;
    }

    public static byte[] toTPipeTransferBytes(Tablet tablet, boolean isAligned) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBSinkRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_RAW.getType(), (OutputStream)outputStream);
                tablet.serialize(outputStream);
                ReadWriteIOUtils.write((Boolean)isAligned, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletRawReq that = (PipeTransferTabletRawReq)((Object)obj);
        return Objects.equals(this.tablet, that.tablet) && this.isAligned == that.isAligned && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.tablet, this.isAligned, this.version, this.type, this.body);
    }
}

