/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function.support;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class HandlerFunctionAdapter
implements HandlerAdapter,
Ordered {
    private static final Log logger = LogFactory.getLog(HandlerFunctionAdapter.class);
    private int order = Integer.MAX_VALUE;
    @Nullable
    private Long asyncRequestTimeout;

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setAsyncRequestTimeout(long timeout) {
        this.asyncRequestTimeout = timeout;
    }

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerFunction;
    }

    @Override
    @Nullable
    public ModelAndView handle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        ServerResponse serverResponse;
        WebAsyncManager asyncManager = this.getWebAsyncManager(servletRequest, servletResponse);
        servletResponse = HandlerFunctionAdapter.getWrappedResponse(asyncManager);
        ServerRequest serverRequest = this.getServerRequest(servletRequest);
        if (asyncManager.hasConcurrentResult()) {
            serverResponse = this.handleAsync(asyncManager);
        } else {
            HandlerFunction handlerFunction = (HandlerFunction)handler;
            serverResponse = handlerFunction.handle(serverRequest);
        }
        if (serverResponse != null) {
            return serverResponse.writeTo(servletRequest, servletResponse, new ServerRequestContext(serverRequest));
        }
        return null;
    }

    private WebAsyncManager getWebAsyncManager(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        AsyncWebRequest asyncWebRequest = WebAsyncUtils.createAsyncWebRequest(servletRequest, servletResponse);
        asyncWebRequest.setTimeout(this.asyncRequestTimeout);
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)servletRequest);
        asyncManager.setAsyncWebRequest(asyncWebRequest);
        return asyncManager;
    }

    private static HttpServletResponse getWrappedResponse(WebAsyncManager asyncManager) {
        AsyncWebRequest asyncRequest = asyncManager.getAsyncWebRequest();
        Assert.notNull((Object)asyncRequest, "No AsyncWebRequest");
        HttpServletResponse servletResponse = asyncRequest.getNativeResponse(HttpServletResponse.class);
        Assert.notNull((Object)servletResponse, "No HttpServletResponse");
        return servletResponse;
    }

    private ServerRequest getServerRequest(HttpServletRequest servletRequest) {
        ServerRequest serverRequest = (ServerRequest)servletRequest.getAttribute(RouterFunctions.REQUEST_ATTRIBUTE);
        Assert.state(serverRequest != null, () -> "Required attribute '" + RouterFunctions.REQUEST_ATTRIBUTE + "' is missing");
        return serverRequest;
    }

    @Nullable
    private ServerResponse handleAsync(WebAsyncManager asyncManager) throws Exception {
        Object result = asyncManager.getConcurrentResult();
        asyncManager.clearConcurrentResult();
        LogFormatUtils.traceDebug(logger, traceOn -> {
            String formatted = LogFormatUtils.formatValue(result, traceOn == false);
            return "Resume with async result [" + formatted + "]";
        });
        if (result instanceof ServerResponse) {
            ServerResponse response = (ServerResponse)result;
            return response;
        }
        if (result instanceof Exception) {
            Exception exception = (Exception)result;
            throw exception;
        }
        if (result instanceof Throwable) {
            Throwable throwable = (Throwable)result;
            throw new ServletException("Async processing failed", throwable);
        }
        if (result == null) {
            return null;
        }
        throw new IllegalArgumentException("Unknown result from WebAsyncManager: [" + String.valueOf(result) + "]");
    }

    @Override
    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    private static class ServerRequestContext
    implements ServerResponse.Context {
        private final ServerRequest serverRequest;

        public ServerRequestContext(ServerRequest serverRequest) {
            this.serverRequest = serverRequest;
        }

        @Override
        public List<HttpMessageConverter<?>> messageConverters() {
            return this.serverRequest.messageConverters();
        }
    }
}

