/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.feature.AvailableFeatures;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.FileSystemOutputHandler;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.Language;
import org.grails.forge.options.Options;
import org.grails.forge.options.TestFramework;
import org.yaml.snakeyaml.Yaml;

@Introspected
public class CodeGenConfig {
    private ApplicationType applicationType;
    private String defaultPackage;
    private TestFramework testFramework;
    private Language sourceLanguage;
    private List<String> features;
    private boolean legacy;

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public TestFramework getTestFramework() {
        return this.testFramework;
    }

    public void setTestFramework(TestFramework testFramework) {
        this.testFramework = testFramework;
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public static CodeGenConfig load(BeanContext beanContext, ConsoleOutput consoleOutput) {
        try {
            return CodeGenConfig.load(beanContext, FileSystemOutputHandler.getDefaultBaseDirectory(), consoleOutput);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CodeGenConfig load(BeanContext beanContext, File directory, ConsoleOutput consoleOutput) {
        File grailsCli = new File(directory, "grails-forge-cli.yml");
        if (!grailsCli.exists()) {
            grailsCli = new File(directory, "grails-cli.yml");
        }
        if (!grailsCli.exists()) return null;
        try (InputStream inputStream = Files.newInputStream(grailsCli.toPath(), new OpenOption[0]);){
            Yaml yaml = new Yaml();
            LinkedHashMap map = new LinkedHashMap();
            Iterable<Object> objects = yaml.loadAll(inputStream);
            Iterator<Object> i2 = objects.iterator();
            if (i2.hasNext()) {
                while (i2.hasNext()) {
                    Object object = i2.next();
                    if (!(object instanceof Map)) continue;
                    map.putAll((Map)object);
                }
            }
            BeanIntrospection<CodeGenConfig> introspection = BeanIntrospection.getIntrospection(CodeGenConfig.class);
            CodeGenConfig codeGenConfig = introspection.instantiate();
            introspection.getBeanProperties().forEach(bp -> {
                Object value = map.get(bp.getName());
                if (value != null) {
                    bp.convertAndSet(codeGenConfig, value);
                }
            });
            if (map.containsKey("profile")) {
                codeGenConfig.legacy = true;
                String profile2 = map.get("profile").toString();
                if (profile2.equals("web")) {
                    codeGenConfig.setApplicationType(ApplicationType.WEB);
                } else if (profile2.equals("rest-api")) {
                    codeGenConfig.setApplicationType(ApplicationType.REST_API);
                } else if (profile2.equals("plugin")) {
                    codeGenConfig.setApplicationType(ApplicationType.PLUGIN);
                } else {
                    if (!profile2.equals("web-plugin")) {
                        CodeGenConfig codeGenConfig2 = null;
                        return codeGenConfig2;
                    }
                    codeGenConfig.setApplicationType(ApplicationType.WEB_PLUGIN);
                }
                AvailableFeatures availableFeatures = beanContext.getBean(AvailableFeatures.class, Qualifiers.byName(codeGenConfig.getApplicationType().getName()));
                codeGenConfig.setFeatures(availableFeatures.getAllFeatures().filter(f -> f instanceof DefaultFeature).map(DefaultFeature.class::cast).filter(f -> f.shouldApply(codeGenConfig.getApplicationType(), new Options(codeGenConfig.getTestFramework(), JdkVersion.DEFAULT_OPTION), new HashSet<Feature>())).map(Feature::getName).collect(Collectors.toList()));
                consoleOutput.warning("This project is using Grails Forge CLI v2 but is still using the v1 grails-forge-cli.yml format");
                consoleOutput.warning("To replace the configuration with the new format, run `grails update-cli-config`");
            }
            CodeGenConfig codeGenConfig3 = codeGenConfig;
            return codeGenConfig3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

