/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import java.util.Optional;
import org.grails.forge.build.dependencies.Phase;
import org.grails.forge.build.dependencies.Scope;
import org.grails.forge.options.Language;
import org.grails.forge.options.TestFramework;

public enum GradleConfiguration implements Ordered
{
    CLASSPATH("classpath", -2),
    PROFILE("profile", -1),
    BUILD("implementation", 0),
    ANNOTATION_PROCESSOR("annotationProcessor", 1),
    KAPT("kapt", 2),
    API("api", 3),
    IMPLEMENTATION("implementation", 4),
    COMPILE_ONLY("compileOnly", 5),
    CONSOLE("console", 6),
    DEVELOPMENT_ONLY("developmentOnly", 2),
    TEST_AND_DEVELOPMENT_ONLY("testAndDevelopmentOnly", 2),
    RUNTIME_ONLY("runtimeOnly", 7),
    TEST_ANNOTATION_PROCESSOR("testAnnotationProcessor", 8),
    TEST_KAPT("kaptTest", 9),
    INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES("integrationTestImplementation testFixtures", 10),
    TEST_IMPLEMENTATION("testImplementation", 11),
    TEST_COMPILE_ONLY("testCompileOnly", 12),
    TEST_RUNTIME_ONLY("testRuntimeOnly", 13),
    OPENREWRITE("rewrite", 14);

    private final String configurationName;
    private final int order;

    private GradleConfiguration(String configurationName, int order) {
        this.configurationName = configurationName;
        this.order = order;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String toString() {
        return this.configurationName;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @NonNull
    public static Optional<GradleConfiguration> of(@NonNull Scope scope, @NonNull Language language, @NonNull TestFramework testFramework) {
        switch (scope.getSource()) {
            case BUILD_SRC: {
                if (!scope.getPhases().contains((Object)Phase.BUILD)) break;
                return Optional.of(BUILD);
            }
            case BUILDSCRIPT: {
                if (!scope.getPhases().contains((Object)Phase.BUILD)) break;
                return Optional.of(CLASSPATH);
            }
            case MAIN: {
                if (scope.getPhases().contains((Object)Phase.ANNOTATION_PROCESSING)) {
                    return Optional.of(COMPILE_ONLY);
                }
                if (scope.getPhases().contains((Object)Phase.CONSOLE)) {
                    return Optional.of(CONSOLE);
                }
                if (scope.getPhases().contains((Object)Phase.RUNTIME)) {
                    if (scope.getPhases().contains((Object)Phase.COMPILATION)) {
                        return Optional.of(IMPLEMENTATION);
                    }
                    return Optional.of(RUNTIME_ONLY);
                }
                if (scope.getPhases().contains((Object)Phase.DEVELOPMENT_ONLY)) {
                    if (scope.getPhases().contains((Object)Phase.TEST_RUNTIME)) {
                        return Optional.of(TEST_AND_DEVELOPMENT_ONLY);
                    }
                    return Optional.of(DEVELOPMENT_ONLY);
                }
                if (scope.getPhases().contains((Object)Phase.COMPILATION)) {
                    return Optional.of(COMPILE_ONLY);
                }
                if (scope.getPhases().contains((Object)Phase.OPENREWRITE)) {
                    return Optional.of(OPENREWRITE);
                }
                if (scope.getPhases().contains((Object)Phase.PROFILE)) {
                    return Optional.of(PROFILE);
                }
                if (!scope.getPhases().contains((Object)Phase.INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES)) break;
                return Optional.of(INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES);
            }
            case TEST: {
                if (scope.getPhases().contains((Object)Phase.ANNOTATION_PROCESSING)) {
                    return Optional.of(TEST_COMPILE_ONLY);
                }
                if (scope.getPhases().contains((Object)Phase.RUNTIME)) {
                    if (scope.getPhases().contains((Object)Phase.COMPILATION)) {
                        return Optional.of(TEST_IMPLEMENTATION);
                    }
                    return Optional.of(TEST_RUNTIME_ONLY);
                }
                if (!scope.getPhases().contains((Object)Phase.COMPILATION)) break;
                return Optional.of(TEST_COMPILE_ONLY);
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

