/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.core.GrailsApplication;
import grails.util.GrailsStringUtils;
import groovy.lang.GroovyObject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsWebUtil {
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final String CHARSET_ATTRIBUTE = ";charset=";
    private static final Pattern CHARSET_IN_CONTENT_TYPE_REGEXP = Pattern.compile(";\\s*charset\\s*=", 2);

    private GrailsWebUtil() {
    }

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        GrailsApplication grailsApplication = (GrailsApplication)servletContext.getAttribute("org.codehaus.groovy.grails.APPLICATION");
        if (grailsApplication != null) {
            return grailsApplication;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(servletContext);
        if (context == null || !context.containsBean("grailsApplication")) {
            return null;
        }
        return context.getBean("grailsApplication", GrailsApplication.class);
    }

    public static GrailsApplication currentApplication() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof GrailsWebRequest)) {
            return null;
        }
        return ((GrailsWebRequest)requestAttributes).getAttributes().getGrailsApplication();
    }

    public static Map currentConfiguration() {
        GrailsApplication application2 = GrailsWebUtil.currentApplication();
        return application2 == null ? Collections.emptyMap() : application2.getConfig();
    }

    public static String getUriFromRequest(HttpServletRequest request) {
        Object includeUri = request.getAttribute("jakarta.servlet.include.request_uri");
        return includeUri == null ? request.getRequestURI() : (String)includeUri;
    }

    public static GroovyObject getControllerFromRequest(HttpServletRequest request) {
        return (GroovyObject)request.getAttribute("org.grails.CONTROLLER");
    }

    public static String getContentType(String name, String encoding) {
        if (name.indexOf(59) > -1 && CHARSET_IN_CONTENT_TYPE_REGEXP.matcher(name).find()) {
            return name;
        }
        if (GrailsStringUtils.isBlank(encoding)) {
            encoding = DEFAULT_ENCODING;
        }
        return name + CHARSET_ATTRIBUTE + encoding;
    }
}

