/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processor.tdml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.core.compiler.Compiler;
import org.apache.daffodil.core.compiler.Compiler$;
import org.apache.daffodil.core.compiler.ProcessorFactory;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.processor.tdml.DaffodilTDMLDFDLProcessor;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.tdml.processor.AbstractTDMLDFDLProcessorFactory;
import org.apache.daffodil.tdml.processor.TDMLDFDLProcessor;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.util.Either;

public final class TDMLDFDLProcessorFactory
implements AbstractTDMLDFDLProcessorFactory {
    private Compiler compiler;
    private boolean checkAllTopLevel;
    private final boolean validateDFDLSchemasArg;

    private TDMLDFDLProcessorFactory(Compiler compiler, boolean checkAllTopLevel, boolean validateDFDLSchemasArg) {
        this.compiler = compiler;
        this.checkAllTopLevel = checkAllTopLevel;
        this.validateDFDLSchemasArg = validateDFDLSchemasArg;
    }

    private Compiler compiler() {
        return this.compiler;
    }

    private void compiler_$eq(Compiler x$0) {
        this.compiler = x$0;
    }

    private boolean checkAllTopLevel() {
        return this.checkAllTopLevel;
    }

    private void checkAllTopLevel_$eq(boolean x$0) {
        this.checkAllTopLevel = x$0;
    }

    public boolean validateDFDLSchemas() {
        return this.validateDFDLSchemasArg;
    }

    public String implementationName() {
        return "daffodil";
    }

    public TDMLDFDLProcessorFactory() {
        this(Compiler$.MODULE$.apply(true), false, true);
    }

    private TDMLDFDLProcessorFactory copy(Compiler compiler, boolean checkAllTopLevel, boolean validateDFDLSchemas) {
        return new TDMLDFDLProcessorFactory(compiler, checkAllTopLevel, validateDFDLSchemas);
    }

    private Compiler copy$default$1() {
        return this.compiler();
    }

    private boolean copy$default$2() {
        return this.checkAllTopLevel();
    }

    private boolean copy$default$3() {
        return this.validateDFDLSchemas();
    }

    public TDMLDFDLProcessorFactory withValidateDFDLSchemas(boolean bool) {
        return this.copy(this.compiler().withValidateDFDLSchemas(bool), this.copy$default$2(), this.copy$default$3());
    }

    public TDMLDFDLProcessorFactory withCheckAllTopLevel(boolean checkAllTopLevel) {
        return this.copy(this.compiler().withCheckAllTopLevel(checkAllTopLevel), this.copy$default$2(), this.copy$default$3());
    }

    public TDMLDFDLProcessorFactory withTunables(Map<String, String> tunables) {
        return this.copy(this.compiler().withTunables(tunables), this.copy$default$2(), this.copy$default$3());
    }

    private Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> generateProcessor(DFDL.ProcessorFactory pf, DaffodilSchemaSource schemaSource) {
        org.apache.daffodil.api.DataProcessor p = pf.onPath("/");
        List diags = p.getDiagnostics();
        if (p.isError()) {
            return package$.MODULE$.Left().apply((Object)diags);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WritableByteChannel output = Channels.newChannel(os);
        p.save(output);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        DataProcessor dp = this.compiler().reload((InputStream)is);
        DaffodilTDMLDFDLProcessor processor = new DaffodilTDMLDFDLProcessor((org.apache.daffodil.api.DataProcessor)dp, schemaSource.uriForLoading());
        return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)diags, (Object)processor));
    }

    private Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> compileProcessor(DaffodilSchemaSource schemaSource, Option<String> optRootName, Option<String> optRootNamespace) {
        ProcessorFactory pf = this.compiler().compileSource(schemaSource, optRootName, optRootNamespace);
        if (pf.isError()) {
            List diags = pf.getDiagnostics();
            return package$.MODULE$.Left().apply((Object)diags);
        }
        Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> res = this.generateProcessor((DFDL.ProcessorFactory)pf, schemaSource);
        return res;
    }

    public Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> getProcessor(DaffodilSchemaSource schemaSource, Option<String> optRootName, Option<String> optRootNamespace, Map<String, String> tunables) {
        if (schemaSource.isXSD()) {
            Either<List<Diagnostic>, Tuple2<List<Diagnostic>, TDMLDFDLProcessor>> res = this.compileProcessor(schemaSource, optRootName, optRootNamespace);
            return res;
        }
        org.apache.daffodil.api.DataProcessor dp = this.compiler().reload(schemaSource);
        List diags = dp.getDiagnostics();
        if (!CollectionConverters$.MODULE$.ListHasAsScala(diags).asScala().forall((Function1 & Serializable)_$1 -> !_$1.isError())) {
            throw Assert$.MODULE$.abort("Invariant broken: scala.jdk.CollectionConverters.ListHasAsScala[org.apache.daffodil.api.Diagnostic](diags).asScala.forall(((_$1: org.apache.daffodil.api.Diagnostic) => _$1.isError().unary_!))");
        }
        DaffodilTDMLDFDLProcessor processor = new DaffodilTDMLDFDLProcessor(dp, schemaSource.uriForLoading());
        return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)diags, (Object)processor));
    }
}

