/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.grammar.primitives;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.daffodil.lib.exceptions.SavesErrorsAndWarnings;
import org.apache.daffodil.lib.iapi.WarnID$RegexPatternZeroLength$;
import org.apache.daffodil.lib.util.Misc$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class PatternChecker$
implements Serializable {
    public static final PatternChecker$ MODULE$ = new PatternChecker$();

    private PatternChecker$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PatternChecker$.class);
    }

    public void checkPattern(String pattern, SavesErrorsAndWarnings context) {
        try {
            Pattern pat = Pattern.compile(pattern);
            Matcher m1 = pat.matcher("");
            Matcher m2 = pat.matcher("\ufffe");
            if (m1.matches() && m2.lookingAt() && m2.group().length() == 0) {
                String needCDATA = pattern.startsWith("(?x)") && !pattern.contains("\n") && pattern.contains("#") ? "\nMissing <![CDATA[...]]> around the regular expression.\nThis is required for free-form regular expression syntax with comments." : "";
                context.SDW(WarnID$RegexPatternZeroLength$.MODULE$, "Regular expression pattern '%s'.\nThis pattern will match with zero length, so it can always match.%s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pattern, needCDATA}));
            }
        }
        catch (PatternSyntaxException e) {
            throw context.SDE("Invalid regular expression pattern '%s'.\nReason: %s.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pattern, Misc$.MODULE$.getSomeMessage(e).get()}));
        }
    }
}

