/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.reflect.ClassDescriptor;

class PersistentDescriptorResultMetadata
implements EntityResultSegment {
    ClassDescriptor classDescriptor;
    Map<String, String> fields;
    Map<String, String> reverseFields;

    PersistentDescriptorResultMetadata(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.fields = new HashMap<String, String>();
        this.reverseFields = new HashMap<String, String>();
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    public Map<String, String> getFields() {
        return this.fields;
    }

    @Override
    public String getColumnPath(String resultSetLabel) {
        return this.reverseFields.get(resultSetLabel);
    }

    void addObjectField(String attributeName, String column) {
        ObjEntity entity = this.classDescriptor.getEntity();
        ObjAttribute attribute = entity.getAttribute(attributeName);
        this.fields.put(attribute.getDbAttributePath(), column);
        this.reverseFields.put(column, attribute.getDbAttributePath());
    }

    void addObjectField(String entityName, String attributeName, String column) {
        ObjEntity entity = this.classDescriptor.getEntity().getDataMap().getObjEntity(entityName);
        ObjAttribute attribute = entity.getAttribute(attributeName);
        this.fields.put(attribute.getDbAttributePath(), column);
        this.reverseFields.put(column, attribute.getDbAttributePath());
    }

    void addDbField(String dbAttributeName, String column) {
        this.fields.put(dbAttributeName, column);
        this.reverseFields.put(column, dbAttributeName);
    }

    @Override
    public int getColumnOffset() {
        throw new UnsupportedOperationException("Column offset only makes sense in the context of a query");
    }
}

