/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.options;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.ProfilerConfig;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.Utils;

public class OptionsBuilder
implements Options,
ChainedOptionsBuilder {
    private static final long serialVersionUID = -4088596253924343849L;
    private Options otherOptions;
    private final List<String> regexps = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private Optional<String> output = Optional.none();
    private Optional<ResultFormatType> rfType = Optional.none();
    private Optional<String> result = Optional.none();
    private Optional<Boolean> shouldDoGC = Optional.none();
    private final List<ProfilerConfig> profilers = new ArrayList<ProfilerConfig>();
    private Optional<VerboseMode> verbosity = Optional.none();
    private Optional<Boolean> shouldFailOnError = Optional.none();
    private Optional<Integer> threads = Optional.none();
    private Optional<int[]> threadGroups = Optional.none();
    private Optional<Boolean> syncIterations = Optional.none();
    private Optional<Integer> warmupIterations = Optional.none();
    private Optional<Integer> warmupBatchSize = Optional.none();
    private Optional<TimeValue> warmupTime = Optional.none();
    private Optional<WarmupMode> warmupMode = Optional.none();
    private final List<String> warmupMicros = new ArrayList<String>();
    private Optional<Integer> iterations = Optional.none();
    private Optional<TimeValue> measurementTime = Optional.none();
    private Optional<Integer> measurementBatchSize = Optional.none();
    private final EnumSet<Mode> benchModes = EnumSet.noneOf(Mode.class);
    private Optional<TimeUnit> timeUnit = Optional.none();
    private Optional<Integer> opsPerInvocation = Optional.none();
    private Optional<Integer> forks = Optional.none();
    private Optional<Integer> warmupForks = Optional.none();
    private Optional<String> jvmBinary = Optional.none();
    private Optional<Collection<String>> jvmArgs = Optional.none();
    private Optional<Collection<String>> jvmArgsAppend = Optional.none();
    private Optional<Collection<String>> jvmArgsPrepend = Optional.none();
    private final Multimap<String, String> params = new HashMultimap<String, String>();
    private Optional<TimeValue> timeout = Optional.none();

    @Override
    public Options build() {
        return this;
    }

    @Override
    public ChainedOptionsBuilder parent(Options other) {
        this.otherOptions = other;
        return this;
    }

    private static void checkGreaterOrEqual(int value, int minValue, String s) {
        if (value >= minValue) {
            return;
        }
        String message = s + " (" + value + ") should be ";
        message = minValue == 0 ? message + "non-negative" : (minValue == 1 ? message + "positive" : message + "greater or equal than " + minValue);
        throw new IllegalArgumentException(message);
    }

    @Override
    public ChainedOptionsBuilder include(String regexp) {
        this.regexps.add(regexp);
        return this;
    }

    @Override
    public List<String> getIncludes() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.regexps);
        if (this.otherOptions != null) {
            result.addAll(this.otherOptions.getIncludes());
        }
        return result;
    }

    @Override
    public ChainedOptionsBuilder exclude(String regexp) {
        this.excludes.add(regexp);
        return this;
    }

    @Override
    public List<String> getExcludes() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.excludes);
        if (this.otherOptions != null) {
            result.addAll(this.otherOptions.getExcludes());
        }
        return result;
    }

    @Override
    public ChainedOptionsBuilder output(String filename) {
        this.output = Optional.of(filename);
        return this;
    }

    @Override
    public Optional<String> getOutput() {
        if (this.otherOptions != null) {
            return this.output.orAnother(this.otherOptions.getOutput());
        }
        return this.output;
    }

    @Override
    public ChainedOptionsBuilder resultFormat(ResultFormatType type) {
        this.rfType = Optional.of(type);
        return this;
    }

    @Override
    public Optional<ResultFormatType> getResultFormat() {
        if (this.otherOptions != null) {
            return this.rfType.orAnother(this.otherOptions.getResultFormat());
        }
        return this.rfType;
    }

    @Override
    public ChainedOptionsBuilder result(String filename) {
        this.result = Optional.of(filename);
        return this;
    }

    @Override
    public Optional<String> getResult() {
        if (this.otherOptions != null) {
            return this.result.orAnother(this.otherOptions.getResult());
        }
        return this.result;
    }

    @Override
    public ChainedOptionsBuilder shouldDoGC(boolean value) {
        this.shouldDoGC = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Boolean> shouldDoGC() {
        if (this.otherOptions != null) {
            return this.shouldDoGC.orAnother(this.otherOptions.shouldDoGC());
        }
        return this.shouldDoGC;
    }

    @Override
    public ChainedOptionsBuilder addProfiler(Class<? extends Profiler> prof) {
        this.profilers.add(new ProfilerConfig(prof.getCanonicalName()));
        return this;
    }

    @Override
    public ChainedOptionsBuilder addProfiler(Class<? extends Profiler> prof, String initLine) {
        this.profilers.add(new ProfilerConfig(prof.getCanonicalName(), initLine));
        return this;
    }

    @Override
    public ChainedOptionsBuilder addProfiler(String prof) {
        this.profilers.add(new ProfilerConfig(prof, ""));
        return this;
    }

    @Override
    public ChainedOptionsBuilder addProfiler(String prof, String initLine) {
        this.profilers.add(new ProfilerConfig(prof, initLine));
        return this;
    }

    @Override
    public List<ProfilerConfig> getProfilers() {
        ArrayList<ProfilerConfig> result = new ArrayList<ProfilerConfig>();
        result.addAll(this.profilers);
        if (this.otherOptions != null) {
            result.addAll(this.otherOptions.getProfilers());
        }
        return result;
    }

    @Override
    public ChainedOptionsBuilder verbosity(VerboseMode mode) {
        this.verbosity = Optional.of(mode);
        return this;
    }

    @Override
    public Optional<VerboseMode> verbosity() {
        if (this.otherOptions != null) {
            return this.verbosity.orAnother(this.otherOptions.verbosity());
        }
        return this.verbosity;
    }

    @Override
    public ChainedOptionsBuilder shouldFailOnError(boolean value) {
        this.shouldFailOnError = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Boolean> shouldFailOnError() {
        if (this.otherOptions != null) {
            return this.shouldFailOnError.orAnother(this.otherOptions.shouldFailOnError());
        }
        return this.shouldFailOnError;
    }

    @Override
    public ChainedOptionsBuilder threads(int count) {
        if (count != -1) {
            OptionsBuilder.checkGreaterOrEqual(count, 1, "Threads");
        }
        this.threads = Optional.of(count);
        return this;
    }

    @Override
    public Optional<Integer> getThreads() {
        if (this.otherOptions != null) {
            return this.threads.orAnother(this.otherOptions.getThreads());
        }
        return this.threads;
    }

    @Override
    public ChainedOptionsBuilder threadGroups(int ... groups) {
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                OptionsBuilder.checkGreaterOrEqual(groups[i], 0, "Group #" + i + " thread count");
            }
            OptionsBuilder.checkGreaterOrEqual(Utils.sum(groups), 1, "Group thread count");
        }
        this.threadGroups = Optional.of((int[])(groups == null || groups.length != 0 ? groups : null));
        return this;
    }

    @Override
    public Optional<int[]> getThreadGroups() {
        if (this.otherOptions != null) {
            return this.threadGroups.orAnother(this.otherOptions.getThreadGroups());
        }
        return this.threadGroups;
    }

    @Override
    public ChainedOptionsBuilder syncIterations(boolean value) {
        this.syncIterations = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Boolean> shouldSyncIterations() {
        if (this.otherOptions != null) {
            return this.syncIterations.orAnother(this.otherOptions.shouldSyncIterations());
        }
        return this.syncIterations;
    }

    @Override
    public ChainedOptionsBuilder warmupIterations(int value) {
        OptionsBuilder.checkGreaterOrEqual(value, 0, "Warmup iterations");
        this.warmupIterations = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Integer> getWarmupIterations() {
        if (this.otherOptions != null) {
            return this.warmupIterations.orAnother(this.otherOptions.getWarmupIterations());
        }
        return this.warmupIterations;
    }

    @Override
    public ChainedOptionsBuilder warmupBatchSize(int value) {
        OptionsBuilder.checkGreaterOrEqual(value, 1, "Warmup batch size");
        this.warmupBatchSize = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Integer> getWarmupBatchSize() {
        if (this.otherOptions != null) {
            return this.warmupBatchSize.orAnother(this.otherOptions.getWarmupBatchSize());
        }
        return this.warmupBatchSize;
    }

    @Override
    public ChainedOptionsBuilder warmupTime(TimeValue value) {
        this.warmupTime = Optional.of(value);
        return this;
    }

    @Override
    public Optional<TimeValue> getWarmupTime() {
        if (this.otherOptions != null) {
            return this.warmupTime.orAnother(this.otherOptions.getWarmupTime());
        }
        return this.warmupTime;
    }

    @Override
    public ChainedOptionsBuilder warmupMode(WarmupMode mode) {
        this.warmupMode = Optional.of(mode);
        return this;
    }

    @Override
    public Optional<WarmupMode> getWarmupMode() {
        if (this.otherOptions != null) {
            return this.warmupMode.orAnother(this.otherOptions.getWarmupMode());
        }
        return this.warmupMode;
    }

    @Override
    public ChainedOptionsBuilder includeWarmup(String regexp) {
        this.warmupMicros.add(regexp);
        return this;
    }

    @Override
    public List<String> getWarmupIncludes() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.warmupMicros);
        if (this.otherOptions != null) {
            result.addAll(this.otherOptions.getWarmupIncludes());
        }
        return result;
    }

    @Override
    public ChainedOptionsBuilder measurementIterations(int count) {
        OptionsBuilder.checkGreaterOrEqual(count, 1, "Measurement iterations");
        this.iterations = Optional.of(count);
        return this;
    }

    @Override
    public Optional<Integer> getMeasurementIterations() {
        if (this.otherOptions != null) {
            return this.iterations.orAnother(this.otherOptions.getMeasurementIterations());
        }
        return this.iterations;
    }

    @Override
    public ChainedOptionsBuilder measurementTime(TimeValue value) {
        this.measurementTime = Optional.of(value);
        return this;
    }

    @Override
    public Optional<TimeValue> getMeasurementTime() {
        if (this.otherOptions != null) {
            return this.measurementTime.orAnother(this.otherOptions.getMeasurementTime());
        }
        return this.measurementTime;
    }

    @Override
    public ChainedOptionsBuilder measurementBatchSize(int value) {
        OptionsBuilder.checkGreaterOrEqual(value, 1, "Measurement batch size");
        this.measurementBatchSize = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Integer> getMeasurementBatchSize() {
        if (this.otherOptions != null) {
            return this.measurementBatchSize.orAnother(this.otherOptions.getMeasurementBatchSize());
        }
        return this.measurementBatchSize;
    }

    @Override
    public ChainedOptionsBuilder mode(Mode mode) {
        this.benchModes.add(mode);
        return this;
    }

    @Override
    public Collection<Mode> getBenchModes() {
        if (this.otherOptions != null && this.benchModes.isEmpty()) {
            return this.otherOptions.getBenchModes();
        }
        return this.benchModes;
    }

    @Override
    public ChainedOptionsBuilder timeUnit(TimeUnit tu) {
        this.timeUnit = Optional.of(tu);
        return this;
    }

    @Override
    public Optional<TimeUnit> getTimeUnit() {
        if (this.otherOptions != null) {
            return this.timeUnit.orAnother(this.otherOptions.getTimeUnit());
        }
        return this.timeUnit;
    }

    @Override
    public ChainedOptionsBuilder operationsPerInvocation(int opsPerInv) {
        OptionsBuilder.checkGreaterOrEqual(opsPerInv, 1, "Operations per invocation");
        this.opsPerInvocation = Optional.of(opsPerInv);
        return this;
    }

    @Override
    public Optional<Integer> getOperationsPerInvocation() {
        if (this.otherOptions != null) {
            return this.opsPerInvocation.orAnother(this.otherOptions.getOperationsPerInvocation());
        }
        return this.opsPerInvocation;
    }

    @Override
    public ChainedOptionsBuilder forks(int value) {
        OptionsBuilder.checkGreaterOrEqual(value, 0, "Forks");
        this.forks = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Integer> getForkCount() {
        if (this.otherOptions != null) {
            return this.forks.orAnother(this.otherOptions.getForkCount());
        }
        return this.forks;
    }

    @Override
    public ChainedOptionsBuilder warmupForks(int value) {
        OptionsBuilder.checkGreaterOrEqual(value, 0, "Warmup forks");
        this.warmupForks = Optional.of(value);
        return this;
    }

    @Override
    public Optional<Integer> getWarmupForkCount() {
        if (this.otherOptions != null) {
            return this.warmupForks.orAnother(this.otherOptions.getWarmupForkCount());
        }
        return this.warmupForks;
    }

    @Override
    public ChainedOptionsBuilder jvm(String path) {
        this.jvmBinary = Optional.of(path);
        return this;
    }

    @Override
    public Optional<String> getJvm() {
        if (this.otherOptions != null) {
            return this.jvmBinary.orAnother(this.otherOptions.getJvm());
        }
        return this.jvmBinary;
    }

    @Override
    public ChainedOptionsBuilder jvmArgs(String ... value) {
        this.jvmArgs = Optional.of(Arrays.asList(value));
        return this;
    }

    @Override
    public Optional<Collection<String>> getJvmArgs() {
        if (this.otherOptions != null) {
            return this.jvmArgs.orAnother(this.otherOptions.getJvmArgs());
        }
        return this.jvmArgs;
    }

    @Override
    public ChainedOptionsBuilder jvmArgsAppend(String ... value) {
        this.jvmArgsAppend = Optional.of(Arrays.asList(value));
        return this;
    }

    @Override
    public Optional<Collection<String>> getJvmArgsAppend() {
        if (this.otherOptions != null) {
            return this.jvmArgsAppend.orAnother(this.otherOptions.getJvmArgsAppend());
        }
        return this.jvmArgsAppend;
    }

    @Override
    public ChainedOptionsBuilder jvmArgsPrepend(String ... value) {
        this.jvmArgsPrepend = Optional.of(Arrays.asList(value));
        return this;
    }

    @Override
    public Optional<Collection<String>> getJvmArgsPrepend() {
        if (this.otherOptions != null) {
            return this.jvmArgsPrepend.orAnother(this.otherOptions.getJvmArgsPrepend());
        }
        return this.jvmArgsPrepend;
    }

    @Override
    public ChainedOptionsBuilder detectJvmArgs() {
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return this.jvmArgs(inputArguments.toArray(new String[0]));
    }

    @Override
    public Optional<Collection<String>> getParameter(String name) {
        Collection<String> list = this.params.get(name);
        if (list == null || list.isEmpty()) {
            if (this.otherOptions != null) {
                return this.otherOptions.getParameter(name);
            }
            return Optional.none();
        }
        return Optional.of(list);
    }

    @Override
    public ChainedOptionsBuilder param(String name, String ... values) {
        this.params.putAll(name, Arrays.asList(values));
        return this;
    }

    @Override
    public ChainedOptionsBuilder timeout(TimeValue value) {
        this.timeout = Optional.of(value);
        return this;
    }

    @Override
    public Optional<TimeValue> getTimeout() {
        if (this.otherOptions != null) {
            return this.timeout.orAnother(this.otherOptions.getTimeout());
        }
        return this.timeout;
    }
}

