/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageConsumer;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageProducer;
import org.apache.activemq.artemis.ra.ActiveMQRAQueueReceiver;
import org.apache.activemq.artemis.ra.ActiveMQRAQueueSender;
import org.apache.activemq.artemis.ra.ActiveMQRASessionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRATopicPublisher;
import org.apache.activemq.artemis.ra.ActiveMQRATopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRASession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQRAManagedConnection mc;
    private final ActiveMQRAConnectionRequestInfo cri;
    private ActiveMQRASessionFactory sf;
    private final Set<MessageConsumer> consumers;
    private final Set<MessageProducer> producers;

    public ActiveMQRASession(ActiveMQRAManagedConnection mc, ActiveMQRAConnectionRequestInfo cri) {
        logger.trace("constructor({}, {})", (Object)mc, (Object)cri);
        this.mc = mc;
        this.cri = cri;
        this.sf = null;
        this.consumers = new HashSet<MessageConsumer>();
        this.producers = new HashSet<MessageProducer>();
    }

    public void setActiveMQSessionFactory(ActiveMQRASessionFactory sf) {
        logger.trace("setActiveMQSessionFactory({})", (Object)sf);
        this.sf = sf;
    }

    protected void lock() throws JMSException {
        logger.trace("lock()");
        ActiveMQRAManagedConnection mcLocal = this.mc;
        if (mcLocal == null) {
            throw new IllegalStateException("Connection is not associated with a managed connection. " + String.valueOf(this));
        }
        mcLocal.tryLock();
    }

    protected void unlock() {
        logger.trace("unlock()");
        ActiveMQRAManagedConnection mcLocal = this.mc;
        if (mcLocal != null) {
            mcLocal.unlock();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createBytesMessage(), {}", (Object)session);
        return session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createMapMessage(), {}", (Object)session);
        return session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createMessage(), {}", (Object)session);
        return session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createObjectMessage(), {}", (Object)session);
        return session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createObjectMessage({})", (Object)object, (Object)session);
        return session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createStreamMessage(), {}", (Object)session);
        return session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createTextMessage(), {}", (Object)session);
        return session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        Session session = this.getSessionInternal();
        logger.trace("createTextMessage({}) {}", (Object)string, (Object)session);
        return session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        logger.trace("getTransacted()");
        this.getSessionInternal();
        return this.cri.isTransacted();
    }

    public MessageListener getMessageListener() throws JMSException {
        logger.trace("getMessageListener()");
        throw new IllegalStateException("Method not allowed");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        logger.trace("setMessageListener({})", (Object)listener);
        throw new IllegalStateException("Method not allowed");
    }

    public void run() {
        logger.trace("run()");
        throw new Error("Method not allowed");
    }

    public void close() throws JMSException {
        logger.trace("close()");
        this.sf.closeSession(this);
        this.closeSession();
    }

    public void commit() throws JMSException {
        if (this.cri.getType() == 3 || this.cri.getType() == 4 || this.cri.getType() == 5) {
            throw new TransactionInProgressException("XA connection");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (!this.cri.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            logger.trace("Commit session {}", (Object)this);
            session.commit();
        }
        finally {
            this.unlock();
        }
    }

    public void rollback() throws JMSException {
        if (this.cri.getType() == 3 || this.cri.getType() == 4 || this.cri.getType() == 5) {
            throw new TransactionInProgressException("XA connection");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (!this.cri.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            logger.trace("Rollback session {}", (Object)this);
            session.rollback();
        }
        finally {
            this.unlock();
        }
    }

    public void recover() throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (this.cri.isTransacted()) {
                throw new IllegalStateException("Session is transacted");
            }
            logger.trace("Recover session {}", (Object)this);
            session.recover();
        }
        finally {
            this.unlock();
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create topic for javax.jms.QueueSession");
        }
        Session session = this.getSessionInternal();
        if (logger.isTraceEnabled()) {
            logger.trace("createTopic {} topicName={}", (Object)session, (Object)topicName);
        }
        Topic result = session.createTopic(topicName);
        if (logger.isTraceEnabled()) {
            logger.trace("createdTopic {} topic={}", (Object)session, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            logger.trace("createSubscriber {} topic={}", (Object)session, (Object)topic);
            TopicSubscriber result = session.createSubscriber(topic);
            result = new ActiveMQRATopicSubscriber(result, this);
            logger.trace("createdSubscriber {} ActiveMQTopicSubscriber={}", (Object)session, (Object)result);
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createSubscriber {} topic={} selector={} noLocal={}", new Object[]{session, topic, messageSelector, noLocal});
            }
            TopicSubscriber result = session.createSubscriber(topic, messageSelector, noLocal);
            result = new ActiveMQRATopicSubscriber(result, this);
            logger.trace("createdSubscriber {} ActiveMQTopicSubscriber={}", (Object)session, (Object)result);
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create durable subscriber from javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createDurableSubscriber {} topic={} name={}", new Object[]{session, topic, name});
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name);
            result = new ActiveMQRATopicSubscriber(result, this);
            logger.trace("createdDurableSubscriber {} ActiveMQTopicSubscriber={}", (Object)session, (Object)result);
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createDurableSubscriber {} topic={} name={} selector={} noLocal={}", new Object[]{session, topic, name, messageSelector, noLocal});
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name, messageSelector, noLocal);
            result = new ActiveMQRATopicSubscriber(result, this);
            logger.trace("createdDurableSubscriber {} ActiveMQTopicSubscriber={}", (Object)session, (Object)result);
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            logger.trace("createPublisher {} topic={}", (Object)session, (Object)topic);
            TopicPublisher result = session.createPublisher(topic);
            result = new ActiveMQRATopicPublisher(result, this);
            logger.trace("createdPublisher {} publisher=", (Object)session, (Object)result);
            this.addProducer((MessageProducer)result);
            TopicPublisher topicPublisher = result;
            return topicPublisher;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create temporary topic for javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            logger.trace("createTemporaryTopic {}", (Object)session);
            TemporaryTopic temp = session.createTemporaryTopic();
            logger.trace("createdTemporaryTopic {} temp={}", (Object)session, (Object)temp);
            this.sf.addTemporaryTopic(temp);
            TemporaryTopic temporaryTopic = temp;
            return temporaryTopic;
        }
        finally {
            this.unlock();
        }
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot unsubscribe for javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            logger.trace("unsubscribe {} name={}", (Object)session, (Object)name);
            session.unsubscribe(name);
        }
        finally {
            this.unlock();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        logger.trace("createBrowser {} queue={}", (Object)session, (Object)queue);
        QueueBrowser result = session.createBrowser(queue);
        logger.trace("createdBrowser {} browser={}", (Object)session, (Object)result);
        return result;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (logger.isTraceEnabled()) {
            logger.trace("createBrowser {} queue={} selector={}", new Object[]{session, queue, messageSelector});
        }
        QueueBrowser result = session.createBrowser(queue, messageSelector);
        logger.trace("createdBrowser {} browser={}", (Object)session, (Object)result);
        return result;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser or javax.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        logger.trace("createQueue {} queueName={}", (Object)session, (Object)queueName);
        Queue result = session.createQueue(queueName);
        logger.trace("createdQueue {} queue={}", (Object)session, (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            logger.trace("createReceiver {} queue={}", (Object)session, (Object)queue);
            QueueReceiver result = session.createReceiver(queue);
            result = new ActiveMQRAQueueReceiver(result, this);
            logger.trace("createdReceiver {} receiver={}", (Object)session, (Object)result);
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createReceiver {} queue={} selector={}", new Object[]{session, queue, messageSelector});
            }
            QueueReceiver result = session.createReceiver(queue, messageSelector);
            result = new ActiveMQRAQueueReceiver(result, this);
            logger.trace("createdReceiver {} receiver={}", (Object)session, (Object)result);
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            logger.trace("createSender {} queue={}", (Object)session, (Object)queue);
            QueueSender result = session.createSender(queue);
            result = new ActiveMQRAQueueSender(result, this);
            logger.trace("createdSender {} sender={}", (Object)session, (Object)result);
            this.addProducer((MessageProducer)result);
            QueueSender queueSender = result;
            return queueSender;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create temporary queue for javax.jms.TopicSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            logger.trace("createTemporaryQueue {}", (Object)session);
            TemporaryQueue temp = session.createTemporaryQueue();
            logger.trace("createdTemporaryQueue {} temp={}", (Object)session, (Object)temp);
            this.sf.addTemporaryQueue(temp);
            TemporaryQueue temporaryQueue = temp;
            return temporaryQueue;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            logger.trace("createConsumer {} dest={}", (Object)session, (Object)destination);
            MessageConsumer result = session.createConsumer(destination);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createConsumer {} dest={} messageSelector={}", new Object[]{session, destination, messageSelector});
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createConsumer {} dest={} messageSelector={} noLocal={}", new Object[]{session, destination, messageSelector, noLocal});
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector, noLocal);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            logger.trace("createProducer {} dest={}", (Object)session, (Object)destination);
            MessageProducer result = session.createProducer(destination);
            result = new ActiveMQRAMessageProducer(result, this);
            logger.trace("createdProducer {} producer={}", (Object)session, (Object)result);
            this.addProducer(result);
            MessageProducer messageProducer = result;
            return messageProducer;
        }
        finally {
            this.unlock();
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        logger.trace("getAcknowledgeMode()");
        this.getSessionInternal();
        return this.cri.getAcknowledgeMode();
    }

    public XAResource getXAResource() {
        logger.trace("getXAResource()");
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            return null;
        }
        try {
            this.lock();
            XAResource xAResource = this.getXAResourceInternal();
            return xAResource;
        }
        catch (Throwable t) {
            XAResource xAResource = null;
            return xAResource;
        }
        finally {
            this.unlock();
        }
    }

    public String getNodeId() throws JMSException {
        ActiveMQSession session = (ActiveMQSession)this.getSessionInternal();
        ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)session.getCoreSession().getSessionFactory();
        return factory.getPrimaryNodeId();
    }

    public Session getSession() throws JMSException {
        logger.trace("getNonXAsession()");
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            ActiveMQRASession activeMQRASession = this;
            return activeMQRASession;
        }
        finally {
            this.unlock();
        }
    }

    public QueueSession getQueueSession() throws JMSException {
        logger.trace("getQueueSession()");
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            ActiveMQRASession activeMQRASession = this;
            return activeMQRASession;
        }
        finally {
            this.unlock();
        }
    }

    public TopicSession getTopicSession() throws JMSException {
        logger.trace("getTopicSession()");
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            ActiveMQRASession activeMQRASession = this;
            return activeMQRASession;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createSharedConsumer {} topic={}, sharedSubscriptionName={}", new Object[]{session, topic, sharedSubscriptionName});
            }
            MessageConsumer result = session.createSharedConsumer(topic, sharedSubscriptionName);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createSharedConsumer {} topic={}, sharedSubscriptionName={}, messageSelector={}", new Object[]{session, topic, sharedSubscriptionName, messageSelector});
            }
            MessageConsumer result = session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createSharedConsumer {} topic={}, name={}", new Object[]{session, topic, name});
            }
            MessageConsumer result = session.createDurableConsumer(topic, name);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createDurableConsumer {} topic={}, name={}, messageSelector={}, noLocal={}", new Object[]{session, topic, name, messageSelector, noLocal});
            }
            MessageConsumer result = session.createDurableConsumer(topic, name, messageSelector, noLocal);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createSharedDurableConsumer {} topic={}, name={}", new Object[]{session, topic, name});
            }
            MessageConsumer result = session.createSharedDurableConsumer(topic, name);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (logger.isTraceEnabled()) {
                logger.trace("createSharedDurableConsumer {} topic={}, name={}, messageSelector={}", new Object[]{session, topic, name, messageSelector});
            }
            MessageConsumer result = session.createSharedDurableConsumer(topic, name, messageSelector);
            result = new ActiveMQRAMessageConsumer(result, this);
            logger.trace("createdConsumer {} consumer={}", (Object)session, (Object)result);
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    void setManagedConnection(ActiveMQRAManagedConnection managedConnection) {
        logger.trace("setManagedConnection({})", (Object)managedConnection);
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = managedConnection;
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    void destroy() {
        logger.trace("destroy()");
        this.mc = null;
    }

    void start() throws JMSException {
        logger.trace("start()");
        if (this.mc != null) {
            this.mc.start();
        }
    }

    void stop() throws JMSException {
        logger.trace("stop()");
        if (this.mc != null) {
            this.mc.stop();
        }
    }

    void checkStrict() throws JMSException {
        logger.trace("checkStrict()");
        if (this.mc != null) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() throws JMSException {
        if (this.mc != null) {
            Iterator<MessageConsumer> i;
            logger.trace("Closing session");
            try {
                this.mc.stop();
            }
            catch (Throwable t) {
                logger.trace("Error stopping managed connection", t);
            }
            Set<MessageConsumer> t = this.consumers;
            synchronized (t) {
                i = this.consumers.iterator();
                while (i.hasNext()) {
                    ActiveMQRAMessageConsumer consumer = (ActiveMQRAMessageConsumer)i.next();
                    try {
                        consumer.closeConsumer();
                    }
                    catch (Throwable t2) {
                        logger.trace("Error closing consumer", t2);
                    }
                    i.remove();
                }
            }
            t = this.producers;
            synchronized (t) {
                i = this.producers.iterator();
                while (i.hasNext()) {
                    ActiveMQRAMessageProducer producer = (ActiveMQRAMessageProducer)i.next();
                    try {
                        producer.closeProducer();
                    }
                    catch (Throwable t3) {
                        logger.trace("Error closing producer", t3);
                    }
                    i.remove();
                }
            }
            this.mc.removeHandle(this);
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 1);
            ev.setConnectionHandle((Object)this);
            this.mc.sendEvent(ev);
            this.mc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(MessageConsumer consumer) {
        logger.trace("addConsumer({})", (Object)consumer);
        Set<MessageConsumer> set = this.consumers;
        synchronized (set) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(MessageConsumer consumer) {
        logger.trace("removeConsumer({})", (Object)consumer);
        Set<MessageConsumer> set = this.consumers;
        synchronized (set) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(MessageProducer producer) {
        logger.trace("addProducer({})", (Object)producer);
        Set<MessageProducer> set = this.producers;
        synchronized (set) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducer(MessageProducer producer) {
        logger.trace("removeProducer({})", (Object)producer);
        Set<MessageProducer> set = this.producers;
        synchronized (set) {
            this.producers.remove(producer);
        }
    }

    Session getSessionInternal() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        Session session = this.mc.getSession();
        logger.trace("getSessionInternal {} for {}", (Object)session, (Object)this);
        return session;
    }

    XAResource getXAResourceInternal() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        try {
            XAResource xares = this.mc.getXAResource();
            if (logger.isTraceEnabled()) {
                logger.trace("getXAResourceInternal {} for {}", (Object)xares, (Object)this);
            }
            return xares;
        }
        catch (ResourceException e) {
            JMSException jmse = new JMSException("Unable to get XA Resource");
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    QueueSession getQueueSessionInternal() throws JMSException {
        Session s = this.getSessionInternal();
        if (!(s instanceof QueueSession)) {
            throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + String.valueOf(this));
        }
        return (QueueSession)s;
    }

    TopicSession getTopicSessionInternal() throws JMSException {
        Session s = this.getSessionInternal();
        if (!(s instanceof TopicSession)) {
            throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + String.valueOf(this));
        }
        return (TopicSession)s;
    }

    public void checkState() throws JMSException {
        if (this.mc != null) {
            this.mc.checkTransactionActive();
        }
    }
}

