/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.qpid.proton.engine.Link;

public class BasicMirrorController<T extends Link> {
    protected final ActiveMQServer server;
    protected T link;
    protected String remoteMirrorId;
    protected final String localMirrorId;

    public String getLocalMirrorId() {
        return this.localMirrorId;
    }

    public String getRemoteMirrorId() {
        if (this.remoteMirrorId == null) {
            this.remoteMirrorId = BasicMirrorController.getRemoteMirrorID(this.link);
        }
        return this.remoteMirrorId;
    }

    public static String getRemoteMirrorID(Link link) {
        if (link != null && link.getRemoteProperties() != null && link.getRemoteProperties().containsKey(AMQPMirrorControllerSource.BROKER_ID)) {
            return (String)link.getRemoteProperties().get(AMQPMirrorControllerSource.BROKER_ID);
        }
        return null;
    }

    public BasicMirrorController(ActiveMQServer server) {
        this.server = server;
        this.localMirrorId = server.getNodeID().toString();
    }

    public T getLink() {
        return this.link;
    }

    public BasicMirrorController<T> setLink(T link) {
        this.link = link;
        return this;
    }
}

