/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.cpe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.cpe.CpeBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.util.InvalidXMLException;
import org.xml.sax.SAXException;

public final class CpePipeline {
    private CpePipeline() {
    }

    public static void runPipeline(CollectionReaderDescription readerDesc, AnalysisEngineDescription ... descs) throws SAXException, CpeDescriptorException, IOException, ResourceInitializationException, InvalidXMLException, AnalysisEngineProcessException {
        CpePipeline.runPipeline(Math.max(1, Runtime.getRuntime().availableProcessors() - 1), readerDesc, descs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPipeline(int parallelism, CollectionReaderDescription readerDesc, AnalysisEngineDescription ... descs) throws SAXException, CpeDescriptorException, IOException, ResourceInitializationException, InvalidXMLException, AnalysisEngineProcessException {
        AnalysisEngineDescription topLevelAnalysisEngine;
        if (descs.length == 1 && !CpePipeline.mayContainCasMultiplier(descs[0])) {
            topLevelAnalysisEngine = descs[0];
        } else {
            topLevelAnalysisEngine = AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])descs);
            topLevelAnalysisEngine.getMetaData().setName("Top-level CPE Aggregate");
        }
        CpeBuilder builder = new CpeBuilder();
        builder.setReader(readerDesc);
        builder.setAnalysisEngine(topLevelAnalysisEngine);
        builder.setMaxProcessingUnitThreadCount(parallelism);
        StatusCallbackListenerImpl status = new StatusCallbackListenerImpl();
        CollectionProcessingEngine engine = builder.createCpe(status);
        engine.process();
        while (status.isProcessing) {
            StatusCallbackListenerImpl statusCallbackListenerImpl = status;
            synchronized (statusCallbackListenerImpl) {
                try {
                    status.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (status.exceptions.size() > 0) {
                    if (engine.isProcessing()) {
                        engine.kill();
                    }
                    throw new AnalysisEngineProcessException((Throwable)status.exceptions.get(0));
                }
            }
        }
    }

    private static boolean mayContainCasMultiplier(AnalysisEngineDescription desc) {
        if (desc.isPrimitive()) {
            return desc.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
        }
        for (MetaDataObject mdo : desc.getDelegateAnalysisEngineSpecifiersWithImports().values()) {
            AnalysisEngineDescription aed;
            if (mdo instanceof Import) {
                return true;
            }
            if (!(mdo instanceof AnalysisEngineDescription) || !(aed = (AnalysisEngineDescription)mdo).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) continue;
            return true;
        }
        return false;
    }

    private static class StatusCallbackListenerImpl
    implements StatusCallbackListener {
        private final List<Exception> exceptions = new ArrayList<Exception>();
        private boolean isProcessing = true;

        private StatusCallbackListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void entityProcessComplete(CAS arg0, EntityProcessStatus arg1) {
            if (arg1.isException()) {
                for (Exception e : arg1.getExceptions()) {
                    this.exceptions.add(e);
                    StatusCallbackListenerImpl statusCallbackListenerImpl = this;
                    synchronized (statusCallbackListenerImpl) {
                        this.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aborted() {
            if (this.isProcessing) {
                this.isProcessing = false;
                StatusCallbackListenerImpl statusCallbackListenerImpl = this;
                synchronized (statusCallbackListenerImpl) {
                    this.notify();
                }
            }
        }

        public void batchProcessComplete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void collectionProcessComplete() {
            if (this.isProcessing) {
                this.isProcessing = false;
                StatusCallbackListenerImpl statusCallbackListenerImpl = this;
                synchronized (statusCallbackListenerImpl) {
                    this.notify();
                }
            }
        }

        public void initializationComplete() {
        }

        public void paused() {
        }

        public void resumed() {
        }
    }
}

