/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Date;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowInsertInterface;
import org.hsqldb.scriptio.ScriptWriterText;

public class RowInsertSimple
implements RowInsertInterface {
    final Session session;
    final RowInsertInterface.ErrorLogger callback;
    final int mode;

    public RowInsertSimple(Session session, RowInsertInterface.ErrorLogger errorLogger, int n) {
        this.session = session;
        this.callback = errorLogger;
        this.mode = n;
    }

    @Override
    public void finishTable() {
    }

    @Override
    public void close() {
        this.callback.close();
    }

    @Override
    public long getErrorLineNumber() {
        return 0L;
    }

    @Override
    public void insert(Table table, PersistentStore persistentStore, Object[] objectArray) {
        table.insertFromScript(this.session, persistentStore, objectArray);
    }

    @Override
    public void setStartLineNumber(long l) {
    }

    public static class DefaultErrorHandler
    implements RowInsertInterface.ErrorLogger {
        @Override
        public void writeLogStatement(long l, String string) {
        }

        @Override
        public void writeRow(long l, Row row) {
        }

        @Override
        public void close() {
        }
    }

    public static class InsertErrorHandler
    implements RowInsertInterface.ErrorLogger {
        Database database;
        String fileNamePath;
        ScriptWriterText scrwriter;

        public InsertErrorHandler(Database database, String string) {
            this.database = database;
            this.fileNamePath = string;
        }

        @Override
        public void writeLogStatement(long l, String string) {
            this.setScrWriter();
            try {
                this.scrwriter.writeLogStatement(null, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void writeRow(long l, Row row) {
            this.setScrWriter();
            try {
                this.scrwriter.writeInsertStatement(null, row, (Table)row.getTable());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void close() {
            if (this.scrwriter != null) {
                this.scrwriter.close();
            }
        }

        private void setScrWriter() {
            if (this.scrwriter == null) {
                String string = this.database.logger.fileDateFormat.format(new Date());
                String string2 = this.fileNamePath + "." + string + ".reject";
                this.scrwriter = new ScriptWriterText(this.database, string2, false, false, true);
            }
        }
    }
}

