/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class ElementSupport {
    private ElementSupport() {
    }

    public static void adoptElement(@Nonnull Document adopter, @Nonnull Element adoptee) {
        Constraint.isNotNull(adoptee, "Adoptee Element may not be null");
        Constraint.isNotNull(adopter, "Adopter Element may not be null");
        if (!adoptee.getOwnerDocument().isSameNode(adopter) && adopter.adoptNode(adoptee) == null) {
            throw new RuntimeException("DOM Element node adoption failed. This is most likely caused by the Element and Document being produced by different DOM implementations.");
        }
    }

    public static void appendChildElement(@Nonnull Element parentElement, @Nonnull Element childElement) {
        Constraint.isNotNull(parentElement, "Parent Element may not be null");
        Constraint.isNotNull(childElement, "Child Element may not be null");
        Document parentDocument = parentElement.getOwnerDocument();
        if (!parentDocument.equals(childElement.getOwnerDocument())) {
            ElementSupport.adoptElement(parentDocument, childElement);
        }
        parentElement.appendChild(childElement);
    }

    public static void appendTextContent(@Nonnull Element element, @Nullable String textContent) {
        if (textContent == null) {
            return;
        }
        Constraint.isNotNull(element, "Element may not be null");
        Text textNode = element.getOwnerDocument().createTextNode(textContent);
        element.appendChild(textNode);
    }

    @Nonnull
    public static Element constructElement(@Nonnull Document document, @Nonnull QName elementName) {
        Constraint.isNotNull(elementName, "Element name cannot be null");
        return ElementSupport.constructElement(document, elementName.getNamespaceURI(), QNameSupport.ensureLocalPart(elementName), elementName.getPrefix());
    }

    @Nonnull
    public static Element constructElement(@Nonnull Document document, @Nullable String namespaceURI, @Nonnull String localName, @Nullable String prefix) {
        Constraint.isNotNull(document, "Document may not be null");
        String trimmedLocalName = Constraint.isNotNull(StringSupport.trimOrNull(localName), "Element local name may not be null or empty");
        String trimmedPrefix = StringSupport.trimOrNull(prefix);
        Object qualifiedName = trimmedPrefix != null ? trimmedPrefix + ":" + trimmedLocalName : trimmedLocalName;
        return document.createElementNS(StringSupport.trimOrNull(namespaceURI), (String)qualifiedName);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<Element> getChildElements(@Nonnull Node root) {
        ArrayList<Element> children = new ArrayList<Element>();
        Element childNode = ElementSupport.getFirstChildElement(root);
        while (childNode != null) {
            children.add(childNode);
            childNode = ElementSupport.getNextSiblingElement(childNode);
        }
        return CollectionSupport.copyToList(children);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<Element> getChildElements(@Nonnull Node root, @Nonnull QName name) {
        return ElementSupport.getChildElementsByTagNameNS(root, name.getNamespaceURI(), QNameSupport.ensureLocalPart(name));
    }

    @Nullable
    public static Element getFirstChildElement(@Nonnull Node root, @Nonnull QName name) {
        List<Element> elements = ElementSupport.getChildElements(root, name);
        if (elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<Element> getChildElementsByTagName(@Nonnull Node root, @Nonnull String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        Element childNode = ElementSupport.getFirstChildElement(root);
        while (childNode != null) {
            if (Objects.equals(childNode.getLocalName(), localName)) {
                children.add(childNode);
            }
            childNode = ElementSupport.getNextSiblingElement(childNode);
        }
        return CollectionSupport.copyToList(children);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<Element> getChildElementsByTagNameNS(@Nonnull Node root, @Nullable String namespaceURI, @Nonnull String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        Element childNode = ElementSupport.getFirstChildElement(root);
        while (childNode != null) {
            if (ElementSupport.isElementNamed(childNode, namespaceURI, localName)) {
                children.add(childNode);
            }
            childNode = ElementSupport.getNextSiblingElement(childNode);
        }
        return CollectionSupport.copyToList(children);
    }

    @Nullable
    public static Element getElementAncestor(@Nonnull Node currentNode) {
        Node parent = currentNode.getParentNode();
        if (parent != null) {
            if (parent.getNodeType() == 1) {
                return (Element)parent;
            }
            return ElementSupport.getElementAncestor(parent);
        }
        return null;
    }

    @Nonnull
    public static String getElementContentAsString(@Nonnull Element element) {
        StringBuilder builder = new StringBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            builder.append(((Text)node).getNodeValue());
        }
        return builder.toString();
    }

    @Nonnull
    public static List<String> getElementContentAsList(@Nonnull Element element) {
        return StringSupport.stringToList(ElementSupport.getElementContentAsString(element), " \n\r\t");
    }

    @Nullable
    public static QName getElementContentAsQName(@Nonnull Element element) {
        String elementContent = StringSupport.trimOrNull(ElementSupport.getElementContentAsString(element));
        if (elementContent == null) {
            return null;
        }
        QName result = null;
        String[] valueComponents = elementContent.split(":");
        if (valueComponents.length == 1) {
            result = QNameSupport.constructQName(element.lookupNamespaceURI(null), valueComponents[0], null);
        } else if (valueComponents.length == 2) {
            result = QNameSupport.constructQName(element.lookupNamespaceURI(valueComponents[0]), valueComponents[1], valueComponents[0]);
        }
        return result;
    }

    @Nullable
    public static Element getFirstChildElement(@Nonnull Node n) {
        Node child;
        for (child = n.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return child != null ? (Element)child : null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static Map<QName, List<Element>> getIndexedChildElements(@Nonnull Element root) {
        HashMap<QName, ArrayList<Element>> children = new HashMap<QName, ArrayList<Element>>();
        Element e = ElementSupport.getFirstChildElement(root);
        while (e != null) {
            QName qname = QNameSupport.getNodeQName(e);
            ArrayList<Element> elements = (ArrayList<Element>)children.get(qname);
            if (elements == null) {
                elements = new ArrayList<Element>();
                children.put(qname, elements);
            }
            elements.add(e);
            e = ElementSupport.getNextSiblingElement(e);
        }
        return CollectionSupport.copyToMap(children);
    }

    @Nullable
    public static Element getNextSiblingElement(@Nonnull Node n) {
        Node sib;
        for (sib = n.getNextSibling(); sib != null && sib.getNodeType() != 1; sib = sib.getNextSibling()) {
        }
        return sib != null ? (Element)sib : null;
    }

    public static boolean isElementNamed(@Nonnull Element e, @Nonnull QName name) {
        return ElementSupport.isElementNamed(e, name.getNamespaceURI(), QNameSupport.ensureLocalPart(name));
    }

    public static boolean isElementNamed(@Nonnull Element e, @Nullable String ns, @Nonnull String localName) {
        return e != null && Objects.equals(ns, e.getNamespaceURI()) && Objects.equals(localName, e.getLocalName());
    }

    public static void setDocumentElement(@Nonnull Document document, @Nonnull Element element) {
        Constraint.isNotNull(document, "Document may not be null");
        Constraint.isNotNull(element, "Element may not be null");
        Element rootElement = document.getDocumentElement();
        if (rootElement == null) {
            ElementSupport.adoptElement(document, element);
            document.appendChild(element);
        } else if (!rootElement.isSameNode(element)) {
            ElementSupport.adoptElement(document, element);
            document.replaceChild(element, rootElement);
        }
    }

    @Nonnull
    public static Document ensureOwnerDocument(@Nonnull Element e) {
        Document doc = e.getOwnerDocument();
        if (doc == null) {
            throw new IllegalStateException("Owner document was null");
        }
        return doc;
    }

    @Nonnull
    public static Element ensureDocumentElement(@Nonnull Document doc) {
        Element e = doc.getDocumentElement();
        if (e == null) {
            throw new IllegalStateException("Document element was null");
        }
        return e;
    }
}

