/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import jakarta.json.Json;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import org.apache.johnzon.mapper.internal.Streams;

@Produces(value={"application/json", "*/json", "*/*+json", "*/x-json", "*/javascript", "*/x-javascript"})
public class JsrMessageBodyWriter
implements MessageBodyWriter<JsonStructure> {
    private final JsonWriterFactory factory;
    private final boolean close;

    public JsrMessageBodyWriter() {
        this(Json.createWriterFactory(Collections.emptyMap()), false);
    }

    public JsrMessageBodyWriter(JsonWriterFactory factory, boolean closeStreams) {
        this.factory = factory;
        this.close = closeStreams;
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(aClass);
    }

    public long getSize(JsonStructure jsonStructure, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(JsonStructure jsonStructure, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        try (JsonWriter writer = null;){
            writer = this.factory.createWriter(this.close ? outputStream : Streams.noClose((OutputStream)outputStream));
            writer.write(jsonStructure);
        }
    }
}

