/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.nio.charset.StandardCharsets;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class StringSerializer
extends SimpleTypeSerializer<String> {
    public StringSerializer() {
        super(DataType.STRING);
    }

    @Override
    protected String readValue(Buffer buffer, GraphBinaryReader context) {
        byte[] bytes = new byte[buffer.readInt()];
        buffer.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    protected void writeValue(String value, Buffer buffer, GraphBinaryWriter context) {
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(stringBytes.length).writeBytes(stringBytes);
    }
}

